/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.Debug;
import com.db4o.Internal4;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.Rename;
import com.db4o.config.Configuration;
import com.db4o.config.Entry;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.OldFormatException;
import com.db4o.ext.StoredClass;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.IntIdGenerator;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.PersistentTimeStampIdGenerator;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataRepository;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.Message;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectAnalyzer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectContainerSpec;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReferenceSystemRegistry;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.StoredClassImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.WeakReferenceCollector;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.activation.LegacyActivationDepth;
import com.db4o.internal.activation.UnknownActivationDepth;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.callbacks.NullCallbacks;
import com.db4o.internal.cs.ClassInfoHelper;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.query.NativeQueryHandler;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.internal.replication.MigrationConnection;
import com.db4o.internal.slots.Pointer4;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.types.Db4oCollections;
import com.db4o.types.Db4oType;
import com.db4o.types.SecondClass;
import com.db4o.types.TransientClass;

public abstract class PartialObjectContainer
implements TransientClass,
Internal4,
ObjectContainerSpec {
    protected ClassMetadataRepository _classCollection;
    protected ClassInfoHelper _classMetaHelper = new ClassInfoHelper();
    protected Config4Impl _config;
    private int _stackDepth;
    private final ReferenceSystemRegistry _referenceSystemRegistry = new ReferenceSystemRegistry();
    private Tree _justPeeked;
    public final Object _lock;
    private List4 _pendingClassUpdates;
    final ObjectContainerBase _parent;
    int _showInternalClasses = 0;
    private List4 _stillToActivate;
    private List4 _stillToDeactivate;
    private List4 _stillToSet;
    private Transaction _systemTransaction;
    protected Transaction _transaction;
    private boolean _instantiating;
    public HandlerRegistry _handlers;
    int _replicationCallState;
    WeakReferenceCollector _references;
    private NativeQueryHandler _nativeQueryHandler;
    private final ObjectContainerBase _this;
    private Callbacks _callbacks = new NullCallbacks();
    protected final PersistentTimeStampIdGenerator _timeStampIdGenerator = new PersistentTimeStampIdGenerator();
    private int _topLevelCallId = 1;
    private IntIdGenerator _topLevelCallIdGenerator = new IntIdGenerator();
    private boolean _topLevelCallCompleted;

    protected PartialObjectContainer(Configuration configuration, ObjectContainerBase objectContainerBase) {
        this._this = PartialObjectContainer.cast(this);
        this._parent = objectContainerBase == null ? this._this : objectContainerBase;
        this._lock = objectContainerBase == null ? new Object() : objectContainerBase._lock;
        this._config = (Config4Impl)configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() throws OldFormatException {
        boolean bl = false;
        Object object = this._lock;
        synchronized (object) {
            try {
                this.initializeTransactions();
                this.initialize1(this._config);
                this.openImpl();
                this.initializePostOpen();
                Platform4.postOpen(PartialObjectContainer.cast(this._this));
                bl = true;
            }
            finally {
                if (!bl) {
                    this.shutdownObjectContainer();
                }
            }
        }
    }

    protected abstract void openImpl() throws Db4oIOException;

    public ActivationDepth defaultActivationDepth(ClassMetadata classMetadata) {
        return this.activationDepthProvider().activationDepthFor(classMetadata, ActivationMode.ACTIVATE);
    }

    public ActivationDepthProvider activationDepthProvider() {
        return this.configImpl().activationDepthProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            this.activate(this.checkTransaction(transaction), object, this.defaultActivationDepthForObject(object));
        }
    }

    private final ActivationDepth defaultActivationDepthForObject(Object object) {
        ClassMetadata classMetadata = this.classMetadataForObject(object);
        return this.defaultActivationDepth(classMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate(Transaction transaction, Object object, ActivationDepth activationDepth) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            this.beginTopLevelCall();
            try {
                this.stillToActivate(transaction, object, activationDepth);
                this.activatePending(transaction);
                this.completeTopLevelCall();
            }
            catch (Db4oException db4oException) {
                this.completeTopLevelCall(db4oException);
            }
            finally {
                this.endTopLevelCall();
            }
        }
    }

    final void activatePending(Transaction transaction) {
        while (this._stillToActivate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._stillToActivate);
            this._stillToActivate = null;
            while (iterator4Impl.moveNext()) {
                PendingActivation pendingActivation = (PendingActivation)iterator4Impl.current();
                ObjectReference objectReference = pendingActivation.ref;
                Object object = objectReference.getObject();
                if (object == null) {
                    transaction.removeReference(objectReference);
                    continue;
                }
                objectReference.activateInternal(transaction, object, pendingActivation.depth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bind(Transaction transaction, Object object, long l) throws ArgumentNullException, IllegalArgumentException {
        Object object2 = this._lock;
        synchronized (object2) {
            if (object == null) {
                throw new ArgumentNullException();
            }
            if (DTrace.enabled) {
                DTrace.BIND.log(l, " ihc " + System.identityHashCode(object));
            }
            transaction = this.checkTransaction(transaction);
            int n = (int)l;
            Object object3 = this.getByID(transaction, l);
            if (object3 == null) {
                throw new IllegalArgumentException("id");
            }
            ObjectReference objectReference = transaction.referenceForId(n);
            if (objectReference == null) {
                throw new IllegalArgumentException("obj");
            }
            if (transaction.reflector().forObject(object) != objectReference.classMetadata().classReflector()) {
                throw new RuntimeException(Messages.get(57));
            }
            ObjectReference objectReference2 = this.bind2(transaction, objectReference, object);
            objectReference2.virtualAttributes(transaction);
        }
    }

    public final ObjectReference bind2(Transaction transaction, ObjectReference objectReference, Object object) {
        int n = objectReference.getID();
        transaction.removeReference(objectReference);
        ObjectReference objectReference2 = new ObjectReference(this.classMetadataForObject(object), n);
        objectReference2.setObjectWeak(this._this, object);
        objectReference2.setStateDirty();
        transaction.referenceSystem().addExistingReference(objectReference2);
        return objectReference2;
    }

    public ClassMetadata classMetadataForObject(Object object) {
        return this.classMetadataForReflectClass(this.reflector().forObject(object));
    }

    public abstract byte blockSize();

    public final int bytesToBlocks(long l) {
        byte by = this.blockSize();
        return (int)((l + (long)by - 1L) / (long)by);
    }

    public final int blockAlignedBytes(int n) {
        return this.bytesToBlocks(n) * this.blockSize();
    }

    public final int blocksToBytes(int n) {
        return n * this.blockSize();
    }

    private final boolean breakDeleteForEnum(ObjectReference objectReference, boolean bl) {
        if (bl) {
            return false;
        }
        if (objectReference == null) {
            return false;
        }
        return Platform4.isEnum(this.reflector(), objectReference.classMetadata().classReflector());
    }

    boolean canUpdate() {
        return true;
    }

    public final void checkClosed() throws DatabaseClosedException {
        if (this._classCollection == null) {
            throw new DatabaseClosedException();
        }
    }

    protected final void checkReadOnly() throws DatabaseReadOnlyException {
        if (this._config.isReadOnly()) {
            throw new DatabaseReadOnlyException();
        }
    }

    final void processPendingClassUpdates() {
        if (this._pendingClassUpdates == null) {
            return;
        }
        Iterator4Impl iterator4Impl = new Iterator4Impl(this._pendingClassUpdates);
        while (iterator4Impl.moveNext()) {
            ClassMetadata classMetadata = (ClassMetadata)iterator4Impl.current();
            classMetadata.setStateDirty();
            classMetadata.write(this._systemTransaction);
        }
        this._pendingClassUpdates = null;
    }

    public final Transaction checkTransaction() {
        return this.checkTransaction(null);
    }

    public final Transaction checkTransaction(Transaction transaction) {
        this.checkClosed();
        if (transaction != null) {
            return transaction;
        }
        return this.transaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean close() {
        Object object = this._lock;
        synchronized (object) {
            if (DTrace.enabled) {
                DTrace.CLOSE_CALLED.logStack(this.toString());
            }
            this.close1();
            return true;
        }
    }

    protected void handleExceptionOnClose(Exception exception) {
        this.fatalException(exception);
    }

    private void close1() {
        if (this._classCollection == null) {
            return;
        }
        Platform4.preClose(PartialObjectContainer.cast(this._this));
        this.processPendingClassUpdates();
        if (this.stateMessages()) {
            this.logMsg(2, this.toString());
        }
        this.close2();
    }

    protected abstract void close2();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownObjectContainer() {
        if (DTrace.enabled) {
            DTrace.CLOSE.log();
        }
        this.logMsg(3, this.toString());
        Object object = this._lock;
        synchronized (object) {
            this.stopSession();
            this.shutdownDataStorage();
        }
    }

    protected abstract void shutdownDataStorage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oCollections collections(Transaction transaction) {
        Object object = this._lock;
        synchronized (object) {
            return Platform4.collections(this.checkTransaction(transaction));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(Transaction transaction) throws DatabaseReadOnlyException, DatabaseClosedException {
        Object object = this._lock;
        synchronized (object) {
            if (DTrace.enabled) {
                DTrace.COMMIT.log();
            }
            transaction = this.checkTransaction(transaction);
            this.checkReadOnly();
            this.beginTopLevelCall();
            try {
                this.commit1(transaction);
                transaction.commitReferenceSystem();
                this.completeTopLevelCall();
            }
            catch (Db4oException db4oException) {
                this.completeTopLevelCall(db4oException);
            }
            finally {
                this.endTopLevelCall();
            }
        }
    }

    public abstract void commit1(Transaction var1);

    public Configuration configure() {
        return this.configImpl();
    }

    public Config4Impl config() {
        return this.configImpl();
    }

    public abstract int converterVersion();

    public abstract AbstractQueryResult newQueryResult(Transaction var1, QueryEvaluationMode var2);

    protected void createStringIO(byte by) {
        this.stringIO(LatinStringIO.forEncoding(by));
    }

    protected final void initializeTransactions() {
        this._systemTransaction = this.newTransaction(null, this.createReferenceSystem());
        this._transaction = this.newUserTransaction();
    }

    public abstract Transaction newTransaction(Transaction var1, TransactionalReferenceSystem var2);

    public Transaction newUserTransaction() {
        return this.newTransaction(this.systemTransaction(), null);
    }

    public abstract long currentVersion();

    public boolean createClassMetadata(ClassMetadata classMetadata, ReflectClass reflectClass, ClassMetadata classMetadata2) {
        return classMetadata.init(this._this, classMetadata2, reflectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oType db4oTypeStored(Transaction transaction, Object object) {
        if (!(object instanceof Db4oDatabase)) {
            return null;
        }
        Db4oDatabase db4oDatabase = (Db4oDatabase)object;
        if (transaction.referenceForObject(object) != null) {
            return db4oDatabase;
        }
        this.showInternalClasses(true);
        try {
            Db4oDatabase db4oDatabase2 = db4oDatabase.query(transaction);
            return db4oDatabase2;
        }
        finally {
            this.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Transaction transaction, Object object, int n) throws DatabaseClosedException {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            this.beginTopLevelCall();
            try {
                this.deactivateInternal(transaction, object, this.activationDepthProvider().activationDepth(n, ActivationMode.DEACTIVATE));
                this.completeTopLevelCall();
            }
            catch (Db4oException db4oException) {
                this.completeTopLevelCall(db4oException);
            }
            finally {
                this.endTopLevelCall();
            }
        }
    }

    private final void deactivateInternal(Transaction transaction, Object object, ActivationDepth activationDepth) {
        this.stillToDeactivate(transaction, object, activationDepth, true);
        this.deactivatePending(transaction);
    }

    private void deactivatePending(Transaction transaction) {
        while (this._stillToDeactivate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._stillToDeactivate);
            this._stillToDeactivate = null;
            while (iterator4Impl.moveNext()) {
                PendingActivation pendingActivation = (PendingActivation)iterator4Impl.current();
                pendingActivation.ref.deactivate(transaction, pendingActivation.depth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(Transaction transaction, Object object) throws DatabaseReadOnlyException, DatabaseClosedException {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            this.checkReadOnly();
            this.delete1(transaction, object, true);
            transaction.processDeletes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete1(Transaction transaction, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        ObjectReference objectReference = transaction.referenceForObject(object);
        if (objectReference == null) {
            return;
        }
        if (bl) {
            this.generateCallIDOnTopLevel();
        }
        try {
            this.beginTopLevelCall();
            this.delete2(transaction, objectReference, object, 0, bl);
            this.completeTopLevelCall();
        }
        catch (Db4oException db4oException) {
            this.completeTopLevelCall(db4oException);
        }
        finally {
            this.endTopLevelCall();
        }
    }

    public final void delete2(Transaction transaction, ObjectReference objectReference, Object object, int n, boolean bl) {
        if (this.breakDeleteForEnum(objectReference, bl)) {
            return;
        }
        if (object instanceof SecondClass) {
            if (!this.flagForDelete(objectReference)) {
                return;
            }
            this.delete3(transaction, objectReference, n, bl);
            return;
        }
        transaction.delete(objectReference, objectReference.getID(), n);
    }

    final void delete3(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        if (objectReference == null || !objectReference.beginProcessing()) {
            return;
        }
        if (this.breakDeleteForEnum(objectReference, bl)) {
            objectReference.endProcessing();
            return;
        }
        if (!objectReference.isFlaggedForDelete()) {
            objectReference.endProcessing();
            return;
        }
        ClassMetadata classMetadata = objectReference.classMetadata();
        Object object = objectReference.getObject();
        objectReference.endProcessing();
        this.activateForDeletionCallback(transaction, classMetadata, object);
        if (!this.objectCanDelete(transaction, classMetadata, object)) {
            return;
        }
        objectReference.beginProcessing();
        if (DTrace.enabled) {
            DTrace.DELETE.log(objectReference.getID());
        }
        if (this.delete4(transaction, objectReference, n, bl)) {
            this.objectOnDelete(transaction, classMetadata, object);
            if (this.configImpl().messageLevel() > 1) {
                this.message("" + objectReference.getID() + " delete " + objectReference.classMetadata().getName());
            }
        }
        objectReference.endProcessing();
    }

    private void activateForDeletionCallback(Transaction transaction, ClassMetadata classMetadata, Object object) {
        if (!this.isActive(transaction, object) && (this.caresAboutDeleting(classMetadata) || this.caresAboutDeleted(classMetadata))) {
            this.activate(transaction, object, new FixedActivationDepth(1));
        }
    }

    private boolean caresAboutDeleting(ClassMetadata classMetadata) {
        return this._callbacks.caresAboutDeleting() || classMetadata.hasEventRegistered(this._this, 0);
    }

    private boolean caresAboutDeleted(ClassMetadata classMetadata) {
        return this._callbacks.caresAboutDeleted() || classMetadata.hasEventRegistered(this._this, 1);
    }

    private boolean objectCanDelete(Transaction transaction, ClassMetadata classMetadata, Object object) {
        return this._this.callbacks().objectCanDelete(transaction, object) && classMetadata.dispatchEvent(this._this, object, 0);
    }

    private void objectOnDelete(Transaction transaction, ClassMetadata classMetadata, Object object) {
        this._this.callbacks().objectOnDelete(transaction, object);
        classMetadata.dispatchEvent(this._this, object, 1);
    }

    public abstract boolean delete4(Transaction var1, ObjectReference var2, int var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object descend(Transaction transaction, Object object, String[] stringArray) {
        Object object2 = this._lock;
        synchronized (object2) {
            Object object3;
            transaction = this.checkTransaction(transaction);
            ObjectReference objectReference = transaction.referenceForObject(object);
            if (objectReference == null) {
                return null;
            }
            final String string = stringArray[0];
            if (string == null) {
                return null;
            }
            ClassMetadata classMetadata = objectReference.classMetadata();
            final FieldMetadata[] fieldMetadataArray = new FieldMetadata[]{null};
            classMetadata.forEachFieldMetadata(new Visitor4(){

                public void visit(Object object) {
                    FieldMetadata fieldMetadata = (FieldMetadata)object;
                    if (fieldMetadata.canAddToQuery(string)) {
                        fieldMetadataArray[0] = fieldMetadata;
                    }
                }
            });
            if (fieldMetadataArray[0] == null) {
                return null;
            }
            Object object4 = object3 = objectReference.isActive() ? fieldMetadataArray[0].get(transaction, object) : this.descendMarshallingContext(transaction, objectReference).readFieldValue(fieldMetadataArray[0]);
            if (stringArray.length == 1) {
                return object3;
            }
            if (object3 == null) {
                return null;
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            return this.descend(transaction, object3, stringArray2);
        }
    }

    private UnmarshallingContext descendMarshallingContext(Transaction transaction, ObjectReference objectReference) {
        UnmarshallingContext unmarshallingContext = new UnmarshallingContext(transaction, objectReference, 1, false);
        unmarshallingContext.activationDepth(this.activationDepthProvider().activationDepth(1, ActivationMode.ACTIVATE));
        return unmarshallingContext;
    }

    public boolean detectSchemaChanges() {
        return this.configImpl().detectSchemaChanges();
    }

    public boolean dispatchsEvents() {
        return true;
    }

    protected boolean doFinalize() {
        return true;
    }

    final void shutdownHook() {
        if (this.isClosed()) {
            return;
        }
        if (this.allOperationsCompleted()) {
            Messages.logErr(this.configImpl(), 50, this.toString(), null);
            this.close();
        } else {
            this.shutdownObjectContainer();
            if (this.operationIsProcessing()) {
                Messages.logErr(this.configImpl(), 24, null, null);
            }
        }
    }

    private boolean operationIsProcessing() {
        return this._stackDepth > 0;
    }

    private boolean allOperationsCompleted() {
        return this._stackDepth == 0;
    }

    void fatalException(int n) {
        this.fatalException(null, n);
    }

    final void fatalException(Throwable throwable) {
        this.fatalException(throwable, 44);
    }

    final void fatalException(Throwable throwable, int n) {
        if (DTrace.enabled) {
            DTrace.FATAL_EXCEPTION.log(throwable.toString());
        }
        Messages.logErr(this.configImpl(), n == 44 ? 18 : n, null, throwable);
        if (!this.isClosed()) {
            this.shutdownObjectContainer();
        }
        throw new RuntimeException(Messages.get(n));
    }

    protected void finalize() {
        if (this.doFinalize() && this.configuredForAutomaticShutDown()) {
            this.shutdownHook();
        }
    }

    private boolean configuredForAutomaticShutDown() {
        return this.configImpl() == null || this.configImpl().automaticShutDown();
    }

    void gc() {
        this._references.pollReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectSet get(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            QueryResult queryResult = null;
            try {
                this.beginTopLevelCall();
                queryResult = this.getInternal(transaction, object);
                this.completeTopLevelCall();
            }
            catch (Db4oException db4oException) {
                this.completeTopLevelCall(db4oException);
            }
            finally {
                this.endTopLevelCall();
            }
            return new ObjectSetFacade(queryResult);
        }
    }

    private final QueryResult getInternal(Transaction transaction, Object object) {
        if (object == null || object.getClass() == Const4.CLASS_OBJECT) {
            return this.getAll(transaction);
        }
        Query query = this.query(transaction);
        query.constrain(object);
        return this.executeQuery((QQuery)query);
    }

    public abstract AbstractQueryResult getAll(Transaction var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getByID(Transaction transaction, long l) throws DatabaseClosedException, InvalidIDException {
        Object object = this._lock;
        synchronized (object) {
            if (l <= 0L || l >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.checkClosed();
            transaction = this.checkTransaction(transaction);
            this.beginTopLevelCall();
            try {
                Object object2 = this.getByID2(transaction, (int)l);
                this.completeTopLevelCall();
                Object object3 = object2;
                return object3;
            }
            catch (Db4oException db4oException) {
                this.completeTopLevelCall(new InvalidIDException(db4oException));
            }
            finally {
                this.endTopLevelCall();
            }
            return null;
        }
    }

    public final Object getByID2(Transaction transaction, int n) {
        Object object = transaction.objectForIdFromCache(n);
        if (object != null) {
            return object;
        }
        return new ObjectReference(n).read(transaction, new LegacyActivationDepth(0), 1, true);
    }

    public final Object getActivatedObjectFromCache(Transaction transaction, int n) {
        Object object = transaction.objectForIdFromCache(n);
        if (object == null) {
            return null;
        }
        this.activate(transaction, object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readActivatedObjectNotInCache(Transaction transaction, int n) {
        Object object = null;
        this.beginTopLevelCall();
        try {
            object = new ObjectReference(n).read(transaction, UnknownActivationDepth.INSTANCE, 1, true);
            this.completeTopLevelCall();
        }
        catch (Db4oException db4oException) {
            this.completeTopLevelCall(db4oException);
        }
        finally {
            this.endTopLevelCall();
        }
        this.activatePending(transaction);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getByUUID(Transaction transaction, Db4oUUID db4oUUID) {
        Object object = this._lock;
        synchronized (object) {
            if (db4oUUID == null) {
                return null;
            }
            transaction = this.checkTransaction(transaction);
            HardObjectReference hardObjectReference = transaction.getHardReferenceBySignature(db4oUUID.getLongPart(), db4oUUID.getSignaturePart());
            return hardObjectReference._object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getID(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            this.checkClosed();
            if (object == null) {
                return 0;
            }
            ObjectReference objectReference = transaction.referenceForObject(object);
            if (objectReference != null) {
                return objectReference.getID();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectInfo getObjectInfo(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            return transaction.referenceForObject(object);
        }
    }

    public final HardObjectReference getHardObjectReferenceById(Transaction transaction, int n) {
        Object object;
        if (n <= 0) {
            return HardObjectReference.INVALID;
        }
        ObjectReference objectReference = transaction.referenceForId(n);
        if (objectReference != null) {
            object = objectReference.getObject();
            if (object != null) {
                return new HardObjectReference(objectReference, object);
            }
            transaction.removeReference(objectReference);
        }
        if ((object = (objectReference = new ObjectReference(n)).read(transaction, new LegacyActivationDepth(0), 1, true)) == null) {
            return HardObjectReference.INVALID;
        }
        if (object != objectReference.getObject()) {
            return this.getHardObjectReferenceById(transaction, n);
        }
        return new HardObjectReference(objectReference, object);
    }

    public final StatefulBuffer getWriter(Transaction transaction, int n, int n2) {
        if (Debug.exceedsMaximumBlockSize(n2)) {
            return null;
        }
        return new StatefulBuffer(transaction, n, n2);
    }

    public final Transaction systemTransaction() {
        return this._systemTransaction;
    }

    public final Transaction transaction() {
        return this._transaction;
    }

    public final ClassMetadata classMetadataForReflectClass(ReflectClass reflectClass) {
        if (this.cantGetClassMetadata(reflectClass)) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForClass(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.classMetadataForReflectClass(reflectClass);
    }

    public ClassMetadata produceClassMetadata(ReflectClass reflectClass) {
        if (this.cantGetClassMetadata(reflectClass)) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForClass(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.produceClassMetadata(reflectClass);
    }

    final ClassMetadata getActiveClassMetadata(ReflectClass reflectClass) {
        if (this.cantGetClassMetadata(reflectClass)) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForClass(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.getActiveClassMetadata(reflectClass);
    }

    private final boolean cantGetClassMetadata(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return true;
        }
        return !this.showInternalClasses() && this._handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass);
    }

    public int classMetadataIdForName(String string) {
        return this._classCollection.classMetadataIdForName(string);
    }

    public ClassMetadata classMetadataForName(String string) {
        return this.classMetadataForId(this.classMetadataIdForName(string));
    }

    public ClassMetadata classMetadataForId(int n) {
        if (DTrace.enabled) {
            DTrace.YAPCLASS_BY_ID.log(n);
        }
        if (n == 0) {
            return null;
        }
        ClassMetadata classMetadata = this._handlers.classMetadataForId(n);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.getClassMetadata(n);
    }

    public HandlerRegistry handlers() {
        return this._handlers;
    }

    public boolean needsLockFileThread() {
        if (!Platform4.hasLockFileThread()) {
            return false;
        }
        if (Platform4.hasNio()) {
            return false;
        }
        if (this.configImpl().isReadOnly()) {
            return false;
        }
        return this.configImpl().lockFile();
    }

    protected boolean hasShutDownHook() {
        return this.configImpl().automaticShutDown();
    }

    protected void initialize1(Configuration configuration) {
        this._config = this.initializeConfig(configuration);
        this._handlers = new HandlerRegistry(this._this, this.configImpl().encoding(), this.configImpl().reflector());
        if (this._references != null) {
            this.gc();
            this._references.stopTimer();
        }
        this._references = new WeakReferenceCollector(this._this);
        if (this.hasShutDownHook()) {
            Platform4.addShutDownHook(this);
        }
        this._handlers.initEncryption(this.configImpl());
        this.initialize2();
        this._stillToSet = null;
    }

    private Config4Impl initializeConfig(Configuration configuration) {
        Config4Impl config4Impl = (Config4Impl)configuration;
        config4Impl.stream(this._this);
        config4Impl.reflector().setTransaction(this.systemTransaction());
        return config4Impl;
    }

    void initialize2() {
        this.initialize2NObjectCarrier();
    }

    public final TransactionalReferenceSystem createReferenceSystem() {
        TransactionalReferenceSystem transactionalReferenceSystem = new TransactionalReferenceSystem();
        this._referenceSystemRegistry.addReferenceSystem(transactionalReferenceSystem);
        return transactionalReferenceSystem;
    }

    void initialize2NObjectCarrier() {
        this._classCollection = new ClassMetadataRepository(this._systemTransaction);
        this._references.startTimer();
    }

    private void initializePostOpen() {
        this._showInternalClasses = 100000;
        this.initializePostOpenExcludingTransportObjectContainer();
        this._showInternalClasses = 0;
    }

    protected void initializePostOpenExcludingTransportObjectContainer() {
        this.initializeEssentialClasses();
        this.rename(this.configImpl());
        this._classCollection.initOnUp(this._systemTransaction);
        if (this.configImpl().detectSchemaChanges()) {
            this._systemTransaction.commit();
        }
        this.configImpl().applyConfigurationItems(PartialObjectContainer.cast(this._this));
    }

    void initializeEssentialClasses() {
        for (int i = 0; i < Const4.ESSENTIAL_CLASSES.length; ++i) {
            this.produceClassMetadata(this.reflector().forClass(Const4.ESSENTIAL_CLASSES[i]));
        }
    }

    final void instantiating(boolean bl) {
        this._instantiating = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isActive(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            ObjectReference objectReference;
            transaction = this.checkTransaction(transaction);
            if (object != null && (objectReference = transaction.referenceForObject(object)) != null) {
                return objectReference.isActive();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(Transaction transaction, long l) {
        Object object = this._lock;
        synchronized (object) {
            transaction = this.checkTransaction(transaction);
            return transaction.objectForIdFromCache((int)l) != null;
        }
    }

    public boolean isClient() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        Object object = this._lock;
        synchronized (object) {
            return this._classCollection == null;
        }
    }

    public final boolean isInstantiating() {
        return this._instantiating;
    }

    boolean isServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStored(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            if (object == null) {
                return false;
            }
            ObjectReference objectReference = transaction.referenceForObject(object);
            if (objectReference == null) {
                return false;
            }
            return !transaction.isDeleted(objectReference.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass[] knownClasses() {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            return this.reflector().knownClasses();
        }
    }

    public TypeHandler4 handlerByID(int n) {
        if (n < 1) {
            return null;
        }
        if (this._handlers.isSystemHandler(n)) {
            return this._handlers.handlerForID(n);
        }
        return this.classMetadataForId(n);
    }

    public Object lock() {
        return this._lock;
    }

    public final void logMsg(int n, String string) {
        Messages.logMsg(this.configImpl(), n, string);
    }

    public boolean maintainsIndices() {
        return true;
    }

    void message(String string) {
        new Message(this._this, string);
    }

    public void migrateFrom(ObjectContainer objectContainer) {
        if (objectContainer == null) {
            if (this._replicationCallState == 0) {
                return;
            }
            this._replicationCallState = 0;
            if (this._handlers.i_migration != null) {
                this._handlers.i_migration.terminate();
            }
            this._handlers.i_migration = null;
        } else {
            ObjectContainerBase objectContainerBase = (ObjectContainerBase)((Object)objectContainer);
            this._replicationCallState = -1;
            objectContainerBase._replicationCallState = -1;
            objectContainerBase._handlers.i_migration = this._handlers.i_migration = new MigrationConnection(this._this, (ObjectContainerBase)((Object)objectContainer));
        }
    }

    public final void needsUpdate(ClassMetadata classMetadata) {
        this._pendingClassUpdates = new List4(this._pendingClassUpdates, classMetadata);
    }

    public long generateTimeStampId() {
        return this._timeStampIdGenerator.next();
    }

    public abstract int newUserObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object peekPersisted(Transaction transaction, Object object, ActivationDepth activationDepth, boolean bl) throws DatabaseClosedException {
        Object object2 = this._lock;
        synchronized (object2) {
            Object object3;
            this.checkClosed();
            this.beginTopLevelCall();
            try {
                transaction = this.checkTransaction(transaction);
                ObjectReference objectReference = transaction.referenceForObject(object);
                transaction = bl ? this._systemTransaction : transaction;
                Object object4 = null;
                if (objectReference != null) {
                    object4 = this.peekPersisted(transaction, objectReference.getID(), activationDepth, true);
                }
                this.completeTopLevelCall();
                object3 = object4;
            }
            catch (Db4oException db4oException) {
                Object var7_9;
                try {
                    this.completeTopLevelCall(db4oException);
                    var7_9 = null;
                    this.endTopLevelCall();
                }
                catch (Throwable throwable) {
                    this.endTopLevelCall();
                    throw throwable;
                }
                return var7_9;
            }
            this.endTopLevelCall();
            return object3;
        }
    }

    public final Object peekPersisted(Transaction transaction, int n, ActivationDepth activationDepth, boolean bl) {
        Object object;
        if (bl) {
            this._justPeeked = null;
        } else {
            object = new TreeInt(n);
            TreeIntObject treeIntObject = (TreeIntObject)Tree.find(this._justPeeked, (Tree)object);
            if (treeIntObject != null) {
                return treeIntObject._object;
            }
        }
        object = new ObjectReference(n).peekPersisted(transaction, activationDepth);
        if (bl) {
            this._justPeeked = null;
        }
        return object;
    }

    void peeked(int n, Object object) {
        this._justPeeked = Tree.add(this._justPeeked, new TreeIntObject(n, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            System.gc();
            System.runFinalization();
            System.gc();
            this.gc();
            this._classCollection.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void purge(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            transaction.removeObjectFromReferenceSystem(object);
        }
    }

    final void removeFromAllReferenceSystems(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof ObjectReference) {
            this._referenceSystemRegistry.removeReference((ObjectReference)object);
            return;
        }
        this._referenceSystemRegistry.removeObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NativeQueryHandler getNativeQueryHandler() {
        Object object = this._lock;
        synchronized (object) {
            if (null == this._nativeQueryHandler) {
                this._nativeQueryHandler = new NativeQueryHandler(PartialObjectContainer.cast(this._this));
            }
            return this._nativeQueryHandler;
        }
    }

    public final ObjectSet query(Transaction transaction, Predicate predicate) {
        return this.query(transaction, predicate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectSet query(Transaction transaction, Predicate predicate, QueryComparator queryComparator) {
        Object object = this._lock;
        synchronized (object) {
            transaction = this.checkTransaction(transaction);
            return this.getNativeQueryHandler().execute(this.query(transaction), predicate, queryComparator);
        }
    }

    public final ObjectSet query(Transaction transaction, Class clazz) {
        return this.get(transaction, clazz);
    }

    public final Query query(Transaction transaction) {
        return new QQuery(this.checkTransaction(transaction), null, null);
    }

    public abstract void raiseVersion(long var1);

    public abstract void readBytes(byte[] var1, int var2, int var3) throws Db4oIOException;

    public abstract void readBytes(byte[] var1, int var2, int var3, int var4) throws Db4oIOException;

    public final BufferImpl bufferByAddress(int n, int n2) throws Db4oIOException {
        this.checkAddress(n);
        BufferImpl bufferImpl = new BufferImpl(n2);
        this.readBytes(bufferImpl._buffer, n, n2);
        this._handlers.decrypt(bufferImpl);
        return bufferImpl;
    }

    private void checkAddress(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid address offset: " + n);
        }
    }

    public final StatefulBuffer readWriterByAddress(Transaction transaction, int n, int n2) throws Db4oIOException {
        this.checkAddress(n);
        StatefulBuffer statefulBuffer = this.getWriter(transaction, n, n2);
        statefulBuffer.readEncrypt(this._this, n);
        return statefulBuffer;
    }

    public abstract StatefulBuffer readWriterByID(Transaction var1, int var2);

    public abstract BufferImpl readReaderByID(Transaction var1, int var2);

    public abstract StatefulBuffer[] readWritersByIDs(Transaction var1, int[] var2);

    private void reboot() {
        this.commit(null);
        this.close();
        this.open();
    }

    public GenericReflector reflector() {
        return this._handlers._reflector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh(Transaction transaction, Object object, int n) {
        Object object2 = this._lock;
        synchronized (object2) {
            this.activate(transaction, object, this.refreshActivationDepth(n));
        }
    }

    private ActivationDepth refreshActivationDepth(int n) {
        return this.activationDepthProvider().activationDepth(n, ActivationMode.REFRESH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshClasses() {
        Object object = this._lock;
        synchronized (object) {
            this._classCollection.refreshClasses();
        }
    }

    public abstract void releaseSemaphore(String var1);

    public void flagAsHandled(ObjectReference objectReference) {
        objectReference.flagAsHandled(this._topLevelCallId);
    }

    boolean flagForDelete(ObjectReference objectReference) {
        if (objectReference == null) {
            return false;
        }
        if (this.handledInCurrentTopLevelCall(objectReference)) {
            return false;
        }
        objectReference.flagForDelete(this._topLevelCallId);
        return true;
    }

    public abstract void releaseSemaphores(Transaction var1);

    void rename(Config4Impl config4Impl) {
        boolean bl = false;
        if (config4Impl.rename() != null) {
            bl = this.rename1(config4Impl);
        }
        this._classCollection.checkChanges();
        if (bl) {
            this.reboot();
        }
    }

    protected boolean rename1(Config4Impl config4Impl) {
        boolean bl = false;
        Iterator4 iterator4 = config4Impl.rename().iterator();
        while (iterator4.moveNext()) {
            Object object;
            Rename rename = (Rename)iterator4.current();
            if (this.get(this.systemTransaction(), rename).size() != 0) continue;
            boolean bl2 = false;
            boolean bl3 = rename.rClass.length() > 0;
            ClassMetadata classMetadata = this._classCollection.getClassMetadata(bl3 ? rename.rClass : rename.rFrom);
            if (classMetadata != null) {
                if (bl3) {
                    bl2 = classMetadata.renameField(rename.rFrom, rename.rTo);
                } else {
                    object = this._classCollection.getClassMetadata(rename.rTo);
                    if (object == null) {
                        classMetadata.setName(rename.rTo);
                        bl2 = true;
                    } else {
                        this.logMsg(9, "class " + rename.rTo);
                    }
                }
            }
            if (!bl2) continue;
            bl = true;
            this.setDirtyInSystemTransaction(classMetadata);
            this.logMsg(8, rename.rFrom + " to " + rename.rTo);
            object = this.get(this.systemTransaction(), new Rename(rename.rClass, null, rename.rFrom));
            while (object.hasNext()) {
                this.delete(this.systemTransaction(), object.next());
            }
            this.set(this.systemTransaction(), rename);
        }
        return bl;
    }

    public final boolean handledInCurrentTopLevelCall(ObjectReference objectReference) {
        return objectReference.isFlaggedAsHandled(this._topLevelCallId);
    }

    public abstract void reserve(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback(Transaction transaction) {
        Object object = this._lock;
        synchronized (object) {
            transaction = this.checkTransaction(transaction);
            this.checkReadOnly();
            this.rollback1(transaction);
            transaction.rollbackReferenceSystem();
        }
    }

    public abstract void rollback1(Transaction var1);

    public void send(Object object) {
        throw new NotSupportedException();
    }

    public final void set(Transaction transaction, Object object) throws DatabaseClosedException, DatabaseReadOnlyException {
        this.set(transaction, object, -2147483548);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(Transaction transaction, Object object, int n) throws DatabaseClosedException, DatabaseReadOnlyException {
        Object object2 = this._lock;
        synchronized (object2) {
            this.setInternal(transaction, object, n, true);
        }
    }

    public final int setInternal(Transaction transaction, Object object, boolean bl) throws DatabaseClosedException, DatabaseReadOnlyException {
        return this.setInternal(transaction, object, -2147483548, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setInternal(Transaction transaction, Object object, int n, boolean bl) throws DatabaseClosedException, DatabaseReadOnlyException {
        transaction = this.checkTransaction(transaction);
        this.checkReadOnly();
        this.beginTopLevelSet();
        try {
            int n2 = this.setAfterReplication(transaction, object, n, bl);
            this.completeTopLevelSet();
            int n3 = n2;
            return n3;
        }
        catch (Db4oException db4oException) {
            this.completeTopLevelSet(db4oException);
            int n4 = 0;
            return n4;
        }
        finally {
            this.endTopLevelSet(transaction);
        }
    }

    public final int setAfterReplication(Transaction transaction, Object object, int n, boolean bl) {
        Db4oType db4oType;
        if (object instanceof Db4oType && (db4oType = this.db4oTypeStored(transaction, object)) != null) {
            return this.getID(transaction, db4oType);
        }
        return this.set2(transaction, object, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setByNewReplication(Db4oReplicationReferenceProvider db4oReplicationReferenceProvider, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            this._replicationCallState = 1;
            this._handlers._replicationReferenceProvider = db4oReplicationReferenceProvider;
            this.set2(this.checkTransaction(), object, 1, false);
            this._replicationCallState = 0;
            this._handlers._replicationReferenceProvider = null;
        }
    }

    private final int set2(Transaction transaction, Object object, int n, boolean bl) {
        int n2 = this.set3(transaction, object, n, bl);
        if (this.stackIsSmall()) {
            this.checkStillToSet();
        }
        return n2;
    }

    public void checkStillToSet() {
        List4 list4 = null;
        while (this._stillToSet != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._stillToSet);
            this._stillToSet = null;
            while (iterator4Impl.moveNext()) {
                PendingSet pendingSet = (PendingSet)iterator4Impl.current();
                ObjectReference objectReference = pendingSet.ref;
                Transaction transaction = pendingSet.transaction;
                if (objectReference.continueSet(transaction, pendingSet.depth)) continue;
                list4 = new List4(list4, pendingSet);
            }
        }
        this._stillToSet = list4;
    }

    void notStorable(ReflectClass reflectClass, Object object) {
        if (!this.configImpl().exceptionsOnNotStorable()) {
            return;
        }
    }

    public final int set3(Transaction transaction, Object object, int n, boolean bl) {
        if (object == null || object instanceof TransientClass) {
            return 0;
        }
        if (object instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)object).storedTo(transaction);
        }
        ObjectAnalyzer objectAnalyzer = new ObjectAnalyzer(this, object);
        objectAnalyzer.analyze(transaction);
        if (objectAnalyzer.notStorable()) {
            return 0;
        }
        ObjectReference objectReference = objectAnalyzer.objectReference();
        if (objectReference == null) {
            ClassMetadata classMetadata = objectAnalyzer.classMetadata();
            if (!this.objectCanNew(transaction, classMetadata, object)) {
                return 0;
            }
            objectReference = new ObjectReference();
            objectReference.store(transaction, classMetadata, object);
            transaction.addNewReference(objectReference);
            if (object instanceof Db4oTypeImpl) {
                ((Db4oTypeImpl)object).setTrans(transaction);
            }
            if (this.configImpl().messageLevel() > 1) {
                this.message("" + objectReference.getID() + " new " + objectReference.classMetadata().getName());
            }
            this.flagAsHandled(objectReference);
            this.stillToSet(transaction, objectReference, n);
        } else if (this.canUpdate()) {
            if (bl && !objectReference.isNew() && this.handledInCurrentTopLevelCall(objectReference)) {
                return objectReference.getID();
            }
            if (this.updateDepthSufficient(n)) {
                this.flagAsHandled(objectReference);
                objectReference.writeUpdate(transaction, n);
            }
        }
        this.processPendingClassUpdates();
        return objectReference.getID();
    }

    private final boolean updateDepthSufficient(int n) {
        return n == -2147483548 || n > 0;
    }

    private boolean objectCanNew(Transaction transaction, ClassMetadata classMetadata, Object object) {
        return this.callbacks().objectCanNew(transaction, object) && classMetadata.dispatchEvent(this._this, object, 8);
    }

    public abstract void setDirtyInSystemTransaction(PersistentBase var1);

    public abstract boolean setSemaphore(String var1, int var2);

    void stringIO(LatinStringIO latinStringIO) {
        this._handlers.stringIO(latinStringIO);
    }

    final boolean showInternalClasses() {
        return this.isServer() || this._showInternalClasses > 0;
    }

    public synchronized void showInternalClasses(boolean bl) {
        this._showInternalClasses = bl ? ++this._showInternalClasses : --this._showInternalClasses;
        if (this._showInternalClasses < 0) {
            this._showInternalClasses = 0;
        }
    }

    private final boolean stackIsSmall() {
        return this._stackDepth < 20;
    }

    boolean stateMessages() {
        return true;
    }

    final List4 stillTo1(Transaction transaction, List4 list4, Object object, ActivationDepth activationDepth, boolean bl) {
        ClassMetadata classMetadata;
        if (object == null || !activationDepth.requiresActivation()) {
            return list4;
        }
        ObjectReference objectReference = transaction.referenceForObject(object);
        if (objectReference != null) {
            if (this.handledInCurrentTopLevelCall(objectReference)) {
                return list4;
            }
            this.flagAsHandled(objectReference);
            return new List4(list4, new PendingActivation(objectReference, activationDepth));
        }
        ReflectClass reflectClass = this.reflector().forObject(object);
        if (reflectClass.isArray()) {
            if (!reflectClass.getComponentType().isPrimitive()) {
                Iterator4 iterator4 = ArrayHandler.iterator(reflectClass, object);
                while (iterator4.moveNext()) {
                    Object object2 = iterator4.current();
                    if (object2 == null) continue;
                    ClassMetadata classMetadata2 = this.classMetadataForObject(object2);
                    list4 = this.stillTo1(transaction, list4, object2, activationDepth.descend(classMetadata2), bl);
                }
            }
        } else if (object instanceof Entry) {
            list4 = this.stillTo1(transaction, list4, ((Entry)object).key, activationDepth, false);
            list4 = this.stillTo1(transaction, list4, ((Entry)object).value, activationDepth, false);
        } else if (bl && (classMetadata = this.classMetadataForObject(object)) != null) {
            classMetadata.deactivate(transaction, object, activationDepth);
        }
        return list4;
    }

    public final void stillToActivate(Transaction transaction, Object object, ActivationDepth activationDepth) {
        this._stillToActivate = this.stillTo1(transaction, this._stillToActivate, object, activationDepth, false);
    }

    public final void stillToDeactivate(Transaction transaction, Object object, ActivationDepth activationDepth, boolean bl) {
        this._stillToDeactivate = this.stillTo1(transaction, this._stillToDeactivate, object, activationDepth, bl);
    }

    void stillToSet(Transaction transaction, ObjectReference objectReference, int n) {
        if (this.stackIsSmall() && objectReference.continueSet(transaction, n)) {
            return;
        }
        this._stillToSet = new List4(this._stillToSet, new PendingSet(transaction, objectReference, n));
    }

    protected final void stopSession() {
        if (this.hasShutDownHook()) {
            Platform4.removeShutDownHook(this);
        }
        this._classCollection = null;
        if (this._references != null) {
            this._references.stopTimer();
        }
        this._systemTransaction = null;
        this._transaction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StoredClass storedClass(Transaction transaction, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            ReflectClass reflectClass = ReflectorUtils.reflectClassFor(this.reflector(), object);
            if (reflectClass == null) {
                return null;
            }
            ClassMetadata classMetadata = this.classMetadataForReflectClass(reflectClass);
            if (classMetadata == null) {
                return null;
            }
            return new StoredClassImpl(transaction, classMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(Transaction transaction) {
        Object object = this._lock;
        synchronized (object) {
            transaction = this.checkTransaction(transaction);
            StoredClass[] storedClassArray = this._classCollection.storedClasses();
            StoredClass[] storedClassArray2 = new StoredClass[storedClassArray.length];
            for (int i = 0; i < storedClassArray.length; ++i) {
                storedClassArray2[i] = new StoredClassImpl(transaction, (ClassMetadata)storedClassArray[i]);
            }
            return storedClassArray2;
        }
    }

    public LatinStringIO stringIO() {
        return this._handlers.stringIO();
    }

    public abstract SystemInfo systemInfo();

    private final void beginTopLevelCall() {
        if (DTrace.enabled) {
            DTrace.BEGIN_TOP_LEVEL_CALL.log();
        }
        this.generateCallIDOnTopLevel();
        if (this._stackDepth == 0) {
            this._topLevelCallCompleted = false;
        }
        ++this._stackDepth;
    }

    public final void beginTopLevelSet() {
        this.beginTopLevelCall();
    }

    private final void completeTopLevelCall() {
        if (this._stackDepth == 1) {
            this._topLevelCallCompleted = true;
        }
    }

    private void completeTopLevelCall(Db4oException db4oException) throws Db4oException {
        this.completeTopLevelCall();
        throw db4oException;
    }

    public final void completeTopLevelSet() {
        this.completeTopLevelCall();
    }

    public final void completeTopLevelSet(Db4oException db4oException) {
        this.completeTopLevelCall();
        throw db4oException;
    }

    private final void endTopLevelCall() {
        if (DTrace.enabled) {
            DTrace.END_TOP_LEVEL_CALL.log();
        }
        --this._stackDepth;
        this.generateCallIDOnTopLevel();
        if (this._stackDepth == 0 && !this._topLevelCallCompleted) {
            this.shutdownObjectContainer();
        }
    }

    public final void endTopLevelSet(Transaction transaction) {
        this.endTopLevelCall();
        if (this._stackDepth == 0 && this._topLevelCallCompleted) {
            transaction.processDeletes();
        }
    }

    private final void generateCallIDOnTopLevel() {
        if (this._stackDepth == 0) {
            this._topLevelCallId = this._topLevelCallIdGenerator.next();
        }
    }

    public int stackDepth() {
        return this._stackDepth;
    }

    public void stackDepth(int n) {
        this._stackDepth = n;
    }

    public int topLevelCallId() {
        return this._topLevelCallId;
    }

    public void topLevelCallId(int n) {
        this._topLevelCallId = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long version() {
        Object object = this._lock;
        synchronized (object) {
            return this.currentVersion();
        }
    }

    public abstract void shutdown();

    public abstract void writeDirty();

    public abstract void writeNew(Transaction var1, Pointer4 var2, ClassMetadata var3, BufferImpl var4);

    public abstract void writeTransactionPointer(int var1);

    public abstract void writeUpdate(Transaction var1, Pointer4 var2, ClassMetadata var3, BufferImpl var4);

    private static ExternalObjectContainer cast(PartialObjectContainer partialObjectContainer) {
        return (ExternalObjectContainer)partialObjectContainer;
    }

    public Callbacks callbacks() {
        return this._callbacks;
    }

    public void callbacks(Callbacks callbacks) {
        if (callbacks == null) {
            throw new IllegalArgumentException();
        }
        this._callbacks = callbacks;
    }

    public Config4Impl configImpl() {
        return this._config;
    }

    public UUIDFieldMetadata uUIDIndex() {
        return this._handlers.indexes()._uUID;
    }

    public VersionFieldMetadata versionIndex() {
        return this._handlers.indexes()._version;
    }

    public ClassMetadataRepository classCollection() {
        return this._classCollection;
    }

    public ClassInfoHelper getClassMetaHelper() {
        return this._classMetaHelper;
    }

    public abstract long[] getIDsForClass(Transaction var1, ClassMetadata var2);

    public abstract QueryResult classOnlyQuery(Transaction var1, ClassMetadata var2);

    public abstract QueryResult executeQuery(QQuery var1);

    public void replicationCallState(int n) {
        this._replicationCallState = n;
    }

    public abstract void onCommittedListener();

    public ReferenceSystemRegistry referenceSystemRegistry() {
        return this._referenceSystemRegistry;
    }

    public ObjectContainerBase container() {
        return this._this;
    }

    public void deleteByID(Transaction transaction, int n, int n2) {
        ObjectReference objectReference;
        if (n <= 0) {
            return;
        }
        if (n2 <= 0) {
            return;
        }
        Object object = this.getByID2(transaction, n);
        if (object == null) {
            return;
        }
        --n2;
        ReflectClass reflectClass = this.reflector().forObject(object);
        if (reflectClass.isCollection()) {
            n2 += this.reflector().collectionUpdateDepth(reflectClass) - 1;
        }
        if ((objectReference = transaction.referenceForId(n)) == null) {
            return;
        }
        this.delete2(transaction, objectReference, object, n2, false);
    }

    static class PendingSet {
        public final Transaction transaction;
        public final ObjectReference ref;
        public final int depth;

        public PendingSet(Transaction transaction, ObjectReference objectReference, int n) {
            this.transaction = transaction;
            this.ref = objectReference;
            this.depth = n;
        }
    }

    static final class PendingActivation {
        public final ObjectReference ref;
        public final ActivationDepth depth;

        public PendingActivation(ObjectReference objectReference, ActivationDepth activationDepth) {
            this.ref = objectReference;
            this.depth = activationDepth;
        }
    }
}

