/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.activation.Activator;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.DescendingActivationDepth;
import com.db4o.internal.activation.TransparentActivationDepthProvider;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.slots.Pointer4;

public class ObjectReference
extends PersistentBase
implements ObjectInfo,
Activator {
    private ClassMetadata _class;
    private Object _object;
    private VirtualAttributes _virtualAttributes;
    private ObjectReference _idPreceding;
    private ObjectReference _idSubsequent;
    private int _idSize;
    private ObjectReference _hcPreceding;
    private ObjectReference _hcSubsequent;
    private int _hcSize;
    private int _hcHashcode;
    private int _lastTopLevelCallId;

    public ObjectReference() {
    }

    public ObjectReference(int n) {
        this._id = n;
    }

    public ObjectReference(ClassMetadata classMetadata, int n) {
        this._class = classMetadata;
        this._id = n;
    }

    public void activate() {
        this.activateOn(this.container().transaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateOn(Transaction transaction) {
        ObjectContainerBase objectContainerBase = transaction.container();
        Object object = objectContainerBase.lock();
        synchronized (object) {
            if (this.isActive()) {
                return;
            }
            TransparentActivationDepthProvider transparentActivationDepthProvider = (TransparentActivationDepthProvider)objectContainerBase.activationDepthProvider();
            this.activate(transaction, this.getObject(), new DescendingActivationDepth(transparentActivationDepthProvider, ActivationMode.ACTIVATE));
        }
    }

    public void activate(Transaction transaction, Object object, ActivationDepth activationDepth) {
        this.activateInternal(transaction, object, activationDepth);
        transaction.container().activatePending(transaction);
    }

    void activateInternal(Transaction transaction, Object object, ActivationDepth activationDepth) {
        if (!activationDepth.requiresActivation()) {
            return;
        }
        ObjectContainerBase objectContainerBase = transaction.container();
        if (activationDepth.mode().isRefresh()) {
            this.logActivation(objectContainerBase, "refresh");
        } else {
            if (this.isActive() && object != null) {
                this._class.activateFields(transaction, object, activationDepth);
                return;
            }
            this.logActivation(objectContainerBase, "activate");
        }
        this.readForActivation(transaction, object, activationDepth);
    }

    private void readForActivation(Transaction transaction, Object object, ActivationDepth activationDepth) {
        this.read(transaction, null, object, activationDepth, 0, false);
    }

    private void logActivation(ObjectContainerBase objectContainerBase, String string) {
        this.logEvent(objectContainerBase, string, 2);
    }

    private void logEvent(ObjectContainerBase objectContainerBase, String string, int n) {
        if (objectContainerBase.configImpl().messageLevel() > n) {
            objectContainerBase.message("" + this.getID() + " " + string + " " + this._class.getName());
        }
    }

    public final void addExistingReferenceToIdTree(Transaction transaction) {
        if (!(this._class instanceof PrimitiveFieldHandler)) {
            transaction.referenceSystem().addExistingReferenceToIdTree(this);
        }
    }

    boolean continueSet(Transaction transaction, int n) {
        if (!this.bitIsTrue(4)) {
            return true;
        }
        if (!this._class.stateOKAndAncestors()) {
            return false;
        }
        if (DTrace.enabled) {
            DTrace.CONTINUESET.log(this.getID());
        }
        this.bitFalse(4);
        MarshallingContext marshallingContext = new MarshallingContext(transaction, this, n, true);
        MarshallerFamily.current()._object.marshall(this.getObject(), marshallingContext);
        Pointer4 pointer4 = marshallingContext.allocateSlot();
        BufferImpl bufferImpl = marshallingContext.ToWriteBuffer(pointer4);
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.writeNew(transaction, pointer4, this._class, bufferImpl);
        Object object = this._object;
        this.objectOnNew(transaction, object);
        if (!this._class.isPrimitive()) {
            this._object = objectContainerBase._references.createYapRef(this, object);
        }
        this.setStateClean();
        this.endProcessing();
        return true;
    }

    private void objectOnNew(Transaction transaction, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.callbacks().objectOnNew(transaction, object);
        this._class.dispatchEvent(objectContainerBase, object, 4);
    }

    public void deactivate(Transaction transaction, ActivationDepth activationDepth) {
        if (!activationDepth.requiresActivation()) {
            return;
        }
        Object object = this.getObject();
        if (object == null) {
            return;
        }
        if (object instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)object).preDeactivate();
        }
        ObjectContainerBase objectContainerBase = transaction.container();
        this.logActivation(objectContainerBase, "deactivate");
        this.setStateDeactivated();
        this._class.deactivate(transaction, object, activationDepth);
    }

    public byte getIdentifier() {
        return 79;
    }

    public long getInternalID() {
        return this.getID();
    }

    public Object getObject() {
        if (Platform4.hasWeakReferences()) {
            return Platform4.getYapRefObject(this._object);
        }
        return this._object;
    }

    public Object getObjectReference() {
        return this._object;
    }

    public ObjectContainerBase container() {
        if (this._class == null) {
            throw new IllegalStateException();
        }
        return this._class.container();
    }

    public Transaction transaction() {
        return this.container().transaction();
    }

    public Db4oUUID getUUID() {
        VirtualAttributes virtualAttributes = this.virtualAttributes(this.transaction());
        if (virtualAttributes != null && virtualAttributes.i_database != null) {
            return new Db4oUUID(virtualAttributes.i_uuid, virtualAttributes.i_database.i_signature);
        }
        return null;
    }

    public long getVersion() {
        VirtualAttributes virtualAttributes = this.virtualAttributes(this.transaction());
        if (virtualAttributes == null) {
            return 0L;
        }
        return virtualAttributes.i_version;
    }

    public final ClassMetadata classMetadata() {
        return this._class;
    }

    public void classMetadata(ClassMetadata classMetadata) {
        this._class = classMetadata;
    }

    public int ownLength() {
        throw Exceptions4.shouldNeverBeCalled();
    }

    public VirtualAttributes produceVirtualAttributes() {
        if (this._virtualAttributes == null) {
            this._virtualAttributes = new VirtualAttributes();
        }
        return this._virtualAttributes;
    }

    final Object peekPersisted(Transaction transaction, ActivationDepth activationDepth) {
        return this.read(transaction, activationDepth, -1, false);
    }

    final Object read(Transaction transaction, ActivationDepth activationDepth, int n, boolean bl) {
        return this.read(transaction, null, null, activationDepth, n, bl);
    }

    public final Object read(Transaction transaction, StatefulBuffer statefulBuffer, Object object, ActivationDepth activationDepth, int n, boolean bl) {
        UnmarshallingContext unmarshallingContext = new UnmarshallingContext(transaction, statefulBuffer, this, n, bl);
        unmarshallingContext.persistentObject(object);
        unmarshallingContext.activationDepth(activationDepth);
        return unmarshallingContext.read();
    }

    public final Object readPrefetch(Transaction transaction, StatefulBuffer statefulBuffer) {
        return new UnmarshallingContext(transaction, statefulBuffer, this, 1, false).readPrefetch();
    }

    public final void readThis(Transaction transaction, BufferImpl bufferImpl) {
    }

    public void setObjectWeak(ObjectContainerBase objectContainerBase, Object object) {
        if (objectContainerBase._references._weak) {
            if (this._object != null) {
                Platform4.killYapRef(this._object);
            }
            this._object = Platform4.createActiveObjectReference(objectContainerBase._references._queue, this, object);
        } else {
            this._object = object;
        }
    }

    public void setObject(Object object) {
        this._object = object;
    }

    final void store(Transaction transaction, ClassMetadata classMetadata, Object object) {
        this._object = object;
        this._class = classMetadata;
        this.writeObjectBegin();
        int n = transaction.container().newUserObject();
        transaction.slotFreePointerOnRollback(n);
        this.setID(n);
        this.beginProcessing();
        this.bitTrue(4);
    }

    public void flagForDelete(int n) {
        this._lastTopLevelCallId = -n;
    }

    public boolean isFlaggedForDelete() {
        return this._lastTopLevelCallId < 0;
    }

    public void flagAsHandled(int n) {
        this._lastTopLevelCallId = n;
    }

    public final boolean isFlaggedAsHandled(int n) {
        return this._lastTopLevelCallId == n;
    }

    public final boolean isValid() {
        return ObjectReference.isValidId(this.getID()) && this.getObject() != null;
    }

    public static final boolean isValidId(int n) {
        return n > 0;
    }

    public VirtualAttributes virtualAttributes() {
        return this._virtualAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualAttributes virtualAttributes(Transaction transaction) {
        if (transaction == null) {
            return this._virtualAttributes;
        }
        Object object = transaction.container().lock();
        synchronized (object) {
            if (this._virtualAttributes == null) {
                if (this._class.hasVirtualAttributes()) {
                    this._virtualAttributes = new VirtualAttributes();
                    this._class.readVirtualAttributes(transaction, this);
                }
            } else if (!this._virtualAttributes.suppliesUUID() && this._class.hasVirtualAttributes()) {
                this._class.readVirtualAttributes(transaction, this);
            }
            return this._virtualAttributes;
        }
    }

    public void setVirtualAttributes(VirtualAttributes virtualAttributes) {
        this._virtualAttributes = virtualAttributes;
    }

    public void writeThis(Transaction transaction, BufferImpl bufferImpl) {
    }

    public void writeUpdate(Transaction transaction, int n) {
        this.continueSet(transaction, n);
        if (!this.beginProcessing()) {
            return;
        }
        Object object = this.getObject();
        if (!this.objectCanUpdate(transaction, object) || !this.isActive() || object == null) {
            this.endProcessing();
            return;
        }
        ObjectContainerBase objectContainerBase = transaction.container();
        this.logEvent(objectContainerBase, "update", 1);
        this.setStateClean();
        transaction.writeUpdateDeleteMembers(this.getID(), this._class, objectContainerBase._handlers.arrayType(object), 0);
        MarshallingContext marshallingContext = new MarshallingContext(transaction, this, n, false);
        MarshallerFamily.current()._object.marshall(object, marshallingContext);
        Pointer4 pointer4 = marshallingContext.allocateSlot();
        BufferImpl bufferImpl = marshallingContext.ToWriteBuffer(pointer4);
        objectContainerBase.writeUpdate(transaction, pointer4, this.classMetadata(), bufferImpl);
        if (this.isActive()) {
            this.setStateClean();
        }
        this.endProcessing();
        objectContainerBase.callbacks().objectOnUpdate(transaction, object);
        this.classMetadata().dispatchEvent(objectContainerBase, object, 5);
    }

    private boolean objectCanUpdate(Transaction transaction, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        return objectContainerBase.callbacks().objectCanUpdate(transaction, object) && this._class.dispatchEvent(objectContainerBase, object, 9);
    }

    public ObjectReference hc_add(ObjectReference objectReference) {
        if (objectReference.getObject() == null) {
            return this;
        }
        objectReference.hc_init();
        return this.hc_add1(objectReference);
    }

    public void hc_init() {
        this._hcPreceding = null;
        this._hcSubsequent = null;
        this._hcSize = 1;
        this._hcHashcode = this.hc_getCode(this.getObject());
    }

    /*
     * Enabled aggressive block sorting
     */
    private ObjectReference hc_add1(ObjectReference objectReference) {
        int n = this.hc_compare(objectReference);
        if (n < 0) {
            if (this._hcPreceding == null) {
                this._hcPreceding = objectReference;
                ++this._hcSize;
                return this;
            }
            this._hcPreceding = this._hcPreceding.hc_add1(objectReference);
            if (this._hcSubsequent != null) return this.hc_balance();
            return this.hc_rotateRight();
        }
        if (this._hcSubsequent == null) {
            this._hcSubsequent = objectReference;
            ++this._hcSize;
            return this;
        }
        this._hcSubsequent = this._hcSubsequent.hc_add1(objectReference);
        if (this._hcPreceding != null) return this.hc_balance();
        return this.hc_rotateLeft();
    }

    private ObjectReference hc_balance() {
        int n = this._hcSubsequent._hcSize - this._hcPreceding._hcSize;
        if (n < -2) {
            return this.hc_rotateRight();
        }
        if (n > 2) {
            return this.hc_rotateLeft();
        }
        this._hcSize = this._hcPreceding._hcSize + this._hcSubsequent._hcSize + 1;
        return this;
    }

    private void hc_calculateSize() {
        this._hcSize = this._hcPreceding == null ? (this._hcSubsequent == null ? 1 : this._hcSubsequent._hcSize + 1) : (this._hcSubsequent == null ? this._hcPreceding._hcSize + 1 : this._hcPreceding._hcSize + this._hcSubsequent._hcSize + 1);
    }

    private int hc_compare(ObjectReference objectReference) {
        int n = objectReference._hcHashcode - this._hcHashcode;
        if (n == 0) {
            n = objectReference._id - this._id;
        }
        return n;
    }

    public ObjectReference hc_find(Object object) {
        return this.hc_find(this.hc_getCode(object), object);
    }

    private ObjectReference hc_find(int n, Object object) {
        int n2 = n - this._hcHashcode;
        if (n2 < 0) {
            if (this._hcPreceding != null) {
                return this._hcPreceding.hc_find(n, object);
            }
        } else if (n2 > 0) {
            if (this._hcSubsequent != null) {
                return this._hcSubsequent.hc_find(n, object);
            }
        } else {
            ObjectReference objectReference;
            if (object == this.getObject()) {
                return this;
            }
            if (this._hcPreceding != null && (objectReference = this._hcPreceding.hc_find(n, object)) != null) {
                return objectReference;
            }
            if (this._hcSubsequent != null) {
                return this._hcSubsequent.hc_find(n, object);
            }
        }
        return null;
    }

    private int hc_getCode(Object object) {
        int n = System.identityHashCode(object);
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    private ObjectReference hc_rotateLeft() {
        ObjectReference objectReference = this._hcSubsequent;
        this._hcSubsequent = objectReference._hcPreceding;
        this.hc_calculateSize();
        objectReference._hcPreceding = this;
        objectReference._hcSize = objectReference._hcSubsequent == null ? 1 + this._hcSize : 1 + this._hcSize + objectReference._hcSubsequent._hcSize;
        return objectReference;
    }

    private ObjectReference hc_rotateRight() {
        ObjectReference objectReference = this._hcPreceding;
        this._hcPreceding = objectReference._hcSubsequent;
        this.hc_calculateSize();
        objectReference._hcSubsequent = this;
        objectReference._hcSize = objectReference._hcPreceding == null ? 1 + this._hcSize : 1 + this._hcSize + objectReference._hcPreceding._hcSize;
        return objectReference;
    }

    private ObjectReference hc_rotateSmallestUp() {
        if (this._hcPreceding != null) {
            this._hcPreceding = this._hcPreceding.hc_rotateSmallestUp();
            return this.hc_rotateRight();
        }
        return this;
    }

    ObjectReference hc_remove(ObjectReference objectReference) {
        if (this == objectReference) {
            return this.hc_remove();
        }
        int n = this.hc_compare(objectReference);
        if (n <= 0 && this._hcPreceding != null) {
            this._hcPreceding = this._hcPreceding.hc_remove(objectReference);
        }
        if (n >= 0 && this._hcSubsequent != null) {
            this._hcSubsequent = this._hcSubsequent.hc_remove(objectReference);
        }
        this.hc_calculateSize();
        return this;
    }

    public void hc_traverse(Visitor4 visitor4) {
        if (this._hcPreceding != null) {
            this._hcPreceding.hc_traverse(visitor4);
        }
        if (this._hcSubsequent != null) {
            this._hcSubsequent.hc_traverse(visitor4);
        }
        visitor4.visit(this);
    }

    private ObjectReference hc_remove() {
        if (this._hcSubsequent != null && this._hcPreceding != null) {
            this._hcSubsequent = this._hcSubsequent.hc_rotateSmallestUp();
            this._hcSubsequent._hcPreceding = this._hcPreceding;
            this._hcSubsequent.hc_calculateSize();
            return this._hcSubsequent;
        }
        if (this._hcSubsequent != null) {
            return this._hcSubsequent;
        }
        return this._hcPreceding;
    }

    ObjectReference id_add(ObjectReference objectReference) {
        objectReference._idPreceding = null;
        objectReference._idSubsequent = null;
        objectReference._idSize = 1;
        return this.id_add1(objectReference);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ObjectReference id_add1(ObjectReference objectReference) {
        int n = objectReference._id - this._id;
        if (n < 0) {
            if (this._idPreceding == null) {
                this._idPreceding = objectReference;
                ++this._idSize;
                return this;
            }
            this._idPreceding = this._idPreceding.id_add1(objectReference);
            if (this._idSubsequent != null) return this.id_balance();
            return this.id_rotateRight();
        }
        if (n <= 0) return this;
        if (this._idSubsequent == null) {
            this._idSubsequent = objectReference;
            ++this._idSize;
            return this;
        }
        this._idSubsequent = this._idSubsequent.id_add1(objectReference);
        if (this._idPreceding != null) return this.id_balance();
        return this.id_rotateLeft();
    }

    private ObjectReference id_balance() {
        int n = this._idSubsequent._idSize - this._idPreceding._idSize;
        if (n < -2) {
            return this.id_rotateRight();
        }
        if (n > 2) {
            return this.id_rotateLeft();
        }
        this._idSize = this._idPreceding._idSize + this._idSubsequent._idSize + 1;
        return this;
    }

    private void id_calculateSize() {
        this._idSize = this._idPreceding == null ? (this._idSubsequent == null ? 1 : this._idSubsequent._idSize + 1) : (this._idSubsequent == null ? this._idPreceding._idSize + 1 : this._idPreceding._idSize + this._idSubsequent._idSize + 1);
    }

    ObjectReference id_find(int n) {
        int n2 = n - this._id;
        if (n2 > 0) {
            if (this._idSubsequent != null) {
                return this._idSubsequent.id_find(n);
            }
        } else if (n2 < 0) {
            if (this._idPreceding != null) {
                return this._idPreceding.id_find(n);
            }
        } else {
            return this;
        }
        return null;
    }

    private ObjectReference id_rotateLeft() {
        ObjectReference objectReference = this._idSubsequent;
        this._idSubsequent = objectReference._idPreceding;
        this.id_calculateSize();
        objectReference._idPreceding = this;
        objectReference._idSize = objectReference._idSubsequent == null ? this._idSize + 1 : this._idSize + 1 + objectReference._idSubsequent._idSize;
        return objectReference;
    }

    private ObjectReference id_rotateRight() {
        ObjectReference objectReference = this._idPreceding;
        this._idPreceding = objectReference._idSubsequent;
        this.id_calculateSize();
        objectReference._idSubsequent = this;
        objectReference._idSize = objectReference._idPreceding == null ? this._idSize + 1 : this._idSize + 1 + objectReference._idPreceding._idSize;
        return objectReference;
    }

    private ObjectReference id_rotateSmallestUp() {
        if (this._idPreceding != null) {
            this._idPreceding = this._idPreceding.id_rotateSmallestUp();
            return this.id_rotateRight();
        }
        return this;
    }

    ObjectReference id_remove(int n) {
        int n2 = n - this._id;
        if (n2 < 0) {
            if (this._idPreceding != null) {
                this._idPreceding = this._idPreceding.id_remove(n);
            }
        } else if (n2 > 0) {
            if (this._idSubsequent != null) {
                this._idSubsequent = this._idSubsequent.id_remove(n);
            }
        } else {
            return this.id_remove();
        }
        this.id_calculateSize();
        return this;
    }

    private ObjectReference id_remove() {
        if (this._idSubsequent != null && this._idPreceding != null) {
            this._idSubsequent = this._idSubsequent.id_rotateSmallestUp();
            this._idSubsequent._idPreceding = this._idPreceding;
            this._idSubsequent.id_calculateSize();
            return this._idSubsequent;
        }
        if (this._idSubsequent != null) {
            return this._idSubsequent;
        }
        return this._idPreceding;
    }

    public String toString() {
        return super.toString();
    }
}

