/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.Readable;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeReader;

public class LockedTree {
    private Tree _tree;
    private int _version;

    public void add(Tree tree) {
        this.changed();
        this._tree = this._tree == null ? tree : this._tree.add(tree);
    }

    private void changed() {
        ++this._version;
    }

    public void clear() {
        this.changed();
        this._tree = null;
    }

    public Tree find(int n) {
        return TreeInt.find(this._tree, n);
    }

    public void read(BufferImpl bufferImpl, Readable readable) {
        this.clear();
        this._tree = new TreeReader(bufferImpl, readable).read();
        this.changed();
    }

    public void traverseLocked(Visitor4 visitor4) {
        int n = this._version;
        Tree.traverse(this._tree, visitor4);
        if (this._version != n) {
            throw new IllegalStateException();
        }
    }

    public void traverseMutable(Visitor4 visitor4) {
        final Collection4 collection4 = new Collection4();
        this.traverseLocked(new Visitor4(){

            public void visit(Object object) {
                collection4.add(object);
            }
        });
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.moveNext()) {
            visitor4.visit(iterator4.current());
        }
    }
}

