/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.config.Configuration;
import com.db4o.config.FreespaceFiller;
import com.db4o.ext.BackupInProgressException;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.Cool;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Slot;
import com.db4o.io.IoAdapter;
import com.db4o.io.IoAdapterWindow;
import java.io.IOException;

public class IoAdaptedObjectContainer
extends LocalObjectContainer {
    private final String _fileName;
    private IoAdapter _file;
    private IoAdapter _timerFile;
    private volatile IoAdapter _backupFile;
    private Object _fileLock = new Object();
    private final FreespaceFiller _freespaceFiller;

    IoAdaptedObjectContainer(Configuration configuration, String string) throws OldFormatException {
        super(configuration, null);
        this._fileName = string;
        this._freespaceFiller = this.createFreespaceFiller();
        this.open();
    }

    protected final void openImpl() throws OldFormatException, DatabaseReadOnlyException {
        boolean bl;
        IoAdapter ioAdapter = this.configImpl().ioAdapter();
        boolean bl2 = bl = !ioAdapter.exists(this.fileName());
        if (bl) {
            this.logMsg(14, this.fileName());
            this.checkReadOnly();
            this._handlers.oldEncryptionOff();
        }
        boolean bl3 = this.configImpl().isReadOnly();
        boolean bl4 = this.configImpl().lockFile() && !bl3;
        this._file = ioAdapter.open(this.fileName(), bl4, 0L, bl3);
        if (this.needsLockFileThread()) {
            this._timerFile = ioAdapter.delegatedIoAdapter().open(this.fileName(), false, 0L, false);
        }
        if (bl) {
            this.configureNewFile();
            if (this.configImpl().reservedStorageSpace() > 0) {
                this.reserve(this.configImpl().reservedStorageSpace());
            }
            this.commitTransaction();
            this.writeHeader(true, false);
        } else {
            this.readThis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String string) throws DatabaseClosedException, Db4oIOException {
        Object object;
        Object object2 = this._lock;
        synchronized (object2) {
            this.checkClosed();
            if (this._backupFile != null) {
                throw new BackupInProgressException();
            }
            this._backupFile = this.configImpl().ioAdapter().open(string, true, this._file.getLength(), false);
            this._backupFile.blockSize(this.blockSize());
        }
        long l = 0L;
        byte[] byArray = new byte[8192];
        while (true) {
            object = this._lock;
            synchronized (object) {
                this._file.seek(l);
                int n = this._file.read(byArray);
                if (n <= 0) {
                    break;
                }
                this._backupFile.seek(l);
                this._backupFile.write(byArray, n);
                l += (long)n;
            }
        }
        Cool.sleepIgnoringInterruption(1L);
        object = this._lock;
        synchronized (object) {
            this._backupFile.close();
            this._backupFile = null;
        }
    }

    public void blockSize(int n) {
        this._file.blockSize(n);
        if (this._timerFile != null) {
            this._timerFile.blockSize(n);
        }
    }

    public byte blockSize() {
        return (byte)this._file.blockSize();
    }

    protected void freeInternalResources() {
        this.freePrefetchedPointers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownDataStorage() {
        Object object = this._fileLock;
        synchronized (object) {
            this.closeDatabaseFile();
            this.closeFileHeader();
            this.closeTimerFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatabaseFile() {
        try {
            if (this._file != null) {
                this._file.close();
            }
        }
        finally {
            this._file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileHeader() {
        try {
            if (this._fileHeader != null) {
                this._fileHeader.close();
            }
        }
        finally {
            this._fileHeader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTimerFile() {
        try {
            if (this._timerFile != null) {
                this._timerFile.close();
            }
        }
        finally {
            this._timerFile = null;
        }
    }

    public void commit1(Transaction transaction) {
        this.ensureLastSlotWritten();
        super.commit1(transaction);
    }

    public void copy(int n, int n2, int n3, int n4, int n5) {
        try {
            if (this._backupFile == null) {
                this._file.blockCopy(n, n2, n3, n4, n5);
                return;
            }
            byte[] byArray = new byte[n5];
            this._file.blockSeek(n, n2);
            this._file.read(byArray);
            this._file.blockSeek(n3, n4);
            this._file.write(byArray);
            if (this._backupFile != null) {
                this._backupFile.blockSeek(n3, n4);
                this._backupFile.write(byArray);
            }
        }
        catch (Exception exception) {
            Exceptions4.throwRuntimeException(16, exception);
        }
    }

    private void checkXBytes(int n, int n2, int n3) {
    }

    public long fileLength() {
        try {
            return this._file.getLength();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public String fileName() {
        return this._fileName;
    }

    public void readBytes(byte[] byArray, int n, int n2) throws Db4oIOException {
        this.readBytes(byArray, n, 0, n2);
    }

    public void readBytes(byte[] byArray, int n, int n2, int n3) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.READ_BYTES.logLength(n + n2, n3);
        }
        this._file.blockSeek(n, n2);
        int n4 = this._file.read(byArray, n3);
        this.checkReadCount(n4, n3);
    }

    private void checkReadCount(int n, int n2) {
        if (n != n2) {
            throw new IncompatibleFileFormatException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(int n) throws DatabaseReadOnlyException {
        this.checkReadOnly();
        Object object = this._lock;
        synchronized (object) {
            Slot slot = this.getSlot(n);
            this.zeroReservedSlot(slot);
            this.free(slot);
        }
    }

    private void zeroReservedSlot(Slot slot) {
        this.zeroFile(this._file, slot);
        this.zeroFile(this._backupFile, slot);
    }

    private void zeroFile(IoAdapter ioAdapter, Slot slot) {
        int n;
        if (ioAdapter == null) {
            return;
        }
        byte[] byArray = new byte[1024];
        ioAdapter.blockSeek(slot.address(), 0);
        for (n = slot.length(); n > byArray.length; n -= byArray.length) {
            ioAdapter.write(byArray, byArray.length);
        }
        if (n > 0) {
            ioAdapter.write(byArray, n);
        }
    }

    public void syncFiles() {
        try {
            this._file.sync();
            if (this._timerFile != null) {
                this._timerFile.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBytes(BufferImpl bufferImpl, int n, int n2) {
        if (DTrace.enabled) {
            DTrace.WRITE_BYTES.logLength(n + n2, bufferImpl.length());
        }
        this._file.blockSeek(n, n2);
        this._file.write(bufferImpl._buffer, bufferImpl.length());
        if (this._backupFile != null) {
            this._backupFile.blockSeek(n, n2);
            this._backupFile.write(bufferImpl._buffer, bufferImpl.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteDeletedBytes(int n, int n2) {
        if (this._freespaceFiller == null) {
            return;
        }
        if (n > 0 && n2 > 0) {
            if (DTrace.enabled) {
                DTrace.WRITE_XBYTES.logLength(n, n2);
            }
            IoAdapterWindow ioAdapterWindow = new IoAdapterWindow(this._file, n, n2);
            try {
                this.createFreespaceFiller().fill(ioAdapterWindow);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                ioAdapterWindow.disable();
            }
        }
    }

    public IoAdapter timerFile() {
        return this._timerFile;
    }

    private FreespaceFiller createFreespaceFiller() {
        FreespaceFiller freespaceFiller = this.config().freespaceFiller();
        return freespaceFiller;
    }

    private static class XByteFreespaceFiller
    implements FreespaceFiller {
        private XByteFreespaceFiller() {
        }

        public void fill(IoAdapterWindow ioAdapterWindow) throws IOException {
            ioAdapterWindow.write(0, this.xBytes(ioAdapterWindow.length()));
        }

        private byte[] xBytes(int n) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = 88;
            }
            return byArray;
        }
    }
}

