/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.ObjectContainer;
import com.db4o.foundation.BitMap4;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.mapping.DefragmentServices;
import com.db4o.internal.mapping.IDMapping;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.slots.Slot;
import java.io.IOException;

public final class DefragmentContextImpl
implements Buffer,
DefragmentContext {
    private BufferImpl _source;
    private BufferImpl _target;
    private DefragmentServices _services;
    private int _handlerVersion;

    public DefragmentContextImpl(BufferImpl bufferImpl, DefragmentServices defragmentServices) {
        this._source = bufferImpl;
        this._services = defragmentServices;
        this._target = new BufferImpl(this.length());
        this._source.copyTo(this._target, 0, 0, this.length());
    }

    public int offset() {
        return this._source.offset();
    }

    public void seek(int n) {
        this._source.seek(n);
        this._target.seek(n);
    }

    public void incrementOffset(int n) {
        this._source.incrementOffset(n);
        this._target.incrementOffset(n);
    }

    public void incrementIntSize() {
        this.incrementOffset(4);
    }

    public int copyUnindexedID() {
        int n = this._source.readInt();
        int n2 = -1;
        try {
            n2 = this._services.mappedID(n);
        }
        catch (MappingNotFoundException mappingNotFoundException) {
            n2 = this._services.allocateTargetSlot(8).address();
            this._services.mapIDs(n, n2, false);
            this._services.registerUnindexed(n);
        }
        this._target.writeInt(n2);
        return n2;
    }

    public int copyID() {
        int n = this._source.readInt();
        return this.writeMappedID(n);
    }

    public int copyID(boolean bl, boolean bl2) {
        int n = this._source.readInt();
        return this.internalCopyID(bl, bl2, n);
    }

    public int copyIDReturnOriginalID() {
        int n = this._source.readInt();
        this.internalCopyID(false, false, n);
        return n;
    }

    private int internalCopyID(boolean bl, boolean bl2, int n) {
        if (bl && n < 0) {
            n = -n;
        }
        int n2 = this._services.mappedID(n, bl2);
        if (bl && n < 0) {
            n2 = -n2;
        }
        this._target.writeInt(n2);
        return n2;
    }

    public void readBegin(byte by) {
        this._source.readBegin(by);
        this._target.readBegin(by);
    }

    public byte readByte() {
        byte by = this._source.readByte();
        this._target.incrementOffset(1);
        return by;
    }

    public void readBytes(byte[] byArray) {
        this._source.readBytes(byArray);
        this._target.incrementOffset(byArray.length);
    }

    public int readInt() {
        int n = this._source.readInt();
        this._target.incrementOffset(4);
        return n;
    }

    public void writeInt(int n) {
        this._source.incrementOffset(4);
        this._target.writeInt(n);
    }

    public void write(LocalObjectContainer localObjectContainer, int n) {
        localObjectContainer.writeBytes(this._target, n, 0);
    }

    public void incrementStringOffset(LatinStringIO latinStringIO) {
        this.incrementStringOffset(latinStringIO, this._source);
        this.incrementStringOffset(latinStringIO, this._target);
    }

    private void incrementStringOffset(LatinStringIO latinStringIO, BufferImpl bufferImpl) {
        int n = bufferImpl.readInt();
        if (n > 0) {
            latinStringIO.read(bufferImpl, n);
        }
    }

    public BufferImpl source() {
        return this._source;
    }

    public BufferImpl target() {
        return this._target;
    }

    public IDMapping mapping() {
        return this._services;
    }

    public Transaction systemTrans() {
        return this.transaction();
    }

    public DefragmentServices services() {
        return this._services;
    }

    public static void processCopy(DefragmentServices defragmentServices, int n, SlotCopyHandler slotCopyHandler) throws CorruptionException, IOException {
        DefragmentContextImpl.processCopy(defragmentServices, n, slotCopyHandler, false);
    }

    public static void processCopy(DefragmentServices defragmentServices, int n, SlotCopyHandler slotCopyHandler, boolean bl) throws CorruptionException, IOException {
        BufferImpl bufferImpl = defragmentServices.sourceBufferByID(n);
        DefragmentContextImpl.processCopy(defragmentServices, n, slotCopyHandler, bl, bufferImpl);
    }

    public static void processCopy(DefragmentServices defragmentServices, int n, SlotCopyHandler slotCopyHandler, boolean bl, BufferImpl bufferImpl) throws CorruptionException, IOException {
        int n2 = defragmentServices.mappedID(n);
        Slot slot = defragmentServices.allocateTargetSlot(bufferImpl.length());
        if (bl) {
            int n3 = defragmentServices.sourceAddressByID(n);
            defragmentServices.mapIDs(n3, slot.address(), false);
        }
        BufferImpl bufferImpl2 = new BufferImpl(8);
        bufferImpl2.writeInt(slot.address());
        bufferImpl2.writeInt(slot.length());
        defragmentServices.targetWriteBytes(bufferImpl2, n2);
        DefragmentContextImpl defragmentContextImpl = new DefragmentContextImpl(bufferImpl, defragmentServices);
        slotCopyHandler.processCopy(defragmentContextImpl);
        defragmentServices.targetWriteBytes(defragmentContextImpl, slot.address());
    }

    public void writeByte(byte by) {
        this._source.incrementOffset(1);
        this._target.writeByte(by);
    }

    public long readLong() {
        long l = this._source.readLong();
        this._target.incrementOffset(8);
        return l;
    }

    public void writeLong(long l) {
        this._source.incrementOffset(8);
        this._target.writeLong(l);
    }

    public BitMap4 readBitMap(int n) {
        BitMap4 bitMap4 = this._source.readBitMap(n);
        this._target.incrementOffset(bitMap4.marshalledLength());
        return bitMap4;
    }

    public void readEnd() {
        this._source.readEnd();
        this._target.readEnd();
    }

    public int writeMappedID(int n) {
        int n2 = this._services.mappedID(n, false);
        this._target.writeInt(n2);
        return n2;
    }

    public int length() {
        return this._source.length();
    }

    public Transaction transaction() {
        return this.services().systemTrans();
    }

    private ObjectContainerBase container() {
        return this.transaction().container();
    }

    public ClassMetadata classMetadataForId(int n) {
        return this.container().classMetadataForId(n);
    }

    private int handlerVersion() {
        return this._handlerVersion;
    }

    public boolean isLegacyHandlerVersion() {
        return this.handlerVersion() == 0;
    }

    public int mappedID(int n) {
        return this.mapping().mappedID(n);
    }

    public Buffer sourceBuffer() {
        return this.source();
    }

    public Buffer targetBuffer() {
        return this.target();
    }

    public ObjectContainer objectContainer() {
        return (ObjectContainer)((Object)this.container());
    }

    public void handlerVersion(int n) {
        this._handlerVersion = n;
    }

    public TypeHandler4 correctHandlerVersion(TypeHandler4 typeHandler4) {
        return this.container().handlers().correctHandlerVersion(typeHandler4, this.handlerVersion());
    }
}

