/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.StoredClass;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Config4Class;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PendingClassInits;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;

public final class ClassMetadataRepository
extends PersistentBase {
    private Collection4 _classes;
    private Hashtable4 _creating;
    private final Transaction _systemTransaction;
    private Hashtable4 _classMetadataByBytes;
    private Hashtable4 _classMetadataByClass;
    private Hashtable4 _classMetadataByID;
    private int _classMetadataCreationDepth;
    private Queue4 _initClassMetadataOnUp;
    private final PendingClassInits _classInits;

    ClassMetadataRepository(Transaction transaction) {
        this._systemTransaction = transaction;
        this._initClassMetadataOnUp = new NonblockingQueue();
        this._classInits = new PendingClassInits(this._systemTransaction);
    }

    public void addClassMetadata(ClassMetadata classMetadata) {
        this.container().setDirtyInSystemTransaction(this);
        this._classes.add(classMetadata);
        if (classMetadata.stateUnread()) {
            this._classMetadataByBytes.put(classMetadata.i_nameBytes, (Object)classMetadata);
        } else {
            this._classMetadataByClass.put(classMetadata.classReflector(), (Object)classMetadata);
        }
        if (classMetadata.getID() == 0) {
            classMetadata.write(this._systemTransaction);
        }
        this._classMetadataByID.put(classMetadata.getID(), (Object)classMetadata);
    }

    private byte[] asBytes(String string) {
        return this.container().stringIO().write(string);
    }

    public void attachQueryNode(final String string, final Visitor4 visitor4) {
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            final ClassMetadata classMetadata = classMetadataIterator.currentClass();
            if (classMetadata.isInternal()) continue;
            classMetadata.forEachFieldMetadata(new Visitor4(){

                public void visit(Object object) {
                    FieldMetadata fieldMetadata = (FieldMetadata)object;
                    if (fieldMetadata.canAddToQuery(string)) {
                        visitor4.visit(new Object[]{classMetadata, fieldMetadata});
                    }
                }
            });
        }
    }

    public void iterateTopLevelClasses(Visitor4 visitor4) {
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            ClassMetadata classMetadata = classMetadataIterator.currentClass();
            if (classMetadata.isInternal() || classMetadata.getAncestor() != null) continue;
            visitor4.visit(classMetadata);
        }
    }

    void checkChanges() {
        Iterator4 iterator4 = this._classes.iterator();
        while (iterator4.moveNext()) {
            ((ClassMetadata)iterator4.current()).checkChanges();
        }
    }

    final boolean createClassMetadata(ClassMetadata classMetadata, ReflectClass reflectClass) {
        ++this._classMetadataCreationDepth;
        ReflectClass reflectClass2 = reflectClass.getSuperclass();
        ClassMetadata classMetadata2 = null;
        if (reflectClass2 != null && !reflectClass2.equals(this.container()._handlers.ICLASS_OBJECT)) {
            classMetadata2 = this.produceClassMetadata(reflectClass2);
        }
        boolean bl = this.container().createClassMetadata(classMetadata, reflectClass, classMetadata2);
        --this._classMetadataCreationDepth;
        this.initClassMetadataOnUp();
        return bl;
    }

    private void ensureAllClassesRead() {
        boolean bl = false;
        while (!bl) {
            Object object;
            Collection4 collection4 = new Collection4();
            int n = this._classes.size();
            Iterator4 iterator4 = this._classes.iterator();
            while (iterator4.moveNext()) {
                object = (ClassMetadata)iterator4.current();
                if (!((ClassMetadata)object).stateUnread()) continue;
                collection4.add(object);
            }
            object = collection4.iterator();
            while (object.moveNext()) {
                ClassMetadata classMetadata = (ClassMetadata)object.current();
                if ((classMetadata = this.readClassMetadata(classMetadata, null)).classReflector() != null) continue;
                classMetadata.forceRead();
            }
            bl = this._classes.size() == n;
        }
        this.applyReadAs();
    }

    boolean fieldExists(String string) {
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            if (classMetadataIterator.currentClass().fieldMetadataForName(string) == null) continue;
            return true;
        }
        return false;
    }

    public Collection4 forInterface(ReflectClass reflectClass) {
        Collection4 collection4 = new Collection4();
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            ClassMetadata classMetadata = classMetadataIterator.currentClass();
            ReflectClass reflectClass2 = classMetadata.classReflector();
            if (reflectClass2.isInterface() || !reflectClass.isAssignableFrom(reflectClass2)) continue;
            collection4.add(classMetadata);
            Iterator4 iterator4 = new Collection4(collection4).iterator();
            while (iterator4.moveNext()) {
                ClassMetadata classMetadata2;
                ClassMetadata classMetadata3 = (ClassMetadata)iterator4.current();
                if (classMetadata3 == classMetadata || (classMetadata2 = classMetadata.getHigherHierarchy(classMetadata3)) == null) continue;
                if (classMetadata2 == classMetadata) {
                    collection4.remove(classMetadata3);
                    continue;
                }
                collection4.remove(classMetadata);
            }
        }
        return collection4;
    }

    public byte getIdentifier() {
        return 65;
    }

    ClassMetadata getActiveClassMetadata(ReflectClass reflectClass) {
        return (ClassMetadata)this._classMetadataByClass.get(reflectClass);
    }

    ClassMetadata classMetadataForReflectClass(ReflectClass reflectClass) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByClass.get(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = (ClassMetadata)this._classMetadataByBytes.remove(this.getNameBytes(reflectClass.getName()));
        return this.readClassMetadata(classMetadata, reflectClass);
    }

    ClassMetadata produceClassMetadata(ReflectClass reflectClass) {
        int n;
        ClassMetadata classMetadata = this.classMetadataForReflectClass(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = (ClassMetadata)this._creating.get(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = new ClassMetadata(this.container(), reflectClass);
        this._creating.put(reflectClass, (Object)classMetadata);
        if (!this.createClassMetadata(classMetadata, reflectClass)) {
            this._creating.remove(reflectClass);
            return null;
        }
        boolean bl = false;
        if (this._classMetadataByClass.get(reflectClass) == null) {
            this.addClassMetadata(classMetadata);
            bl = true;
        }
        if ((n = classMetadata.getID()) == 0) {
            classMetadata.write(this.container().systemTransaction());
            n = classMetadata.getID();
        }
        if (this._classMetadataByID.get(n) == null) {
            this._classMetadataByID.put(n, (Object)classMetadata);
            bl = true;
        }
        if (bl || classMetadata.i_fields == null) {
            this._classInits.process(classMetadata);
        }
        this._creating.remove(reflectClass);
        this.container().setDirtyInSystemTransaction(this);
        return classMetadata;
    }

    ClassMetadata getClassMetadata(int n) {
        return this.readClassMetadata((ClassMetadata)this._classMetadataByID.get(n), null);
    }

    public int classMetadataIdForName(String string) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByBytes.get(this.getNameBytes(string));
        if (classMetadata == null) {
            classMetadata = this.findInitializedClassByName(string);
        }
        if (classMetadata != null) {
            return classMetadata.getID();
        }
        return 0;
    }

    public ClassMetadata getClassMetadata(String string) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByBytes.remove(this.getNameBytes(string));
        if (classMetadata == null) {
            classMetadata = this.findInitializedClassByName(string);
        }
        if (classMetadata != null) {
            classMetadata = this.readClassMetadata(classMetadata, null);
        }
        return classMetadata;
    }

    private ClassMetadata findInitializedClassByName(String string) {
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            ClassMetadata classMetadata = (ClassMetadata)classMetadataIterator.current();
            if (!string.equals(classMetadata.getName())) continue;
            return classMetadata;
        }
        return null;
    }

    public int getClassMetadataID(String string) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByBytes.get(this.getNameBytes(string));
        if (classMetadata != null) {
            return classMetadata.getID();
        }
        return 0;
    }

    byte[] getNameBytes(String string) {
        return this.asBytes(this.resolveAliasRuntimeName(string));
    }

    private String resolveAliasRuntimeName(String string) {
        return this.container().configImpl().resolveAliasRuntimeName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initOnUp(Transaction transaction) {
        ++this._classMetadataCreationDepth;
        transaction.container().showInternalClasses(true);
        try {
            Iterator4 iterator4 = this._classes.iterator();
            while (iterator4.moveNext()) {
                ((ClassMetadata)iterator4.current()).initOnUp(transaction);
            }
        }
        finally {
            transaction.container().showInternalClasses(false);
        }
        --this._classMetadataCreationDepth;
        this.initClassMetadataOnUp();
    }

    void initTables(int n) {
        this._classes = new Collection4();
        this._classMetadataByBytes = new Hashtable4(n);
        if (n < 16) {
            n = 16;
        }
        this._classMetadataByClass = new Hashtable4(n);
        this._classMetadataByID = new Hashtable4(n);
        this._creating = new Hashtable4(1);
    }

    private void initClassMetadataOnUp() {
        if (this._classMetadataCreationDepth == 0) {
            ClassMetadata classMetadata = (ClassMetadata)this._initClassMetadataOnUp.next();
            while (classMetadata != null) {
                classMetadata.initOnUp(this._systemTransaction);
                classMetadata = (ClassMetadata)this._initClassMetadataOnUp.next();
            }
        }
    }

    public ClassMetadataIterator iterator() {
        return new ClassMetadataIterator(this, new ArrayIterator4(this._classes.toArray()));
    }

    public Iterator4 ids() {
        return new ClassIDIterator(this._classes);
    }

    public int ownLength() {
        return 4 + this._classes.size() * 4;
    }

    void purge() {
        Iterator4 iterator4 = this._classes.iterator();
        while (iterator4.moveNext()) {
            ((ClassMetadata)iterator4.current()).purge();
        }
    }

    public final void readThis(Transaction transaction, BufferImpl bufferImpl) {
        int n = bufferImpl.readInt();
        this.initTables(n);
        ObjectContainerBase objectContainerBase = this.container();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bufferImpl.readInt();
        }
        StatefulBuffer[] statefulBufferArray = objectContainerBase.readWritersByIDs(transaction, nArray);
        for (int i = 0; i < n; ++i) {
            ClassMetadata classMetadata = new ClassMetadata(objectContainerBase, null);
            classMetadata.setID(nArray[i]);
            this._classes.add(classMetadata);
            this._classMetadataByID.put(nArray[i], (Object)classMetadata);
            byte[] byArray = classMetadata.readName1(transaction, statefulBufferArray[i]);
            if (byArray == null) continue;
            this._classMetadataByBytes.put(byArray, (Object)classMetadata);
        }
        this.applyReadAs();
    }

    Hashtable4 classByBytes() {
        return this._classMetadataByBytes;
    }

    private void applyReadAs() {
        Hashtable4 hashtable4 = this.container().configImpl().readAs();
        Iterator4 iterator4 = hashtable4.iterator();
        while (iterator4.moveNext()) {
            ClassMetadata classMetadata;
            Entry4 entry4 = (Entry4)iterator4.current();
            String string = (String)entry4.key();
            String string2 = (String)entry4.value();
            byte[] byArray = this.getNameBytes(string);
            byte[] byArray2 = this.getNameBytes(string2);
            if (this.classByBytes().get(byArray2) != null || (classMetadata = (ClassMetadata)this.classByBytes().get(byArray)) == null) continue;
            classMetadata.i_nameBytes = byArray2;
            classMetadata.setConfig(this.configClass(string));
            this.classByBytes().remove(byArray);
            this.classByBytes().put(byArray2, (Object)classMetadata);
        }
    }

    private Config4Class configClass(String string) {
        return this.container().configImpl().configClass(string);
    }

    public ClassMetadata readClassMetadata(ClassMetadata classMetadata, ReflectClass reflectClass) {
        if (classMetadata == null) {
            return null;
        }
        if (!classMetadata.stateUnread()) {
            return classMetadata;
        }
        ++this._classMetadataCreationDepth;
        String string = classMetadata.resolveName(reflectClass);
        classMetadata.createConfigAndConstructor(this._classMetadataByBytes, reflectClass, string);
        ReflectClass reflectClass2 = classMetadata.classReflector();
        if (reflectClass2 != null) {
            this._classMetadataByClass.put(reflectClass2, (Object)classMetadata);
            classMetadata.readThis();
            classMetadata.checkChanges();
            this._initClassMetadataOnUp.add(classMetadata);
        }
        --this._classMetadataCreationDepth;
        this.initClassMetadataOnUp();
        return classMetadata;
    }

    public void refreshClasses() {
        ClassMetadata classMetadata;
        ClassMetadataRepository classMetadataRepository = new ClassMetadataRepository(this._systemTransaction);
        classMetadataRepository._id = this._id;
        classMetadataRepository.read(this.container().systemTransaction());
        Iterator4 iterator4 = classMetadataRepository._classes.iterator();
        while (iterator4.moveNext()) {
            classMetadata = (ClassMetadata)iterator4.current();
            this.refreshClass(classMetadata);
        }
        iterator4 = this._classes.iterator();
        while (iterator4.moveNext()) {
            classMetadata = (ClassMetadata)iterator4.current();
            classMetadata.refresh();
        }
    }

    public void refreshClass(ClassMetadata classMetadata) {
        if (this._classMetadataByID.get(classMetadata.getID()) == null) {
            this._classes.add(classMetadata);
            this._classMetadataByID.put(classMetadata.getID(), (Object)classMetadata);
            this.refreshClassCache(classMetadata, null);
        }
    }

    public void refreshClassCache(ClassMetadata classMetadata, ReflectClass reflectClass) {
        if (classMetadata.stateUnread()) {
            this._classMetadataByBytes.put(classMetadata.readName(this._systemTransaction), (Object)classMetadata);
        } else {
            if (reflectClass != null) {
                this._classMetadataByClass.remove(reflectClass);
            }
            this._classMetadataByClass.put(classMetadata.classReflector(), (Object)classMetadata);
        }
    }

    void reReadClassMetadata(ClassMetadata classMetadata) {
        if (classMetadata != null) {
            this.reReadClassMetadata(classMetadata.i_ancestor);
            classMetadata.readName(this._systemTransaction);
            classMetadata.forceRead();
            classMetadata.setStateClean();
            classMetadata.bitFalse(6);
            classMetadata.bitFalse(8);
            classMetadata.bitFalse(4);
            classMetadata.bitFalse(7);
            classMetadata.checkChanges();
        }
    }

    public StoredClass[] storedClasses() {
        this.ensureAllClassesRead();
        Object[] objectArray = new StoredClass[this._classes.size()];
        this._classes.toArray(objectArray);
        return objectArray;
    }

    public void writeAllClasses() {
        ClassMetadata classMetadata;
        int n;
        StoredClass[] storedClassArray = this.storedClasses();
        for (n = 0; n < storedClassArray.length; ++n) {
            classMetadata = (ClassMetadata)storedClassArray[n];
            classMetadata.setStateDirty();
        }
        for (n = 0; n < storedClassArray.length; ++n) {
            classMetadata = (ClassMetadata)storedClassArray[n];
            classMetadata.write(this._systemTransaction);
        }
    }

    public void writeThis(Transaction transaction, BufferImpl bufferImpl) {
        bufferImpl.writeInt(this._classes.size());
        Iterator4 iterator4 = this._classes.iterator();
        while (iterator4.moveNext()) {
            bufferImpl.writeIDOf(transaction, iterator4.current());
        }
    }

    public String toString() {
        return super.toString();
    }

    ObjectContainerBase container() {
        return this._systemTransaction.container();
    }

    public void setID(int n) {
        if (this.container().isClient()) {
            super.setID(n);
            return;
        }
        if (this._id == 0) {
            this.systemData().classCollectionID(n);
        }
        super.setID(n);
    }

    private SystemData systemData() {
        return this.localSystemTransaction().file().systemData();
    }

    private LocalTransaction localSystemTransaction() {
        return (LocalTransaction)this._systemTransaction;
    }

    private static class ClassIDIterator
    extends MappingIterator {
        public ClassIDIterator(Collection4 collection4) {
            super(collection4.iterator());
        }

        protected Object map(Object object) {
            return new Integer(((ClassMetadata)object).getID());
        }
    }
}

