/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.BitMap4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.WriteBuffer;

public class BufferImpl
implements ReadBuffer,
Buffer,
WriteBuffer {
    public byte[] _buffer;
    public int _offset;

    BufferImpl() {
    }

    public BufferImpl(int n) {
        this._buffer = new byte[n];
    }

    public void seek(int n) {
        this._offset = n;
    }

    public void writeBytes(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, this._offset, byArray.length);
        this._offset += byArray.length;
    }

    public void append(byte[] byArray) {
        this.writeBytes(byArray);
    }

    public final boolean containsTheSame(BufferImpl bufferImpl) {
        if (bufferImpl != null) {
            return Arrays4.areEqual(this._buffer, bufferImpl._buffer);
        }
        return false;
    }

    public void copyTo(BufferImpl bufferImpl, int n, int n2, int n3) {
        System.arraycopy(this._buffer, n, bufferImpl._buffer, n2, n3);
    }

    public int length() {
        return this._buffer.length;
    }

    public void incrementOffset(int n) {
        this._offset += n;
    }

    public void read(ObjectContainerBase objectContainerBase, int n, int n2) {
        objectContainerBase.readBytes(this._buffer, n, n2, this.length());
    }

    public final void readBegin(byte by) {
    }

    public BitMap4 readBitMap(int n) {
        BitMap4 bitMap4 = new BitMap4(this._buffer, this._offset, n);
        this._offset += bitMap4.marshalledLength();
        return bitMap4;
    }

    public byte readByte() {
        return this._buffer[this._offset++];
    }

    public byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        this.readBytes(byArray);
        return byArray;
    }

    public void readBytes(byte[] byArray) {
        int n = byArray.length;
        System.arraycopy(this._buffer, this._offset, byArray, 0, n);
        this._offset += n;
    }

    public final BufferImpl readEmbeddedObject(Transaction transaction) throws Db4oIOException {
        int n = this.readInt();
        int n2 = this.readInt();
        if (n == 0) {
            return null;
        }
        return transaction.container().bufferByAddress(n, n2);
    }

    public void readEncrypt(ObjectContainerBase objectContainerBase, int n) throws Db4oIOException {
        objectContainerBase.readBytes(this._buffer, n, this.length());
        objectContainerBase._handlers.decrypt(this);
    }

    public void readEnd() {
    }

    public final int readInt() {
        int n = (this._offset += 4) - 1;
        return this._buffer[n] & 0xFF | (this._buffer[--n] & 0xFF) << 8 | (this._buffer[--n] & 0xFF) << 16 | this._buffer[--n] << 24;
    }

    public long readLong() {
        return LongHandler.readLong(this);
    }

    public BufferImpl readPayloadReader(int n, int n2) {
        BufferImpl bufferImpl = new BufferImpl(n2);
        System.arraycopy(this._buffer, n, bufferImpl._buffer, 0, n2);
        return bufferImpl;
    }

    void replaceWith(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, 0, this.length());
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this._buffer.length; ++i) {
            if (i > 0) {
                string = string + " , ";
            }
            string = string + this._buffer[i];
        }
        return string;
    }

    public void writeBegin(byte by) {
    }

    public final void writeBitMap(BitMap4 bitMap4) {
        bitMap4.writeTo(this._buffer, this._offset);
        this._offset += bitMap4.marshalledLength();
    }

    public final void writeByte(byte by) {
        this._buffer[this._offset++] = by;
    }

    public void writeEnd() {
    }

    public final void writeInt(int n) {
        int n2 = this._offset + 4;
        this._offset = n2--;
        byte[] byArray = this._buffer;
        byArray[n2] = (byte)n;
        byArray[--n2] = (byte)(n >>= 8);
        byArray[--n2] = (byte)(n >>= 8);
        byArray[--n2] = (byte)(n >> 8);
    }

    public void writeIDOf(Transaction transaction, Object object) {
        if (object == null) {
            this.writeInt(0);
            return;
        }
        if (object instanceof PersistentBase) {
            this.writeIDOf(transaction, (PersistentBase)object);
            return;
        }
        this.writeInt((Integer)object);
    }

    public void writeIDOf(Transaction transaction, PersistentBase persistentBase) {
        if (persistentBase == null) {
            this.writeInt(0);
            return;
        }
        if (this.canWritePersistentBase()) {
            persistentBase.writeOwnID(transaction, this);
        } else {
            this.writeInt(persistentBase.getID());
        }
    }

    protected boolean canWritePersistentBase() {
        return true;
    }

    public void writeShortString(Transaction transaction, String string) {
        transaction.container()._handlers._stringHandler.writeShort(transaction, string, this);
    }

    public void writeLong(long l) {
        LongHandler.writeLong(this, l);
    }

    public void incrementIntSize() {
        this.incrementOffset(4);
    }

    public int offset() {
        return this._offset;
    }
}

