/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.SafeClosure4;

class BlockingByteChannel {
    private static final int DISCARD_BUFFER_SIZE = 500;
    protected byte[] i_cache;
    boolean i_closed = false;
    protected int i_readOffset;
    private int i_timeout;
    protected int i_writeOffset;
    protected final Lock4 i_lock = new Lock4();

    public BlockingByteChannel(int n) {
        this.i_timeout = n;
    }

    protected int available() {
        return this.i_writeOffset - this.i_readOffset;
    }

    protected void checkDiscardCache() {
        if (this.i_readOffset == this.i_writeOffset && this.i_cache.length > 500) {
            this.i_cache = null;
            this.i_readOffset = 0;
            this.i_writeOffset = 0;
        }
    }

    void close() {
        this.i_lock.run(new SafeClosure4(){

            public Object run() {
                BlockingByteChannel.this.i_closed = true;
                BlockingByteChannel.this.i_lock.awake();
                return null;
            }
        });
    }

    protected void makefit(int n) {
        if (this.i_cache == null) {
            this.i_cache = new byte[n];
        } else if (this.i_writeOffset + n > this.i_cache.length) {
            if (this.i_writeOffset + n - this.i_readOffset <= this.i_cache.length) {
                byte[] byArray = new byte[this.i_cache.length];
                System.arraycopy(this.i_cache, this.i_readOffset, byArray, 0, this.i_cache.length - this.i_readOffset);
                this.i_cache = byArray;
                this.i_writeOffset -= this.i_readOffset;
                this.i_readOffset = 0;
            } else {
                byte[] byArray = new byte[this.i_writeOffset + n];
                System.arraycopy(this.i_cache, 0, byArray, 0, this.i_cache.length);
                this.i_cache = byArray;
            }
        }
    }

    public int read() throws Db4oIOException {
        Integer n = (Integer)this.i_lock.run(new SafeClosure4(){

            public Object run() {
                BlockingByteChannel.this.waitForAvailable();
                byte by = BlockingByteChannel.this.i_cache[BlockingByteChannel.this.i_readOffset++];
                BlockingByteChannel.this.checkDiscardCache();
                return new Integer(by);
            }
        });
        return n;
    }

    public int read(final byte[] byArray, final int n, final int n2) throws Db4oIOException {
        Integer n3 = (Integer)this.i_lock.run(new SafeClosure4(){

            public Object run() {
                BlockingByteChannel.this.waitForAvailable();
                int n3 = BlockingByteChannel.this.available();
                int n22 = n2;
                if (n3 < n2) {
                    n22 = n3;
                }
                System.arraycopy(BlockingByteChannel.this.i_cache, BlockingByteChannel.this.i_readOffset, byArray, n, n22);
                BlockingByteChannel.this.i_readOffset += n22;
                BlockingByteChannel.this.checkDiscardCache();
                return new Integer(n22);
            }
        });
        return n3;
    }

    public void setTimeout(int n) {
        this.i_timeout = n;
    }

    protected void waitForAvailable() {
        long l = System.currentTimeMillis();
        while (this.available() == 0) {
            this.checkClosed();
            this.i_lock.snooze(this.i_timeout);
            if (!this.isTimeout(l)) continue;
            throw new Db4oIOException();
        }
    }

    private boolean isTimeout(long l) {
        return System.currentTimeMillis() - l >= (long)this.i_timeout;
    }

    public void write(byte[] byArray) throws Db4oIOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(final byte[] byArray, final int n, final int n2) throws Db4oIOException {
        this.i_lock.run(new SafeClosure4(){

            public Object run() {
                BlockingByteChannel.this.checkClosed();
                BlockingByteChannel.this.makefit(n2);
                System.arraycopy(byArray, n, BlockingByteChannel.this.i_cache, BlockingByteChannel.this.i_writeOffset, n2);
                BlockingByteChannel.this.i_writeOffset += n2;
                BlockingByteChannel.this.i_lock.awake();
                return null;
            }
        });
    }

    public void write(final int n) throws Db4oIOException {
        this.i_lock.run(new SafeClosure4(){

            public Object run() {
                BlockingByteChannel.this.checkClosed();
                BlockingByteChannel.this.makefit(1);
                BlockingByteChannel.this.i_cache[BlockingByteChannel.this.i_writeOffset++] = (byte)n;
                BlockingByteChannel.this.i_lock.awake();
                return null;
            }
        });
    }

    public void checkClosed() {
        if (this.i_closed) {
            throw new Db4oIOException();
        }
    }
}

