/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ext;

import com.db4o.Internal4;
import com.db4o.ObjectSet;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.SignatureGenerator;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.query.Query;
import com.db4o.types.Db4oType;

public class Db4oDatabase
implements Db4oType,
Internal4 {
    public static final Db4oDatabase STATIC_IDENTITY = null;
    public static final int STATIC_ID = -1;
    public byte[] i_signature;
    public long i_uuid;
    private static final String CREATIONTIME_FIELD = "i_uuid";
    private transient ObjectContainerBase i_stream;
    private transient int i_id;

    public Db4oDatabase() {
    }

    public Db4oDatabase(byte[] byArray, long l) {
        this.i_signature = byArray;
        this.i_uuid = l;
    }

    public static Db4oDatabase generate() {
        StatefulBuffer statefulBuffer = new StatefulBuffer(null, 300);
        new LatinStringIO().write(statefulBuffer, SignatureGenerator.generateSignature());
        return new Db4oDatabase(statefulBuffer.getWrittenBytes(), System.currentTimeMillis());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Db4oDatabase db4oDatabase = (Db4oDatabase)object;
        if (null == db4oDatabase.i_signature || null == this.i_signature) {
            return false;
        }
        return Arrays4.areEqual(db4oDatabase.i_signature, this.i_signature);
    }

    public int hashCode() {
        return this.i_signature.hashCode();
    }

    public int getID(Transaction transaction) {
        ObjectContainerBase objectContainerBase = transaction.container();
        if (objectContainerBase != this.i_stream) {
            this.i_stream = objectContainerBase;
            this.i_id = this.bind(transaction);
        }
        return this.i_id;
    }

    public long getCreationTime() {
        return this.i_uuid;
    }

    public byte[] getSignature() {
        return this.i_signature;
    }

    public String toString() {
        return "db " + this.i_signature;
    }

    public boolean isOlderThan(Db4oDatabase db4oDatabase) {
        if (db4oDatabase == this) {
            throw new IllegalArgumentException();
        }
        if (this.i_uuid != db4oDatabase.i_uuid) {
            return this.i_uuid < db4oDatabase.i_uuid;
        }
        if (this.i_signature.length != db4oDatabase.i_signature.length) {
            return this.i_signature.length < db4oDatabase.i_signature.length;
        }
        for (int i = 0; i < this.i_signature.length; ++i) {
            if (this.i_signature[i] == db4oDatabase.i_signature[i]) continue;
            return this.i_signature[i] < db4oDatabase.i_signature[i];
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bind(Transaction transaction) {
        ObjectContainerBase objectContainerBase = transaction.container();
        Db4oDatabase db4oDatabase = (Db4oDatabase)objectContainerBase.db4oTypeStored(transaction, this);
        if (db4oDatabase == null) {
            return this.storeAndGetId(transaction);
        }
        if (db4oDatabase == this) {
            return objectContainerBase.getID(transaction, this);
        }
        if (this.i_uuid == 0L) {
            this.i_uuid = db4oDatabase.i_uuid;
        }
        objectContainerBase.showInternalClasses(true);
        try {
            int n = objectContainerBase.getID(transaction, db4oDatabase);
            objectContainerBase.bind(transaction, this, n);
            int n2 = n;
            return n2;
        }
        finally {
            objectContainerBase.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int storeAndGetId(Transaction transaction) {
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.showInternalClasses(true);
        try {
            objectContainerBase.set3(transaction, this, 2, false);
            int n = objectContainerBase.getID(transaction, this);
            return n;
        }
        finally {
            objectContainerBase.showInternalClasses(false);
        }
    }

    public Db4oDatabase query(Transaction transaction) {
        Db4oDatabase db4oDatabase;
        if (this.i_uuid > 0L && (db4oDatabase = this.query(transaction, true)) != null) {
            return db4oDatabase;
        }
        return this.query(transaction, false);
    }

    private Db4oDatabase query(Transaction transaction, boolean bl) {
        ObjectContainerBase objectContainerBase = transaction.container();
        Query query = objectContainerBase.query(transaction);
        query.constrain(this.getClass());
        if (bl) {
            query.descend(CREATIONTIME_FIELD).constrain(new Long(this.i_uuid));
        }
        ObjectSet objectSet = query.execute();
        while (objectSet.hasNext()) {
            Db4oDatabase db4oDatabase = (Db4oDatabase)objectSet.next();
            objectContainerBase.activate(null, db4oDatabase, new FixedActivationDepth(4));
            if (!db4oDatabase.equals(this)) continue;
            return db4oDatabase;
        }
        return null;
    }
}

