/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.marshall.ObjectHeader;
import java.io.IOException;

final class SecondPassCommand
implements PassCommand {
    protected final int _objectCommitFrequency;
    protected int _objectCount = 0;

    public SecondPassCommand(int n) {
        this._objectCommitFrequency = n;
    }

    public void processClass(DefragmentServicesImpl defragmentServicesImpl, final ClassMetadata classMetadata, int n, final int n2) throws CorruptionException, IOException {
        if (defragmentServicesImpl.mappedID(n, -1) == -1) {
            System.err.println("MAPPING NOT FOUND: " + n);
        }
        DefragmentContextImpl.processCopy(defragmentServicesImpl, n, new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl defragmentContextImpl) throws CorruptionException, IOException {
                classMetadata.defragClass(defragmentContextImpl, n2);
            }
        });
    }

    public void processObjectSlot(final DefragmentServicesImpl defragmentServicesImpl, ClassMetadata classMetadata, int n) throws CorruptionException, IOException {
        BufferImpl bufferImpl = defragmentServicesImpl.sourceBufferByID(n);
        ObjectHeader objectHeader = defragmentServicesImpl.sourceObjectHeader(bufferImpl);
        bufferImpl._offset = 0;
        boolean bl = defragmentServicesImpl.hasFieldIndex(objectHeader.classMetadata());
        DefragmentContextImpl.processCopy(defragmentServicesImpl, n, new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl defragmentContextImpl) {
                ClassMetadata.defragObject(defragmentContextImpl);
                if (SecondPassCommand.this._objectCommitFrequency > 0) {
                    ++SecondPassCommand.this._objectCount;
                    if (SecondPassCommand.this._objectCount == SecondPassCommand.this._objectCommitFrequency) {
                        defragmentServicesImpl.targetCommit();
                        SecondPassCommand.this._objectCount = 0;
                    }
                }
            }
        }, bl, bufferImpl);
    }

    public void processClassCollection(final DefragmentServicesImpl defragmentServicesImpl) throws CorruptionException, IOException {
        DefragmentContextImpl.processCopy(defragmentServicesImpl, defragmentServicesImpl.sourceClassCollectionID(), new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl defragmentContextImpl) {
                int n = 0;
                int n2 = defragmentContextImpl.target().offset();
                n = this.copyAcceptedClasses(defragmentContextImpl, n);
                this.writeIntAt(defragmentContextImpl.target(), n2, n);
            }

            private int copyAcceptedClasses(DefragmentContextImpl defragmentContextImpl, int n) {
                int n2 = defragmentContextImpl.readInt();
                for (int i = 0; i < n2; ++i) {
                    int n3 = defragmentContextImpl.source().readInt();
                    if (!this.accept(n3)) continue;
                    ++n;
                    defragmentContextImpl.writeMappedID(n3);
                }
                return n;
            }

            private void writeIntAt(BufferImpl bufferImpl, int n, int n2) {
                int n3 = bufferImpl.offset();
                bufferImpl.seek(n);
                bufferImpl.writeInt(n2);
                bufferImpl.seek(n3);
            }

            private boolean accept(int n) {
                return defragmentServicesImpl.accept(defragmentServicesImpl.classMetadataForId(n));
            }
        });
    }

    public void processBTree(DefragmentServicesImpl defragmentServicesImpl, BTree bTree) throws CorruptionException, IOException {
        bTree.defragBTree(defragmentServicesImpl);
    }

    public void flush(DefragmentServicesImpl defragmentServicesImpl) {
    }
}

