/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.slots.Slot;

final class FirstPassCommand
implements PassCommand {
    private static final int ID_BATCH_SIZE = 4096;
    private TreeInt _ids;

    FirstPassCommand() {
    }

    void process(DefragmentServicesImpl defragmentServicesImpl, int n, boolean bl) {
        if (this.batchFull()) {
            this.flush(defragmentServicesImpl);
        }
        this._ids = TreeInt.add(this._ids, bl ? -n : n);
    }

    private boolean batchFull() {
        return this._ids != null && this._ids.size() == 4096;
    }

    public void processClass(DefragmentServicesImpl defragmentServicesImpl, ClassMetadata classMetadata, int n, int n2) {
        this.process(defragmentServicesImpl, n, true);
        for (int i = 0; i < classMetadata.i_fields.length; ++i) {
            FieldMetadata fieldMetadata = classMetadata.i_fields[i];
            if (fieldMetadata.isVirtual() || !fieldMetadata.hasIndex()) continue;
            this.processBTree(defragmentServicesImpl, fieldMetadata.getIndex(defragmentServicesImpl.systemTrans()));
        }
    }

    public void processObjectSlot(DefragmentServicesImpl defragmentServicesImpl, ClassMetadata classMetadata, int n) {
        this.process(defragmentServicesImpl, n, false);
    }

    public void processClassCollection(DefragmentServicesImpl defragmentServicesImpl) throws CorruptionException {
        this.process(defragmentServicesImpl, defragmentServicesImpl.sourceClassCollectionID(), false);
    }

    public void processBTree(final DefragmentServicesImpl defragmentServicesImpl, BTree bTree) {
        this.process(defragmentServicesImpl, bTree.getID(), false);
        defragmentServicesImpl.traverseAllIndexSlots(bTree, new Visitor4(){

            public void visit(Object object) {
                int n = (Integer)object;
                FirstPassCommand.this.process(defragmentServicesImpl, n, false);
            }
        });
    }

    public void flush(DefragmentServicesImpl defragmentServicesImpl) {
        if (this._ids == null) {
            return;
        }
        int n = defragmentServicesImpl.blockSize();
        int n2 = Math.max(8, n);
        boolean bl = 8 % n > 0;
        int n3 = 8 / n;
        if (bl) {
            ++n3;
        }
        int n4 = this._ids.size() * n2;
        Slot slot = defragmentServicesImpl.allocateTargetSlot(n4);
        int n5 = slot.address();
        TreeKeyIterator treeKeyIterator = new TreeKeyIterator(this._ids);
        while (treeKeyIterator.moveNext()) {
            int n6 = (Integer)treeKeyIterator.current();
            boolean bl2 = false;
            if (n6 < 0) {
                n6 = -n6;
                bl2 = true;
            }
            defragmentServicesImpl.mapIDs(n6, n5, bl2);
            n5 += n3;
        }
        this._ids = null;
    }
}

