/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.defragment.ContextIDMapping;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.io.File4;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferImpl;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.mapping.DefragmentServices;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DefragmentServicesImpl
implements DefragmentServices {
    public static final DbSelector SOURCEDB = new DbSelector(){

        LocalObjectContainer db(DefragmentServicesImpl defragmentServicesImpl) {
            return defragmentServicesImpl._sourceDb;
        }
    };
    public static final DbSelector TARGETDB = new DbSelector(){

        LocalObjectContainer db(DefragmentServicesImpl defragmentServicesImpl) {
            return defragmentServicesImpl._targetDb;
        }
    };
    private static final long CLASSCOLLECTION_POINTER_ADDRESS = 10L;
    public final LocalObjectContainer _sourceDb;
    final LocalObjectContainer _targetDb;
    private final ContextIDMapping _mapping;
    private DefragmentListener _listener;
    private Queue4 _unindexed = new NonblockingQueue();
    private final Hashtable4 _hasFieldIndexCache = new Hashtable4();
    private DefragmentConfig _defragConfig;
    private Hashtable4 _classIndices = new Hashtable4(16);

    public DefragmentServicesImpl(DefragmentConfig defragmentConfig, DefragmentListener defragmentListener) {
        this._listener = defragmentListener;
        Config4Impl config4Impl = (Config4Impl)defragmentConfig.db4oConfig();
        Configuration configuration = (Configuration)config4Impl.deepClone(null);
        configuration.weakReferences(false);
        configuration.flushFileBuffers(false);
        configuration.readOnly(true);
        this._sourceDb = (LocalObjectContainer)Db4o.openFile(configuration, defragmentConfig.tempPath()).ext();
        this._targetDb = DefragmentServicesImpl.freshYapFile(defragmentConfig);
        this._mapping = defragmentConfig.mapping();
        this._mapping.open();
        this._defragConfig = defragmentConfig;
    }

    static LocalObjectContainer freshYapFile(String string, int n) {
        File4.delete(string);
        return (LocalObjectContainer)Db4o.openFile(DefragmentConfig.vanillaDb4oConfig(n), string).ext();
    }

    static LocalObjectContainer freshYapFile(DefragmentConfig defragmentConfig) {
        File4.delete(defragmentConfig.origPath());
        return (LocalObjectContainer)Db4o.openFile(defragmentConfig.clonedDb4oConfig(), defragmentConfig.origPath()).ext();
    }

    public int mappedID(int n, int n2) {
        int n3 = this.internalMappedID(n, false);
        return n3 != 0 ? n3 : n2;
    }

    public int mappedID(int n) throws MappingNotFoundException {
        int n2 = this.internalMappedID(n, false);
        if (n2 == 0) {
            throw new MappingNotFoundException(n);
        }
        return n2;
    }

    public int mappedID(int n, boolean bl) throws MappingNotFoundException {
        if (n == 0) {
            return 0;
        }
        int n2 = this.internalMappedID(n, bl);
        if (n2 == 0) {
            this._listener.notifyDefragmentInfo(new DefragmentInfo("No mapping found for ID " + n));
            return 0;
        }
        return n2;
    }

    private int internalMappedID(int n, boolean bl) throws MappingNotFoundException {
        if (n == 0) {
            return 0;
        }
        if (this._sourceDb.handlers().isSystemHandler(n)) {
            return n;
        }
        return this._mapping.mappedID(n, bl);
    }

    public void mapIDs(int n, int n2, boolean bl) {
        this._mapping.mapIDs(n, n2, bl);
    }

    public void close() {
        this._sourceDb.close();
        this._targetDb.close();
        this._mapping.close();
    }

    public BufferImpl bufferByID(DbSelector dbSelector, int n) {
        Slot slot = this.readPointer(dbSelector, n);
        return this.bufferByAddress(dbSelector, slot.address(), slot.length());
    }

    public BufferImpl sourceBufferByAddress(int n, int n2) throws IOException {
        return this.bufferByAddress(SOURCEDB, n, n2);
    }

    public BufferImpl targetBufferByAddress(int n, int n2) throws IOException {
        return this.bufferByAddress(TARGETDB, n, n2);
    }

    public BufferImpl bufferByAddress(DbSelector dbSelector, int n, int n2) {
        return dbSelector.db(this).bufferByAddress(n, n2);
    }

    public StatefulBuffer targetStatefulBufferByAddress(int n, int n2) throws IllegalArgumentException {
        return this._targetDb.readWriterByAddress(TARGETDB.transaction(this), n, n2);
    }

    public Slot allocateTargetSlot(int n) {
        return this._targetDb.getSlot(n);
    }

    public void targetWriteBytes(DefragmentContextImpl defragmentContextImpl, int n) {
        defragmentContextImpl.write(this._targetDb, n);
    }

    public void targetWriteBytes(BufferImpl bufferImpl, int n) {
        this._targetDb.writeBytes(bufferImpl, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(DbSelector dbSelector) {
        LocalObjectContainer localObjectContainer = dbSelector.db(this);
        localObjectContainer.showInternalClasses(true);
        try {
            StoredClass[] storedClassArray = localObjectContainer.classCollection().storedClasses();
            return storedClassArray;
        }
        finally {
            localObjectContainer.showInternalClasses(false);
        }
    }

    public LatinStringIO stringIO() {
        return this._sourceDb.stringIO();
    }

    public void targetCommit() {
        this._targetDb.commit();
    }

    public TypeHandler4 sourceHandler(int n) {
        return this._sourceDb.handlerByID(n);
    }

    public int sourceClassCollectionID() {
        return this._sourceDb.classCollection().getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void targetClassCollectionID(String string, int n) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        try {
            BufferImpl bufferImpl = new BufferImpl(4);
            randomAccessFile.seek(10L);
            bufferImpl._offset = 0;
            bufferImpl.writeInt(n);
            randomAccessFile.write(bufferImpl._buffer);
        }
        finally {
            randomAccessFile.close();
        }
    }

    public int classIndexID(ClassMetadata classMetadata) {
        return this.classIndex(classMetadata).id();
    }

    public void traverseAll(ClassMetadata classMetadata, Visitor4 visitor4) {
        if (!classMetadata.hasClassIndex()) {
            return;
        }
        classMetadata.index().traverseAll(SOURCEDB.transaction(this), visitor4);
    }

    public void traverseAllIndexSlots(ClassMetadata classMetadata, Visitor4 visitor4) {
        Iterator4 iterator4 = classMetadata.index().allSlotIDs(SOURCEDB.transaction(this));
        while (iterator4.moveNext()) {
            visitor4.visit(iterator4.current());
        }
    }

    public void traverseAllIndexSlots(BTree bTree, Visitor4 visitor4) {
        Iterator4 iterator4 = bTree.allNodeIds(SOURCEDB.transaction(this));
        while (iterator4.moveNext()) {
            visitor4.visit(iterator4.current());
        }
    }

    public int databaseIdentityID(DbSelector dbSelector) {
        LocalObjectContainer localObjectContainer = dbSelector.db(this);
        Db4oDatabase db4oDatabase = localObjectContainer.identity();
        if (db4oDatabase == null) {
            return 0;
        }
        return db4oDatabase.getID(dbSelector.transaction(this));
    }

    private ClassIndexStrategy classIndex(ClassMetadata classMetadata) {
        ClassIndexStrategy classIndexStrategy = (ClassIndexStrategy)this._classIndices.get(classMetadata);
        if (classIndexStrategy == null) {
            classIndexStrategy = new BTreeClassIndexStrategy(classMetadata);
            this._classIndices.put(classMetadata, (Object)classIndexStrategy);
            classIndexStrategy.initialize(this._targetDb);
        }
        return classIndexStrategy;
    }

    public Transaction systemTrans() {
        return SOURCEDB.transaction(this);
    }

    public void copyIdentity() {
        this._targetDb.setIdentity(this._sourceDb.identity());
    }

    public void targetClassCollectionID(int n) {
        this._targetDb.systemData().classCollectionID(n);
    }

    public BufferImpl sourceBufferByID(int n) throws IOException {
        return this.bufferByID(SOURCEDB, n);
    }

    public BTree sourceUuidIndex() {
        if (this.sourceUuidIndexID() == 0) {
            return null;
        }
        return this._sourceDb.uUIDIndex().getIndex(this.systemTrans());
    }

    public void targetUuidIndexID(int n) {
        this._targetDb.systemData().uuidIndexId(n);
    }

    public int sourceUuidIndexID() {
        return this._sourceDb.systemData().uuidIndexId();
    }

    public ClassMetadata classMetadataForId(int n) {
        return this._sourceDb.classMetadataForId(n);
    }

    public void registerUnindexed(int n) {
        this._unindexed.add(new Integer(n));
    }

    public Iterator4 unindexedIDs() {
        return this._unindexed.iterator();
    }

    public ObjectHeader sourceObjectHeader(BufferImpl bufferImpl) {
        return new ObjectHeader(this._sourceDb, (Buffer)bufferImpl);
    }

    private Slot readPointer(DbSelector dbSelector, int n) {
        BufferImpl bufferImpl = this.bufferByAddress(dbSelector, n, 8);
        int n2 = bufferImpl.readInt();
        int n3 = bufferImpl.readInt();
        return new Slot(n2, n3);
    }

    public boolean hasFieldIndex(ClassMetadata classMetadata) {
        TernaryBool ternaryBool = (TernaryBool)this._hasFieldIndexCache.get(classMetadata);
        if (ternaryBool != null) {
            return ternaryBool.definiteYes();
        }
        boolean bl = false;
        Iterator4 iterator4 = classMetadata.fields();
        while (iterator4.moveNext()) {
            FieldMetadata fieldMetadata = (FieldMetadata)iterator4.current();
            if (!fieldMetadata.hasIndex() || !(fieldMetadata.getHandler() instanceof StringHandler)) continue;
            bl = true;
            break;
        }
        this._hasFieldIndexCache.put(classMetadata, (Object)TernaryBool.forBoolean(bl));
        return bl;
    }

    public int blockSize() {
        return this._sourceDb.config().blockSize();
    }

    public int sourceAddressByID(int n) {
        return this.readPointer(SOURCEDB, n).address();
    }

    public boolean accept(StoredClass storedClass) {
        return this._defragConfig.storedClassFilter().accept(storedClass);
    }

    public static abstract class DbSelector {
        DbSelector() {
        }

        abstract LocalObjectContainer db(DefragmentServicesImpl var1);

        Transaction transaction(DefragmentServicesImpl defragmentServicesImpl) {
            return this.db(defragmentServicesImpl).systemTransaction();
        }
    }
}

