/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.FirstPassCommand;
import com.db4o.defragment.PassCommand;
import com.db4o.defragment.SecondPassCommand;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.io.File4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import java.io.File;
import java.io.IOException;

public class Defragment {
    public static void defrag(String string) throws IOException {
        Defragment.defrag(new DefragmentConfig(string), new NullListener());
    }

    public static void defrag(String string, String string2) throws IOException {
        Defragment.defrag(new DefragmentConfig(string, string2), new NullListener());
    }

    public static void defrag(DefragmentConfig defragmentConfig) throws IOException {
        Defragment.defrag(defragmentConfig, new NullListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defrag(DefragmentConfig defragmentConfig, DefragmentListener defragmentListener) throws IOException {
        File file = new File(defragmentConfig.backupPath());
        if (file.exists()) {
            if (!defragmentConfig.forceBackupDelete()) {
                throw new IOException("Could not use '" + defragmentConfig.backupPath() + "' as backup path - file exists.");
            }
            file.delete();
        }
        File4.rename(defragmentConfig.origPath(), defragmentConfig.backupPath());
        if (defragmentConfig.fileNeedsUpgrade()) {
            Defragment.upgradeFile(defragmentConfig);
        }
        DefragmentServicesImpl defragmentServicesImpl = new DefragmentServicesImpl(defragmentConfig, defragmentListener);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            Defragment.firstPass(defragmentServicesImpl, defragmentConfig);
            Defragment.secondPass(defragmentServicesImpl, defragmentConfig);
            Defragment.defragUnindexed(defragmentServicesImpl);
            n = defragmentServicesImpl.mappedID(defragmentServicesImpl.sourceClassCollectionID());
            defragmentServicesImpl.targetClassCollectionID(n);
            int n4 = defragmentServicesImpl.databaseIdentityID(DefragmentServicesImpl.SOURCEDB);
            n2 = defragmentServicesImpl.mappedID(n4, 0);
            n3 = defragmentServicesImpl.mappedID(defragmentServicesImpl.sourceUuidIndexID(), 0);
        }
        catch (CorruptionException corruptionException) {
            corruptionException.printStackTrace();
        }
        finally {
            defragmentServicesImpl.close();
        }
        if (n2 > 0) {
            Defragment.setIdentity(defragmentConfig, n2, n3);
        } else {
            defragmentListener.notifyDefragmentInfo(new DefragmentInfo("No database identity found in original file."));
        }
    }

    private static void upgradeFile(DefragmentConfig defragmentConfig) throws IOException {
        File4.copy(defragmentConfig.backupPath(), defragmentConfig.tempPath());
        Configuration configuration = (Configuration)((Config4Impl)defragmentConfig.db4oConfig()).deepClone(null);
        configuration.allowVersionUpdates(true);
        ObjectContainer objectContainer = Db4o.openFile(configuration, defragmentConfig.tempPath());
        objectContainer.close();
    }

    private static void defragUnindexed(DefragmentServicesImpl defragmentServicesImpl) throws CorruptionException, IOException {
        Iterator4 iterator4 = defragmentServicesImpl.unindexedIDs();
        while (iterator4.moveNext()) {
            int n = (Integer)iterator4.current();
            DefragmentContextImpl.processCopy(defragmentServicesImpl, n, new SlotCopyHandler(){

                public void processCopy(DefragmentContextImpl defragmentContextImpl) throws CorruptionException {
                    ClassMetadata.defragObject(defragmentContextImpl);
                }
            }, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setIdentity(DefragmentConfig defragmentConfig, int n, int n2) {
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)Db4o.openFile(defragmentConfig.clonedDb4oConfig(), defragmentConfig.origPath());
        try {
            Db4oDatabase db4oDatabase = (Db4oDatabase)localObjectContainer.getByID(n);
            localObjectContainer.setIdentity(db4oDatabase);
            localObjectContainer.systemData().uuidIndexId(n2);
        }
        finally {
            localObjectContainer.close();
        }
    }

    private static void firstPass(DefragmentServicesImpl defragmentServicesImpl, DefragmentConfig defragmentConfig) throws CorruptionException, IOException {
        Defragment.pass(defragmentServicesImpl, defragmentConfig, new FirstPassCommand());
    }

    private static void secondPass(DefragmentServicesImpl defragmentServicesImpl, DefragmentConfig defragmentConfig) throws CorruptionException, IOException {
        Defragment.pass(defragmentServicesImpl, defragmentConfig, new SecondPassCommand(defragmentConfig.objectCommitFrequency()));
    }

    private static void pass(DefragmentServicesImpl defragmentServicesImpl, DefragmentConfig defragmentConfig, PassCommand passCommand) throws CorruptionException, IOException {
        passCommand.processClassCollection(defragmentServicesImpl);
        StoredClass[] storedClassArray = defragmentServicesImpl.storedClasses(DefragmentServicesImpl.SOURCEDB);
        for (int i = 0; i < storedClassArray.length; ++i) {
            ClassMetadata classMetadata = (ClassMetadata)storedClassArray[i];
            if (!defragmentConfig.storedClassFilter().accept(classMetadata)) continue;
            Defragment.processYapClass(defragmentServicesImpl, classMetadata, passCommand);
            passCommand.flush(defragmentServicesImpl);
            if (defragmentConfig.objectCommitFrequency() <= 0) continue;
            defragmentServicesImpl.targetCommit();
        }
        BTree bTree = defragmentServicesImpl.sourceUuidIndex();
        if (bTree != null) {
            passCommand.processBTree(defragmentServicesImpl, bTree);
        }
        passCommand.flush(defragmentServicesImpl);
        defragmentServicesImpl.targetCommit();
    }

    private static void processYapClass(DefragmentServicesImpl defragmentServicesImpl, ClassMetadata classMetadata, PassCommand passCommand) throws CorruptionException, IOException {
        Defragment.processClassIndex(defragmentServicesImpl, classMetadata, passCommand);
        if (!Defragment.parentHasIndex(classMetadata)) {
            Defragment.processObjectsForYapClass(defragmentServicesImpl, classMetadata, passCommand);
        }
        Defragment.processYapClassAndFieldIndices(defragmentServicesImpl, classMetadata, passCommand);
    }

    private static boolean parentHasIndex(ClassMetadata classMetadata) {
        ClassMetadata classMetadata2 = classMetadata.i_ancestor;
        while (classMetadata2 != null) {
            if (classMetadata2.hasClassIndex()) {
                return true;
            }
            classMetadata2 = classMetadata2.i_ancestor;
        }
        return false;
    }

    private static void processObjectsForYapClass(final DefragmentServicesImpl defragmentServicesImpl, final ClassMetadata classMetadata, final PassCommand passCommand) {
        defragmentServicesImpl.traverseAll(classMetadata, new Visitor4(){

            public void visit(Object object) {
                int n = (Integer)object;
                try {
                    passCommand.processObjectSlot(defragmentServicesImpl, classMetadata, n);
                }
                catch (CorruptionException corruptionException) {
                    corruptionException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    private static void processYapClassAndFieldIndices(DefragmentServicesImpl defragmentServicesImpl, ClassMetadata classMetadata, PassCommand passCommand) throws CorruptionException, IOException {
        int n = 0;
        int n2 = 0;
        if (classMetadata.hasClassIndex()) {
            n = classMetadata.index().id();
            n2 = defragmentServicesImpl.mappedID(n, -1);
        }
        passCommand.processClass(defragmentServicesImpl, classMetadata, classMetadata.getID(), n2);
    }

    private static void processClassIndex(DefragmentServicesImpl defragmentServicesImpl, ClassMetadata classMetadata, PassCommand passCommand) throws CorruptionException, IOException {
        if (classMetadata.hasClassIndex()) {
            BTreeClassIndexStrategy bTreeClassIndexStrategy = (BTreeClassIndexStrategy)classMetadata.index();
            BTree bTree = bTreeClassIndexStrategy.btree();
            passCommand.processBTree(defragmentServicesImpl, bTree);
        }
    }

    static class NullListener
    implements DefragmentListener {
        NullListener() {
        }

        public void notifyDefragmentInfo(DefragmentInfo defragmentInfo) {
        }
    }
}

