/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.P1Collection;
import com.db4o.P1HashElement;
import com.db4o.P1ListElement;
import com.db4o.P2HashMapIterator;
import com.db4o.P2HashMapKeySet;
import com.db4o.TransactionListener;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.Transaction;
import com.db4o.types.Db4oMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class P2HashMap
extends P1Collection
implements Db4oMap,
TransactionListener {
    private static final float FILL = 0.6f;
    private transient int i_changes;
    private transient boolean i_dontStoreOnDeactivate;
    public P1HashElement[] i_entries;
    public int i_mask;
    public int i_maximumSize;
    public int i_size;
    public int i_type;
    transient P1HashElement[] i_table;
    public int i_tableSize;

    P2HashMap() {
    }

    P2HashMap(int n) {
        n = (int)((float)n / 0.6f);
        this.i_tableSize = 1;
        while (this.i_tableSize < n) {
            this.i_tableSize <<= 1;
        }
        this.i_mask = this.i_tableSize - 1;
        this.i_maximumSize = (int)((float)this.i_tableSize * 0.6f);
        this.i_table = new P1HashElement[this.i_tableSize];
    }

    public void checkActive() {
        super.checkActive();
        if (this.i_table == null) {
            this.i_table = new P1HashElement[this.i_tableSize];
            if (this.i_entries != null) {
                for (int i = 0; i < this.i_entries.length; ++i) {
                    if (this.i_entries[i] == null) continue;
                    this.i_entries[i].checkActive();
                    this.i_table[this.i_entries[i].i_position] = this.i_entries[i];
                }
            }
            this.i_changes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            if (this.i_size != 0) {
                int n;
                for (n = 0; n < this.i_table.length; ++n) {
                    this.deleteAllElements(this.i_table[n]);
                    this.i_table[n] = null;
                }
                if (this.i_entries != null) {
                    for (n = 0; n < this.i_entries.length; ++n) {
                        this.i_entries[n] = null;
                    }
                }
                this.i_size = 0;
                this.modified();
            }
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object createDefault(Transaction transaction) {
        this.checkActive();
        P2HashMap p2HashMap = new P2HashMap(this.i_size);
        p2HashMap.i_type = this.i_type;
        p2HashMap.setTrans(transaction);
        P2HashMapIterator p2HashMapIterator = new P2HashMapIterator(this);
        while (p2HashMapIterator.hasNext()) {
            Object object = p2HashMapIterator.next();
            if (object == null) continue;
            p2HashMap.put4(object, this.get4(object));
        }
        return p2HashMap;
    }

    private void deleteAllElements(P1HashElement p1HashElement) {
        if (p1HashElement != null) {
            p1HashElement.checkActive();
            this.deleteAllElements((P1HashElement)p1HashElement.i_next);
            p1HashElement.delete(this.i_deleteRemoved);
        }
    }

    public Set entrySet() {
        HashSet<MapEntry> hashSet = new HashSet<MapEntry>(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = this.get(e);
            MapEntry mapEntry = new MapEntry(e);
            mapEntry.setValue(object);
            hashSet.add(mapEntry);
        }
        return hashSet;
    }

    private boolean equals(P1HashElement p1HashElement, int n, Object object) {
        return p1HashElement.i_hashCode == n && p1HashElement.activatedKey(this.elementActivationDepth()).equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Object object2 = this.streamLock();
        synchronized (object2) {
            this.checkActive();
            return this.get4(object);
        }
    }

    Object get4(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hashOf(object);
        P1HashElement p1HashElement = this.i_table[n & this.i_mask];
        while (p1HashElement != null) {
            p1HashElement.checkActive();
            if (this.equals(p1HashElement, n, object)) {
                return p1HashElement.activatedObject(this.elementActivationDepth());
            }
            p1HashElement = (P1HashElement)p1HashElement.i_next;
        }
        return null;
    }

    private int hashOf(Object object) {
        if (this.i_type == 1) {
            int n = (int)this.getIDOf(object);
            if (n == 0) {
                this.store(object);
            }
            if ((n = (int)this.getIDOf(object)) == 0) {
                Exceptions4.throwRuntimeException(62);
            }
            return n;
        }
        return object.hashCode();
    }

    private void increaseSize() {
        this.i_tableSize <<= 1;
        this.i_maximumSize = (int)((float)this.i_tableSize * 0.6f);
        this.i_mask = this.i_tableSize - 1;
        P1HashElement[] p1HashElementArray = this.i_table;
        this.i_table = new P1HashElement[this.i_tableSize];
        for (int i = 0; i < p1HashElementArray.length; ++i) {
            this.reposition(p1HashElementArray[i]);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new P2HashMapKeySet(this);
    }

    void modified() {
        if (this.getTrans() != null) {
            if (this.i_changes == 0) {
                this.getTrans().addTransactionListener(this);
            }
            ++this.i_changes;
        }
    }

    public void postRollback() {
        this.i_dontStoreOnDeactivate = true;
        this.deactivate();
        this.i_dontStoreOnDeactivate = false;
    }

    public void preCommit() {
        if (this.i_changes > 0) {
            int n;
            Collection4 collection4 = new Collection4();
            for (n = 0; n < this.i_table.length; ++n) {
                if (this.i_table[n] == null) continue;
                this.i_table[n].checkActive();
                if (this.i_table[n].i_position != n) {
                    this.i_table[n].i_position = n;
                    this.i_table[n].update();
                }
                collection4.add(this.i_table[n]);
            }
            if (this.i_entries == null || this.i_entries.length != collection4.size()) {
                this.i_entries = new P1HashElement[collection4.size()];
            }
            n = 0;
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.moveNext()) {
                this.i_entries[n++] = (P1HashElement)iterator4.current();
            }
            this.store(2);
        }
        this.i_changes = 0;
    }

    public void preDeactivate() {
        if (!this.i_dontStoreOnDeactivate) {
            this.preCommit();
        }
        this.i_table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Object object3 = this.streamLock();
        synchronized (object3) {
            this.checkActive();
            return this.put4(object, object2);
        }
    }

    private Object put4(Object object, Object object2) {
        int n = this.hashOf(object);
        P1HashElement p1HashElement = new P1HashElement(this.getTrans(), null, object, n, object2);
        ++this.i_size;
        if (this.i_size > this.i_maximumSize) {
            this.increaseSize();
        }
        this.modified();
        int n2 = p1HashElement.i_hashCode & this.i_mask;
        P1HashElement p1HashElement2 = this.i_table[n2];
        P1HashElement p1HashElement3 = null;
        while (p1HashElement2 != null) {
            p1HashElement2.checkActive();
            if (this.equals(p1HashElement2, p1HashElement.i_hashCode, object)) {
                --this.i_size;
                Object object3 = p1HashElement2.activatedObject(this.elementActivationDepth());
                p1HashElement.i_next = p1HashElement2.i_next;
                this.store(p1HashElement);
                if (p1HashElement3 != null) {
                    p1HashElement3.i_next = p1HashElement;
                    p1HashElement3.update();
                } else {
                    this.i_table[n2] = p1HashElement;
                }
                p1HashElement2.delete(this.i_deleteRemoved);
                return object3;
            }
            p1HashElement3 = p1HashElement2;
            p1HashElement2 = (P1HashElement)p1HashElement2.i_next;
        }
        p1HashElement.i_next = this.i_table[n2];
        this.i_table[n2] = p1HashElement;
        this.store(p1HashElement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (k == null) continue;
                this.put4(k, map.get(k));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        Object object2 = this.streamLock();
        synchronized (object2) {
            this.checkActive();
            return this.remove4(object);
        }
    }

    Object remove4(Object object) {
        int n = this.hashOf(object);
        P1HashElement p1HashElement = this.i_table[n & this.i_mask];
        P1HashElement p1HashElement2 = null;
        while (p1HashElement != null) {
            p1HashElement.checkActive();
            if (this.equals(p1HashElement, n, object)) {
                if (p1HashElement2 != null) {
                    p1HashElement2.i_next = p1HashElement.i_next;
                    p1HashElement2.update();
                } else {
                    this.i_table[n & this.i_mask] = (P1HashElement)p1HashElement.i_next;
                }
                this.modified();
                --this.i_size;
                Object object2 = p1HashElement.activatedObject(this.elementActivationDepth());
                p1HashElement.delete(this.i_deleteRemoved);
                return object2;
            }
            p1HashElement2 = p1HashElement;
            p1HashElement = (P1HashElement)p1HashElement.i_next;
        }
        return null;
    }

    private void reposition(P1HashElement p1HashElement) {
        if (p1HashElement != null) {
            this.reposition((P1HashElement)p1HashElement.i_next);
            p1HashElement.checkActive();
            P1ListElement p1ListElement = p1HashElement.i_next;
            p1HashElement.i_next = this.i_table[p1HashElement.i_hashCode & this.i_mask];
            if (p1HashElement.i_next != p1ListElement) {
                p1HashElement.update();
            }
            this.i_table[p1HashElement.i_hashCode & this.i_mask] = p1HashElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            return this.i_size;
        }
    }

    public Object storedTo(Transaction transaction) {
        if (this.getTrans() == null) {
            this.setTrans(transaction);
            this.modified();
        } else if (transaction != this.getTrans()) {
            throw new NotImplementedException();
        }
        return this;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    private class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Object object) {
            this.key = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MapEntry)) {
                return false;
            }
            MapEntry mapEntry = (MapEntry)object;
            return this.key.equals(mapEntry.key) && this.value.equals(mapEntry.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

