/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.Configuration;
import com.db4o.config.NativeSocketFactory;
import com.db4o.config.PlainSocketFactory;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.InvalidPasswordException;
import com.db4o.ext.MemoryFile;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.network.NetworkSocket;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.InMemoryObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerFactory;
import com.db4o.internal.Platform4;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.reflect.Reflector;

public class Db4o {
    static final Config4Impl i_config = new Config4Impl();

    public static void main(String[] stringArray) {
        System.out.println(Db4o.version());
    }

    public static Configuration configure() {
        return i_config;
    }

    public static Configuration newConfiguration() {
        Config4Impl config4Impl = new Config4Impl();
        Platform4.getDefaultConfiguration(config4Impl);
        return config4Impl;
    }

    public static Configuration cloneConfiguration() {
        return (Config4Impl)((DeepClone)((Object)Db4o.configure())).deepClone(null);
    }

    public static ObjectContainer openClient(String string, int n, String string2, String string3) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        return Db4o.openClient(Db4o.cloneConfiguration(), string, n, string2, string3);
    }

    public static ObjectContainer openClient(Configuration configuration, String string, int n, String string2, String string3) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        return Db4o.openClient(configuration, string, n, string2, string3, new PlainSocketFactory());
    }

    public static ObjectContainer openClient(Configuration configuration, String string, int n, String string2, String string3, NativeSocketFactory nativeSocketFactory) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        if (string2 == null || string3 == null) {
            throw new InvalidPasswordException();
        }
        NetworkSocket networkSocket = new NetworkSocket(nativeSocketFactory, string, n);
        return new ClientObjectContainer(configuration, networkSocket, string2, string3, true);
    }

    public static final ObjectContainer openFile(String string) throws Db4oIOException, DatabaseFileLockedException, IncompatibleFileFormatException, OldFormatException, DatabaseReadOnlyException {
        return Db4o.openFile(Db4o.cloneConfiguration(), string);
    }

    public static final ObjectContainer openFile(Configuration configuration, String string) throws Db4oIOException, DatabaseFileLockedException, IncompatibleFileFormatException, OldFormatException, DatabaseReadOnlyException {
        return ObjectContainerFactory.openObjectContainer(configuration, string);
    }

    protected static final ObjectContainer openMemoryFile1(Configuration configuration, MemoryFile memoryFile) throws Db4oIOException, DatabaseFileLockedException, OldFormatException {
        if (memoryFile == null) {
            memoryFile = new MemoryFile();
        }
        InMemoryObjectContainer inMemoryObjectContainer = new InMemoryObjectContainer(configuration, memoryFile);
        Messages.logMsg(i_config, 5, "Memory File");
        return inMemoryObjectContainer;
    }

    public static final ObjectServer openServer(String string, int n) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        return Db4o.openServer(Db4o.cloneConfiguration(), string, n);
    }

    public static final ObjectServer openServer(Configuration configuration, String string, int n) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        return Db4o.openServer(configuration, string, n, new PlainSocketFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ObjectServer openServer(Configuration configuration, String string, int n, NativeSocketFactory nativeSocketFactory) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)Db4o.openFile(configuration, string);
        if (localObjectContainer == null) {
            return null;
        }
        Object object = localObjectContainer.lock();
        synchronized (object) {
            return new ObjectServerImpl(localObjectContainer, n, nativeSocketFactory);
        }
    }

    static Reflector reflector() {
        return i_config.reflector();
    }

    public static final String version() {
        return "db4o 7.0.21.8693";
    }

    static {
        Platform4.getDefaultConfiguration(i_config);
    }
}

