/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.foundation.SignatureGenerator;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.Platform4;
import com.db4o.internal.handlers.DateHandlerBase;
import com.db4o.internal.slots.Slot;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DTrace {
    public static boolean enabled = false;
    public static boolean writeToLogFile = false;
    public static boolean writeToConsole = true;
    private static final String logFilePath = "C://";
    private static String logFileName;
    private static final Object lock;
    private static final LatinStringIO stringIO;
    public static RandomAccessFile _logFile;
    private boolean _enabled;
    private boolean _break;
    private boolean _log;
    private String _tag;
    private static long[] _rangeStart;
    private static long[] _rangeEnd;
    private static int _rangeCount;
    public static long _eventNr;
    private static long[] _breakEventNrs;
    private static int _breakEventCount;
    private static boolean _trackEventsWithoutRange;
    public static DTrace ADD_TO_CLASS_INDEX;
    public static DTrace BEGIN_TOP_LEVEL_CALL;
    public static DTrace BIND;
    public static DTrace BLOCKING_QUEUE_STOPPED_EXCEPTION;
    public static DTrace BTREE_NODE_COMMIT_OR_ROLLBACK;
    public static DTrace BTREE_NODE_REMOVE;
    public static DTrace CANDIDATE_READ;
    public static DTrace CLIENT_MESSAGE_LOOP_EXCEPTION;
    public static DTrace CLOSE;
    public static DTrace CLOSE_CALLED;
    public static DTrace COLLECT_CHILDREN;
    public static DTrace COMMIT;
    public static DTrace CONTINUESET;
    public static DTrace CREATE_CANDIDATE;
    public static DTrace DELETE;
    public static DTrace DONOTINCLUDE;
    public static DTrace END_TOP_LEVEL_CALL;
    public static DTrace EVALUATE_SELF;
    public static DTrace FATAL_EXCEPTION;
    public static DTrace FILE_FREE;
    public static DTrace FREE;
    public static DTrace FREE_RAM;
    public static DTrace FREE_ON_COMMIT;
    public static DTrace FREE_ON_ROLLBACK;
    public static DTrace FREE_POINTER_ON_ROLLBACK;
    public static DTrace GET_SLOT;
    public static DTrace GET_POINTER_SLOT;
    public static DTrace GET_FREESPACE;
    public static DTrace GET_FREESPACE_RAM;
    public static DTrace GET_YAPOBJECT;
    public static DTrace ID_TREE_ADD;
    public static DTrace ID_TREE_REMOVE;
    public static DTrace IO_COPY;
    public static DTrace JUST_SET;
    public static DTrace NEW_INSTANCE;
    public static DTrace PRODUCE_SLOT_CHANGE;
    public static DTrace QUERY_PROCESS;
    public static DTrace READ_ARRAY_WRAPPER;
    public static DTrace READ_BYTES;
    public static DTrace READ_ID;
    public static DTrace READ_SLOT;
    public static DTrace REFERENCE_REMOVED;
    public static DTrace REGULAR_SEEK;
    public static DTrace REMOVE_FROM_CLASS_INDEX;
    public static DTrace REREAD_OLD_UUID;
    public static DTrace SERVER_MESSAGE_LOOP_EXCEPTION;
    public static DTrace SLOT_SET_POINTER;
    public static DTrace SLOT_DELETE;
    public static DTrace SLOT_FREE_ON_COMMIT;
    public static DTrace SLOT_FREE_ON_ROLLBACK_ID;
    public static DTrace SLOT_FREE_ON_ROLLBACK_ADDRESS;
    public static DTrace TRANS_COMMIT;
    public static DTrace TRANS_DONT_DELETE;
    public static DTrace TRANS_DELETE;
    public static DTrace TRANS_FLUSH;
    public static DTrace YAPCLASS_BY_ID;
    public static DTrace YAPCLASS_INIT;
    public static DTrace YAPMETA_SET_ID;
    public static DTrace YAPMETA_WRITE;
    public static DTrace WRITE_BYTES;
    public static DTrace WRITE_POINTER;
    public static DTrace WRITE_XBYTES;
    public static DTrace WRITE_UPDATE_DELETE_MEMBERS;
    private static DTrace[] all;
    private static int current;

    private static void breakPoint() {
        if (enabled) {
            // empty if block
        }
    }

    private static final void configure() {
        if (enabled) {
            DTrace.trackEventsWithoutRange();
            DTrace.turnAllOffExceptFor(new DTrace[]{BLOCKING_QUEUE_STOPPED_EXCEPTION, CLIENT_MESSAGE_LOOP_EXCEPTION, CLOSE, CLOSE_CALLED, FATAL_EXCEPTION, SERVER_MESSAGE_LOOP_EXCEPTION});
        }
    }

    private static final void init() {
        if (enabled) {
            ADD_TO_CLASS_INDEX = new DTrace(true, true, "add to class index tree", true);
            BEGIN_TOP_LEVEL_CALL = new DTrace(true, true, "begin top level call", true);
            BIND = new DTrace(true, true, "bind", true);
            BLOCKING_QUEUE_STOPPED_EXCEPTION = new DTrace(true, true, "blocking queue stopped exception", true);
            BTREE_NODE_REMOVE = new DTrace(true, true, "btreenode remove", true);
            BTREE_NODE_COMMIT_OR_ROLLBACK = new DTrace(true, true, "btreenode commit or rollback", true);
            CANDIDATE_READ = new DTrace(true, true, "candidate read", true);
            CLIENT_MESSAGE_LOOP_EXCEPTION = new DTrace(true, true, "client message loop exception", true);
            CLOSE = new DTrace(true, true, "close", true);
            CLOSE_CALLED = new DTrace(true, true, "close called", true);
            COLLECT_CHILDREN = new DTrace(true, true, "collect children", true);
            COMMIT = new DTrace(false, false, "commit", true);
            CONTINUESET = new DTrace(true, true, "continueset", true);
            CREATE_CANDIDATE = new DTrace(true, true, "create candidate", true);
            DELETE = new DTrace(true, true, "delete", true);
            DONOTINCLUDE = new DTrace(true, true, "donotinclude", true);
            END_TOP_LEVEL_CALL = new DTrace(true, true, "end top level call", true);
            EVALUATE_SELF = new DTrace(true, true, "evaluate self", true);
            FATAL_EXCEPTION = new DTrace(true, true, "fatal exception", true);
            FREE = new DTrace(true, true, "free", true);
            FILE_FREE = new DTrace(true, true, "fileFree", true);
            FREE_RAM = new DTrace(true, true, "freeRAM", true);
            FREE_ON_COMMIT = new DTrace(true, true, "trans freeOnCommit", true);
            FREE_ON_ROLLBACK = new DTrace(true, true, "trans freeOnRollback", true);
            FREE_POINTER_ON_ROLLBACK = new DTrace(true, true, "freePointerOnRollback", true);
            GET_POINTER_SLOT = new DTrace(true, true, "getPointerSlot", true);
            GET_SLOT = new DTrace(true, true, "getSlot", true);
            GET_FREESPACE = new DTrace(true, true, "getFreespace", true);
            GET_FREESPACE_RAM = new DTrace(true, true, "getFreespaceRam", true);
            GET_YAPOBJECT = new DTrace(true, true, "get yapObject", true);
            ID_TREE_ADD = new DTrace(true, true, "id tree add", true);
            ID_TREE_REMOVE = new DTrace(true, true, "id tree remove", true);
            IO_COPY = new DTrace(true, true, "io copy", true);
            JUST_SET = new DTrace(true, true, "just set", true);
            NEW_INSTANCE = new DTrace(true, true, "newInstance", true);
            PRODUCE_SLOT_CHANGE = new DTrace(true, true, "produce slot change", true);
            QUERY_PROCESS = new DTrace(true, true, "query process", true);
            READ_ARRAY_WRAPPER = new DTrace(true, true, "read array wrapper", true);
            READ_BYTES = new DTrace(true, true, "readBytes", true);
            READ_ID = new DTrace(true, true, "read ID", true);
            READ_SLOT = new DTrace(true, true, "read slot", true);
            REFERENCE_REMOVED = new DTrace(true, true, "reference removed", true);
            REGULAR_SEEK = new DTrace(true, true, "regular seek", true);
            REMOVE_FROM_CLASS_INDEX = new DTrace(true, true, "trans removeFromClassIndexTree", true);
            REREAD_OLD_UUID = new DTrace(true, true, "reread old uuid", true);
            SERVER_MESSAGE_LOOP_EXCEPTION = new DTrace(true, true, "server message loop exception", true);
            SLOT_SET_POINTER = new DTrace(true, true, "slot set pointer", true);
            SLOT_DELETE = new DTrace(true, true, "slot delete", true);
            SLOT_FREE_ON_COMMIT = new DTrace(true, true, "slot free on commit", true);
            SLOT_FREE_ON_ROLLBACK_ID = new DTrace(true, true, "slot free on rollback id", true);
            SLOT_FREE_ON_ROLLBACK_ADDRESS = new DTrace(true, true, "slot free on rollback address", true);
            TRANS_COMMIT = new DTrace(false, false, "trans commit", false);
            TRANS_DELETE = new DTrace(true, true, "trans delete", true);
            TRANS_DONT_DELETE = new DTrace(true, true, "trans dontDelete", true);
            TRANS_FLUSH = new DTrace(true, true, "trans flush", true);
            YAPMETA_WRITE = new DTrace(true, true, "yapmeta write", true);
            YAPCLASS_BY_ID = new DTrace(true, true, "yapclass by id", true);
            YAPCLASS_INIT = new DTrace(true, true, "yapclass init", true);
            YAPMETA_SET_ID = new DTrace(true, true, "yapmeta setid", true);
            WRITE_BYTES = new DTrace(true, true, "writeBytes", true);
            WRITE_POINTER = new DTrace(true, true, "write pointer", true);
            WRITE_UPDATE_DELETE_MEMBERS = new DTrace(true, true, "trans writeUpdateDeleteMembers", true);
            WRITE_XBYTES = new DTrace(true, true, "writeXBytes", true);
            DTrace.configure();
        }
    }

    private static void trackEventsWithoutRange() {
        _trackEventsWithoutRange = true;
    }

    private DTrace(boolean bl, boolean bl2, String string, boolean bl3) {
        if (enabled) {
            this._enabled = bl;
            this._break = bl2;
            this._tag = string;
            this._log = bl3;
            if (all == null) {
                all = new DTrace[100];
            }
            DTrace.all[DTrace.current++] = this;
        }
    }

    public void log() {
        if (enabled) {
            this.log(-1L);
        }
    }

    public void logStack(String string) {
        if (enabled) {
            this.log(string);
            this.log(Platform4.stackTrace());
        }
    }

    public void log(String string) {
        if (enabled) {
            this.log(-1L, string);
        }
    }

    public void log(long l) {
        if (enabled) {
            this.logLength(l, 1L);
        }
    }

    public void logInfo(String string) {
        if (enabled) {
            this.logEnd(-1L, 0L, string);
        }
    }

    public void log(long l, String string) {
        if (enabled) {
            this.logEnd(l, 0L, string);
        }
    }

    public void logLength(long l, long l2) {
        if (enabled) {
            this.logEnd(l, l + l2 - 1L);
        }
    }

    public void logLength(Slot slot) {
        if (enabled) {
            this.logLength(slot.address(), slot.length());
        }
    }

    public void logEnd(long l, long l2) {
        if (enabled) {
            this.logEnd(l, l2, null);
        }
    }

    public void logEnd(long l, long l2, String string) {
        if (enabled) {
            int n;
            if (!this._enabled) {
                return;
            }
            boolean bl = false;
            if (_rangeCount == 0) {
                bl = true;
            }
            for (n = 0; n < _rangeCount; ++n) {
                if (l >= _rangeStart[n] && l <= _rangeEnd[n]) {
                    bl = true;
                    break;
                }
                if (l2 == 0L) continue;
                if (l2 >= _rangeStart[n] && l2 <= _rangeEnd[n]) {
                    bl = true;
                    break;
                }
                if (l > _rangeStart[n] || l2 < _rangeEnd[n]) continue;
                bl = true;
                break;
            }
            if (bl || _trackEventsWithoutRange && l == -1L) {
                if (this._log) {
                    StringBuffer stringBuffer = new StringBuffer(":");
                    stringBuffer.append(this.formatInt(++_eventNr, 6));
                    stringBuffer.append(":");
                    if (l != 0L) {
                        stringBuffer.append(this.formatInt(l));
                        stringBuffer.append(":");
                    }
                    if (l2 != 0L && l != l2) {
                        stringBuffer.append(this.formatInt(l2));
                        stringBuffer.append(":");
                        stringBuffer.append(this.formatInt(l2 - l + 1L));
                    } else {
                        stringBuffer.append(this.formatInt(0L));
                    }
                    stringBuffer.append(":");
                    if (string != null) {
                        stringBuffer.append(" " + string + " ");
                        stringBuffer.append(":");
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(this._tag);
                    DTrace.logToOutput(stringBuffer.toString());
                }
                if (this._break) {
                    if (_breakEventCount > 0) {
                        for (n = 0; n < _breakEventCount; ++n) {
                            if (_breakEventNrs[n] != _eventNr) continue;
                            DTrace.breakPoint();
                            break;
                        }
                    } else {
                        DTrace.breakPoint();
                    }
                }
            }
        }
    }

    private static void logToOutput(String string) {
        if (enabled) {
            DTrace.logToFile(string);
            DTrace.logToConsole(string);
        }
    }

    private static void logToConsole(String string) {
        if (enabled && writeToConsole) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logToFile(String string) {
        if (enabled) {
            if (!writeToLogFile) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                if (_logFile == null) {
                    try {
                        _logFile = new RandomAccessFile(DTrace.logFile(), "rw");
                        DTrace.logToFile("\r\n\r\n ********** BEGIN LOG ********** \r\n\r\n ");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                string = DateHandlerBase.now() + "\r\n" + string + "\r\n";
                byte[] byArray = stringIO.write(string);
                try {
                    _logFile.write(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static String logFile() {
        if (enabled) {
            if (logFileName != null) {
                return logFileName;
            }
            logFileName = "db4oDTrace_" + DateHandlerBase.now() + "_" + SignatureGenerator.generateSignature() + ".log";
            logFileName = logFileName.replace(' ', '_');
            logFileName = logFileName.replace(':', '_');
            logFileName = logFileName.replace('-', '_');
            return logFilePath + logFileName;
        }
        return null;
    }

    public static void addRange(long l) {
        if (enabled) {
            DTrace.addRangeWithEnd(l, l);
        }
    }

    public static void addRangeWithLength(long l, long l2) {
        if (enabled) {
            DTrace.addRangeWithEnd(l, l + l2 - 1L);
        }
    }

    public static void addRangeWithEnd(long l, long l2) {
        if (enabled) {
            if (_rangeStart == null) {
                _rangeStart = new long[100];
                _rangeEnd = new long[100];
            }
            DTrace._rangeStart[DTrace._rangeCount] = l;
            DTrace._rangeEnd[DTrace._rangeCount] = l2;
            ++_rangeCount;
        }
    }

    private static void breakOnEvent(long l) {
        if (enabled) {
            if (_breakEventNrs == null) {
                _breakEventNrs = new long[100];
            }
            DTrace._breakEventNrs[DTrace._breakEventCount] = l;
            ++_breakEventCount;
        }
    }

    private String formatInt(long l, int n) {
        if (enabled) {
            String string = "              ";
            if (l != 0L) {
                string = string + l + " ";
            }
            return string.substring(string.length() - n);
        }
        return null;
    }

    private String formatInt(long l) {
        if (enabled) {
            return this.formatInt(l, 10);
        }
        return null;
    }

    private static void turnAllOffExceptFor(DTrace[] dTraceArray) {
        if (enabled) {
            for (int i = 0; i < all.length && all[i] != null; ++i) {
                boolean bl = true;
                for (int j = 0; j < dTraceArray.length; ++j) {
                    if (all[i] != dTraceArray[j]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                DTrace.all[i]._break = false;
                DTrace.all[i]._enabled = false;
                DTrace.all[i]._log = false;
            }
        }
    }

    public static void noWarnings() {
        DTrace.breakOnEvent(0L);
        DTrace.trackEventsWithoutRange();
    }

    static {
        lock = new Object();
        stringIO = new LatinStringIO();
        DTrace.init();
    }
}

