/*
 * Decompiled with CFR 0.152.
 */
package demo.objectmanager.model;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.objectmanager.api.util.GenericObjectUtil;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericClass;
import com.db4o.reflect.generic.GenericField;
import demo.objectmanager.model.Address;
import demo.objectmanager.model.AllDataTypes;
import demo.objectmanager.model.Collections;
import demo.objectmanager.model.Contact;
import demo.objectmanager.model.EmailAddress;
import demo.objectmanager.model.Inheritance;
import demo.objectmanager.model.Note;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoPopulator {
    private static final String DB_FILE = "demo.db";
    private static final int NUMBER_TO_MAKE = 1000;
    private ObjectContainer db;
    private static int idGen;
    private String fileName = "demo.db";

    public static void main(String[] stringArray) {
        DemoPopulator demoPopulator = new DemoPopulator();
        demoPopulator.run();
    }

    public void run() {
        ObjectContainer objectContainer = this.getDb();
        int n = 0;
        ArrayList<Contact> arrayList = new ArrayList<Contact>();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < 1000; ++i) {
            Contact contact = new Contact();
            contact.setId(this.nextId());
            contact.setFirstName("Contact " + i);
            contact.setLastName("Lastname");
            contact.setAge(++n);
            if (n >= 100) {
                n = 0;
            }
            Date date = new Date();
            contact.setCreated(date);
            contact.setIncome((double)i * 1000.01);
            contact.setBirthDate(calendar.getTime());
            contact.setGender(i % 2 == 0 ? (char)'m' : 'f');
            calendar.add(6, -1);
            contact.setArbitraryObject(DemoPopulator.getArbitraryObject(i));
            this.addAddresses(contact);
            this.addEmails(contact);
            this.addFriends(contact, arrayList);
            contact.setNote(new Note("This note is about " + contact.getFirstName() + ". ???? ??????????? ??????????? ??? ??, ?????? ??????? ?? ???. ?? ??? ??????? ??????? ?????????. ??? ????? ???????? ????????? ??, ??? ???????? ?????????? ??. ??? ???????? ????????? ??. ??? ???????? ????????? ???????????? ??, ?? ???????? ????????? ??????????? ???.\n" + "\n" + "??? ?? ????? ????????, ?????? ??????? ????????? ?? ???. ???? ?????? ???????? ??? ??, ??? ?????? ???????? ??. ?? ??????? ??????????? ??????????? ???, ????? ????? ????????? ?? ???. ?? ???? ?????? ???, ?? ??? ???? ??????.\n" + "\n" + "????? ?????? ??????????? ??? ??, ?? ??? ???? ??????????, ?? ??? ???? ???????. ?? ??? ?????? ??????????. ??? ??????? ?????????? ?????????? ??, ?????? ??????? ???????? ?? ???, ????? ???????? ????????? ?? ???. ?? ??????? ????????? ????????? ???. ????? ???????? ?? ???, ??? ??????? ???????? ?????????? ??. ???????? ??????????? ?????????????? ?? ???, ??? ?? ??????? ??????? ?????????, ??? ???? ?????????? ??.\n" + "\n" + "??? ?? ???? ?????????? ???????????, ??? ?? ?????????? ????????????????, ???? ???? ?? ???. ?? ?????? ????????? ???. ????? ??????????? ?? ???, ?? ?????? ?????? ???, ?? ?????? ????????? ???. ???? ????? ?????? ??? ??. ??? ????????? ?????????? ?????????? ??.\n" + "\n" + "?? ??? ???? ??????????, ??? ?? ????? ????????? ??????????. ?? ??? ????????? ????????????, ????? ???????? ?? ???. ?? ?????? ??????? ??????????? ???. ??? ???? ?????? ???????????? ??, ??? ?? ????????? ??????????.\n" + "\n" + "???? ????? ?? ???, ??? ????? ?????????? ??????????? ??. ?? ??? ???????? ????????? ??????????, ??? ???? ????? ?????????? ??. ??????? ?????????? ??????????? ?? ???, ?? ??????? ???????? ???, ?? ????????? ????????? ??????????????? ???. ????? ?????? ????????? ?? ???, ?? ???? ???? ???, ????? ????????? ??????????? ??? ??. ??? ?? ????? ???????.\n" + "\n" + "?? ??????? ???????? ?????????????? ???. ???? ?????? ???????? ?? ???, ??? ?? ??????? ?????????. ?????? ??????????????? ??? ??, ?? ??? ??????? ??????? ????????, ?? ????? ????????? ???????????? ???. ?? ???? ?????????? ???. ?? ??? ???? ??????? ??????????, ?? ?????? ???????? ?????????? ???, ??? ?? ????? ???????????.\n" + "\n" + "??????? ???????? ?? ???, ?? ??? ????? ??????? ????????. ?? ???????? ????????? ???, ??? ??????? ??????? ???????????? ??, ?? ??? ???? ???? ?????. ?? ?????? ??????? ???, ??? ?? ???? ??????? ?????????. ???? ????????? ?? ???, ?? ??? ????? ?????? ????????, ??????? ?????????? ??? ??.\n" + "\n" + "??? ?????????? ??????????? ??????????? ??. ??? ?????? ???????? ??, ?????? ???????? ?? ???. ??? ???????? ?????????? ??????????? ??, ??? ?? ??????? ????????, ?? ??? ???? ????????? ?????????. ?? ?????? ???????? ????????? ???. ????? ????? ??????? ?? ???, ?? ?????? ????????? ????????? ???, ?? ?????? ?????????? ???????????? ???.\n" + "\n" + "??? ????? ?????????? ??. ??? ????? ??????????? ??, ?? ??? ??????????? ???????????, ??? ?????? ??????? ?????????? ??. ???? ????? ?????? ?? ???. ??? ????? ?????????? ??. ?? ??? ???????? ????????? ??????????????.\n" + "      ", false));
            objectContainer.set((Object)contact);
            arrayList.add(0, contact);
            if (arrayList.size() > 10) {
                arrayList.remove(10);
            }
            if (i % 1000 != 0) continue;
            objectContainer.commit();
        }
        objectContainer.set(Collections.forDemo());
        Inheritance.forDemo(objectContainer);
        this.fillAllDataTypes(objectContainer);
        this.createGenericObjects(objectContainer);
        objectContainer.commit();
        objectContainer.close();
    }

    private void fillAllDataTypes(ObjectContainer objectContainer) {
        for (int i = 0; i < 1000; ++i) {
            AllDataTypes allDataTypes = new AllDataTypes();
            allDataTypes.setABoolean(i % 2 == 0);
            allDataTypes.setWBoolean(new Boolean(allDataTypes.isABoolean()));
            allDataTypes.setAByte((byte)1);
            allDataTypes.setWByte(new Byte(allDataTypes.getAByte()));
            allDataTypes.setAChar('z');
            allDataTypes.setWChar(new Character(allDataTypes.getAChar()));
            allDataTypes.setAShort((short)8);
            allDataTypes.setWShort(new Short(allDataTypes.getAShort()));
            allDataTypes.setAInt(123);
            allDataTypes.setWInt(new Integer(allDataTypes.getAInt()));
            allDataTypes.setALong(4567L);
            allDataTypes.setWLong(new Long(allDataTypes.getALong()));
            allDataTypes.setAFloat(12.34f);
            allDataTypes.setWFloat(new Float(allDataTypes.getAFloat()));
            allDataTypes.setADouble(56.78);
            allDataTypes.setWDouble(new Double(allDataTypes.getADouble()));
            allDataTypes.setDate(new Date());
            objectContainer.set((Object)allDataTypes);
        }
    }

    public static Object getArbitraryObject(int n) {
        int n2 = n % 7;
        switch (n2) {
            case 0: {
                return new Boolean(true);
            }
            case 1: {
                return new Integer(123);
            }
            case 2: {
                return new BigDecimal("123.456");
            }
            case 3: {
                return new Double(123.456);
            }
            case 4: {
                return new Date();
            }
            case 5: {
                return new String("arbitrary string");
            }
            case 7: {
                return new Object();
            }
        }
        return null;
    }

    private Integer nextId() {
        return new Integer(++idGen);
    }

    private void addFriends(Contact contact, List<Contact> list) {
        contact.setFriends(list);
    }

    private synchronized ObjectContainer getDb() {
        if (this.db == null) {
            File file = new File(DB_FILE);
            if (file.exists()) {
                file.delete();
            }
            this.db = Db4o.openFile((String)DB_FILE);
        }
        return this.db;
    }

    private void addEmails(Contact contact) {
        for (int i = 0; i < 10; ++i) {
            contact.addEmail(new EmailAddress("name@somewhere" + i + ".com"));
        }
    }

    private void addAddresses(Contact contact) {
        for (int i = 0; i < 5; ++i) {
            contact.addAddress(new Address(this.nextId(), contact, i + " street", "San Francisco", "CA", "90210", i == 0, new Boolean(i == 2)));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    private void createGenericObjects(ObjectContainer objectContainer) {
        GenericClass genericClass = this.makeGenericCarClass();
        ReflectField reflectField = genericClass.getDeclaredField("name");
        ReflectField reflectField2 = genericClass.getDeclaredField("buildDate");
        ReflectField reflectField3 = genericClass.getDeclaredField("mpg");
        for (int i = 0; i < 100; ++i) {
            Object object = genericClass.newInstance();
            reflectField.set(object, (Object)"Jaguar");
            reflectField2.set(object, (Object)new Date());
            reflectField3.set(object, (Object)i);
            objectContainer.set(object);
        }
        objectContainer.commit();
    }

    private GenericClass makeGenericCarClass() {
        GenericClass genericClass = GenericObjectUtil.makeGenericClass("com.acme.Car");
        genericClass.initFields(this.fields(genericClass.reflector()));
        return genericClass;
    }

    private GenericField[] fields(Reflector reflector) {
        return new GenericField[]{new GenericField("name", reflector.forClass(String.class), false), new GenericField("buildDate", reflector.forClass(Date.class), false), new GenericField("mpg", reflector.forClass(Integer.class), true)};
    }
}

