/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.query;

import com.db4o.objectmanager.model.query.FieldComparator;
import com.db4o.objectmanager.model.query.FieldConstraint;
import com.db4o.objectmanager.model.query.QueryBuilderModel;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import java.util.Map;
import java.util.TreeMap;

public class QueryPrototypeInstance {
    private final ReflectClass clazz;
    private QueryBuilderModel model;
    private Map fields = new TreeMap(new FieldComparator());

    public QueryPrototypeInstance(ReflectClass reflectClass, QueryBuilderModel queryBuilderModel) {
        this.clazz = reflectClass;
        this.model = queryBuilderModel;
        this.populateFields();
    }

    private void populateFields() {
        for (ReflectClass reflectClass = this.clazz; reflectClass != null; reflectClass = reflectClass.getSuperclass()) {
            ReflectField[] reflectFieldArray = reflectClass.getDeclaredFields();
            for (int i = 0; i < reflectFieldArray.length; ++i) {
                ReflectClass reflectClass2 = reflectFieldArray[i].getFieldType();
                if (reflectFieldArray[i].isTransient() || reflectClass2.isCollection() || reflectClass2.isArray()) continue;
                this.fields.put(reflectFieldArray[i], new FieldConstraint(reflectFieldArray[i], this.model));
            }
        }
    }

    public void addUserConstraints(Query query) {
        if (query == null || this.clazz == null) {
            return;
        }
        query.constrain((Object)this.clazz);
        for (FieldConstraint fieldConstraint : this.fields.values()) {
            if (fieldConstraint.value == null) continue;
            fieldConstraint.apply(query);
        }
    }

    public ReflectField[] getFields() {
        return this.fields.keySet().toArray(new ReflectField[this.fields.size()]);
    }

    public FieldConstraint getConstraint(ReflectField reflectField) {
        return (FieldConstraint)this.fields.get(reflectField);
    }

    public ReflectClass getType() {
        return this.clazz;
    }
}

