/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.nodes.partition;

import java.util.LinkedList;

public class PartitionSpec {
    private int _numItems;
    private int _threshold;
    private int[][] _treeLayout;

    public PartitionSpec(int n, int n2) {
        this._numItems = n;
        this._threshold = n2;
        this._treeLayout = this.computeTreePartition(n, n2);
    }

    public int getBeginPartition(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += this._treeLayout[n][i];
        }
        return n3;
    }

    public int getEndPartition(int n, int n2) {
        return this.getBeginPartition(n, n2) + this._treeLayout[n][n2];
    }

    public int getNumChildren(int n, int n2) {
        int n3 = this._treeLayout[n][n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n3) {
            n4 += this._treeLayout[n + 1][n6];
            ++n6;
            ++n5;
        }
        return n5;
    }

    public int getStartingChildPosition(int n, int n2) {
        int n3 = this.getBeginPartition(n, n2);
        int n4 = 0;
        int n5 = n + 1;
        int n6 = 0;
        while (n4 < n3) {
            n4 += this._treeLayout[n5][n6];
            ++n6;
        }
        return n6;
    }

    public boolean hasPartitionChildren(int n) {
        return n < this._treeLayout.length;
    }

    public int getNumRootNodes() {
        return this._treeLayout[0].length;
    }

    private int[][] computeTreePartition(int n, int n2) {
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        int n3 = n;
        int[] nArray = null;
        while (n3 > n2) {
            int n4 = (int)Math.round((double)((float)n3 / (float)n2) + 0.5);
            int n5 = n3 / n4;
            int n6 = n3 % n4;
            int[] nArray2 = new int[n4];
            int n7 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                int n8 = n5;
                if (i < n6) {
                    ++n8;
                }
                if (nArray == null) {
                    nArray2[i] = n8;
                    continue;
                }
                for (int j = n7; j < n7 + n8; ++j) {
                    int n9 = i;
                    nArray2[n9] = nArray2[n9] + nArray[j];
                }
                n7 += n8;
            }
            linkedList.addFirst(nArray2);
            nArray = nArray2;
            n3 = n4;
        }
        return (int[][])linkedList.toArray((T[])new int[linkedList.size()][]);
    }

    public static void main(String[] stringArray) {
        PartitionSpec partitionSpec = new PartitionSpec(29, 3);
    }
}

