/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.nodes.field;

import com.db4o.objectmanager.model.IDatabase;
import com.db4o.objectmanager.model.nodes.IModelNode;
import com.db4o.objectmanager.model.nodes.field.ArrayFieldNode;
import com.db4o.objectmanager.model.nodes.field.CollectionFieldNode;
import com.db4o.objectmanager.model.nodes.field.FieldNode;
import com.db4o.objectmanager.model.nodes.field.MapFieldNode;
import com.db4o.objectmanager.model.nodes.field.PrimitiveFieldNode;
import com.db4o.reflect.ReflectClass;
import java.util.Date;

public class FieldNodeFactory {
    private static Class[] boxedPrimitiveTypes = new Class[]{Integer.class, Float.class, Double.class, Long.class, Boolean.class, Character.class, String.class, Date.class};

    private static boolean typeIn(Class clazz, Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static IModelNode construct(String string, ReflectClass reflectClass, Object object, IDatabase iDatabase) {
        ReflectClass reflectClass2 = iDatabase.reflector().forObject(object);
        if (object == null) {
            return new FieldNode(string, reflectClass, object, iDatabase);
        }
        if (reflectClass2.isSecondClass()) {
            return new PrimitiveFieldNode(string, reflectClass, object, iDatabase);
        }
        if (reflectClass2.isArray()) {
            return new ArrayFieldNode(string, reflectClass, object, iDatabase);
        }
        IModelNode iModelNode = MapFieldNode.tryToCreate(string, object, iDatabase);
        if (iModelNode != null) {
            return iModelNode;
        }
        if (reflectClass2.isCollection()) {
            return new CollectionFieldNode(string, reflectClass, object, iDatabase);
        }
        return new FieldNode(string, reflectClass, object, iDatabase);
    }
}

