/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.nodes.field;

import com.db4o.objectmanager.model.IDatabase;
import com.db4o.objectmanager.model.nodes.IModelNode;
import com.db4o.objectmanager.model.nodes.NullNode;
import com.db4o.objectmanager.model.nodes.field.InstanceNode;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.jdk.JdkReflector;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldNode
implements IModelNode {
    protected String _fieldName;
    protected Object value;
    protected IDatabase _database;
    protected IModelNode delegate = null;
    protected ReflectClass _fieldType;
    private boolean showType;

    public FieldNode(String string, ReflectClass reflectClass, Object object, IDatabase iDatabase) {
        this._fieldName = string;
        this.value = object;
        this._database = iDatabase;
        this._fieldType = reflectClass;
        if (this.value == null) {
            this.delegate = new NullNode(iDatabase);
            return;
        }
        ReflectClass reflectClass2 = iDatabase.reflector().forObject(this.value);
        this.delegate = new InstanceNode(this.value, iDatabase);
    }

    public IDatabase getDatabase() {
        return this._database;
    }

    public boolean hasChildren() {
        return this.delegate.hasChildren();
    }

    public IModelNode[] children() {
        return this.delegate.children();
    }

    public String getText() {
        String string = "";
        if (this.showType) {
            string = "(" + this._fieldType.getName() + ") ";
        }
        return string + (this._fieldName.equals("") ? this.delegate.getText() : this._fieldName + ": " + this.delegate.getText());
    }

    public String getName() {
        String string = "";
        if (this.showType) {
            string = "(" + this._fieldType.getName() + ") ";
        }
        return string + this._fieldName;
    }

    public String getValueString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FieldNode fieldNode = (FieldNode)object;
        return this.value.equals(fieldNode.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static Object field(ReflectField reflectField, Object object) {
        try {
            reflectField.setAccessible();
            return reflectField.get(object);
        }
        catch (Exception exception) {
            Logger.getLogger(FieldNode.class.getName()).log(Level.WARNING, "Unable to get the field contents", exception);
            throw new IllegalStateException();
        }
    }

    public void setShowType(boolean bl) {
        this.showType = bl;
    }

    public boolean isEditable() {
        if (this.value == null) {
            return false;
        }
        return this.canConvert(this.value, this._fieldType);
    }

    private boolean canConvert(Object object, ReflectClass reflectClass) {
        Class clazz = JdkReflector.toNative((ReflectClass)reflectClass);
        if (clazz == null) {
            return false;
        }
        return clazz.isPrimitive() || String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    public Object getEditValue() {
        return this.value;
    }

    public long getId() {
        return this.delegate.getId();
    }

    protected String getNodeName() {
        if (this._fieldName == null || this._fieldName.equals("")) {
            return this.value.getClass().getName();
        }
        return this._fieldName;
    }

    public void printXmlReferenceNode(PrintStream printStream) {
        if (this.delegate instanceof NullNode) {
            printStream.print("<" + this.getNodeName() + " reference=\"-1\"/>\n");
        } else {
            printStream.print("<" + this.getNodeName() + " reference=\"" + this.getId() + "\"/>\n");
        }
    }

    public void printXmlStart(PrintStream printStream) {
        printStream.println("<" + this.getNodeName() + " id=\"" + this.getId() + (this._fieldName == null || this._fieldName.equals("") ? "" : "\" className=\"" + this.value.getClass().getName()) + "\">");
    }

    public void printXmlEnd(PrintStream printStream) {
        printStream.println("</" + this.getNodeName() + ">");
    }

    public void printXmlValueNode(PrintStream printStream) {
        printStream.print("<" + this.getNodeName() + ">");
        this.delegate.printXmlValueNode(printStream);
        printStream.print("</" + this.getNodeName() + ">");
    }

    public boolean shouldIndent() {
        return true;
    }
}

