/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model;

import com.db4o.objectmanager.model.GraphPathNode;
import com.db4o.objectmanager.model.nodes.IModelNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class GraphPosition {
    private LinkedList path = new LinkedList();

    public GraphPosition() {
    }

    public GraphPosition(GraphPosition graphPosition) {
        for (GraphPathNode graphPathNode : graphPosition.path) {
            this.path.add(new GraphPathNode(graphPathNode.children, graphPathNode.selectedChild));
        }
    }

    public ListIterator iterator() {
        return this.path.listIterator();
    }

    public int size() {
        return this.path.size();
    }

    public boolean hasParent() {
        return !this.path.isEmpty();
    }

    public void push(IModelNode[] iModelNodeArray, int n) {
        this.path.addLast(new GraphPathNode(iModelNodeArray, n));
    }

    public GraphPathNode pop() {
        if (this.path.isEmpty()) {
            throw new IllegalArgumentException("Nothing left to pop from the stack");
        }
        return (GraphPathNode)this.path.removeLast();
    }

    public IModelNode getCurrent() {
        GraphPathNode graphPathNode = (GraphPathNode)this.path.getLast();
        if (graphPathNode.children.length > 0) {
            return graphPathNode.children[graphPathNode.selectedChild + 1];
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GraphPosition)) {
            return false;
        }
        GraphPosition graphPosition = (GraphPosition)object;
        if (graphPosition.path.size() != this.path.size()) {
            return false;
        }
        Iterator iterator = graphPosition.path.iterator();
        Iterator iterator2 = this.path.iterator();
        while (iterator2.hasNext()) {
            GraphPathNode graphPathNode = (GraphPathNode)iterator.next();
            GraphPathNode graphPathNode2 = (GraphPathNode)iterator2.next();
            if (graphPathNode.selectedChild == graphPathNode2.selectedChild) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (GraphPathNode graphPathNode : this.path) {
            n += graphPathNode.children.length + graphPathNode.selectedChild + 1;
        }
        return n;
    }

    public String toString() {
        return "Object Manager";
    }
}

