/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.config.DotnetSupport;
import com.db4o.instrumentation.classfilter.AcceptAllClassesFilter;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.main.BloatInstrumentingClassLoader;
import com.db4o.objectmanager.configuration.ConfigurationFacade;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.jdk.JdkReflector;
import com.db4o.ta.TransparentActivationSupport;
import com.db4o.ta.instrumentation.InjectTransparentActivationEdit;
import java.net.URL;
import java.util.logging.Logger;

public abstract class Db4oConnectionSpec {
    private static Logger logger = Logger.getLogger(Db4oConnectionSpec.class.getName());
    private static boolean PREFERENCE_IS_READ_ONLY = false;
    private ConfigurationFacade configuration;
    private boolean readOnly;

    public static boolean preferenceIsReadOnly() {
        return PREFERENCE_IS_READ_ONLY;
    }

    public abstract String toString();

    protected Db4oConnectionSpec(boolean bl) {
        this.readOnly = bl;
    }

    public abstract String getFullPath();

    public abstract String getPath();

    public abstract boolean isRemote();

    public Configuration newConfiguration() {
        Configuration configuration = Db4o.newConfiguration();
        this.configureTA(configuration);
        configuration.updateDepth(10);
        configuration.add((ConfigurationItem)new DotnetSupport());
        this.applyConfiguratio(configuration);
        return configuration;
    }

    private void applyConfiguratio(Configuration configuration) {
        if (this.configuration != null) {
            configuration.unicode(this.configuration.unicode());
            configuration.io(this.configuration.encryptionProvider());
            configuration.lockDatabaseFile(this.configuration.lockDatabaseFile());
            configuration.callConstructors(this.configuration.callConstructors());
        }
    }

    public void setConfiguration(ConfigurationFacade configurationFacade) {
        this.configuration = configurationFacade;
    }

    private void configureTA(Configuration configuration) {
        configuration.activationDepth(0);
        configuration.add((ConfigurationItem)new TransparentActivationSupport());
        BloatInstrumentingClassLoader bloatInstrumentingClassLoader = new BloatInstrumentingClassLoader(new URL[0], this.getClass().getClassLoader(), (BloatClassEdit)new InjectTransparentActivationEdit((ClassFilter)new AcceptAllClassesFilter()));
        configuration.reflectWith((Reflector)new JdkReflector((ClassLoader)bloatInstrumentingClassLoader));
    }
}

