/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.api.prefs;

import com.db4o.Db4o;
import com.db4o.objectmanager.api.prefs.Preferences;

public class ActivationPreferences {
    public static final String ACTIVATION_PREFERENCES_ID = "Activation";
    public static final int DEFAULT_INITIAL_ACTIVATION_DEPTH = 5;
    public static final int DEFAULT_SUBSEQUENT_ACTIVATION_DEPTH = 2;
    private int initialActivationDepth = 5;
    private int subsequentActivationDepth = 2;

    public static ActivationPreferences getDefault() {
        ActivationPreferences activationPreferences = (ActivationPreferences)Preferences.getDefault().getPreference(ACTIVATION_PREFERENCES_ID);
        if (activationPreferences == null) {
            activationPreferences = new ActivationPreferences();
        }
        return activationPreferences;
    }

    public int getInitialActivationDepth() {
        return this.initialActivationDepth;
    }

    public void setInitialActivationDepth(int n) {
        this.initialActivationDepth = n;
        Db4o.configure().activationDepth(n);
    }

    public int getSubsequentActivationDepth() {
        return this.subsequentActivationDepth;
    }

    public void setSubsequentActivationDepth(int n) {
        this.subsequentActivationDepth = n;
    }

    public void resetDefaultValues() {
        this.setInitialActivationDepth(5);
        this.setSubsequentActivationDepth(2);
    }
}

