/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.api.helpers;

import com.db4o.ObjectContainer;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericReflector;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ReflectHelper2 {
    public static List getUserStoredClasses(ObjectContainer objectContainer) {
        String[] stringArray = new String[]{"java.lang.", "java.util.", "java.math.", "System.", "j4o.lang.AssemblyNameHint", "com.db4o."};
        StoredClass[] storedClassArray = objectContainer.ext().storedClasses();
        GenericReflector genericReflector = objectContainer.ext().reflector();
        ArrayList<ReflectClass> arrayList = new ArrayList<ReflectClass>();
        for (int i = 0; i < storedClassArray.length; ++i) {
            StoredClass storedClass = storedClassArray[i];
            ReflectClass reflectClass = genericReflector.forName(storedClass.getName());
            if (reflectClass.isArray() || reflectClass.isPrimitive()) continue;
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!reflectClass.getName().startsWith(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(reflectClass);
        }
        Collections.sort(arrayList, new Comparator(){
            private Collator comparator = Collator.getInstance();

            public int compare(Object object, Object object2) {
                ReflectClass reflectClass = (ReflectClass)object;
                ReflectClass reflectClass2 = (ReflectClass)object2;
                return this.comparator.compare(reflectClass.getName(), reflectClass2.getName());
            }
        });
        return arrayList;
    }

    public static boolean isEditable(Class clazz) {
        return clazz.isPrimitive() || String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }

    public static boolean isPrimitiveArray(Object object) {
        if (!object.getClass().isArray()) {
            return false;
        }
        Class<?> clazz = object.getClass().getComponentType();
        return clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE;
    }

    public static boolean isIndexable(StoredField storedField) {
        ReflectClass reflectClass = storedField.getStoredType();
        return reflectClass != null && (reflectClass.isPrimitive() || reflectClass.isSecondClass());
    }

    public static Class reflectClassToClass(ReflectClass reflectClass) {
        String string = reflectClass.getName();
        if (reflectClass.isPrimitive()) {
            if (string.equals(Integer.TYPE.getName())) {
                return Integer.class;
            }
            if (string.equals(Long.TYPE.getName())) {
                return Long.class;
            }
            if (string.equals(Float.TYPE.getName())) {
                return Float.class;
            }
            if (string.equals(Double.TYPE.getName())) {
                return Double.class;
            }
            if (string.equals(Short.TYPE.getName())) {
                return Short.class;
            }
            if (string.equals(Byte.TYPE.getName())) {
                return Byte.class;
            }
            if (string.equals(Boolean.TYPE.getName())) {
                return Boolean.class;
            }
            if (string.equals(Character.TYPE.getName())) {
                return Character.class;
            }
        } else {
            try {
                Class<?> clazz = Class.forName(reflectClass.getName());
                if (clazz.isInterface()) {
                    return null;
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return null;
    }
}

