/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.tree;

import com.db4o.objectManager.v2.MainPanel;
import com.db4o.reflect.ReflectField;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ObjectTreeNode {
    private ObjectTreeNode parentNode;
    private ReflectField field;
    private int index = -1;
    private Object ob;

    public ObjectTreeNode(ObjectTreeNode parentNode, ReflectField field, Object ob) {
        this.parentNode = parentNode;
        this.field = field;
        this.ob = ob;
    }

    public ObjectTreeNode(ObjectTreeNode parentNode, int index, Object ob) {
        this.parentNode = parentNode;
        this.index = index;
        this.ob = ob;
    }

    public Object getObject() {
        return this.ob;
    }

    public String toString() {
        String ret = "";
        try {
            ret = this.field != null ? this.field.getName() + ": " : "";
            if (this.ob == null) {
                ret = ret + this.ob;
            } else if (this.ob instanceof Date) {
                ret = ret + MainPanel.dateFormatter.display((Date)this.ob);
            } else if (this.ob.getClass().isArray()) {
                ret = ret + "Array[" + Array.getLength(this.ob) + "]";
            } else if (this.ob instanceof Collection) {
                Collection collection = (Collection)this.ob;
                ret = ret + "Collection[" + collection.size() + "]";
            } else if (this.ob instanceof Map) {
                Map map = (Map)this.ob;
                ret = ret + "Map[" + map.size() + "]";
            } else {
                ret = ret + this.ob;
            }
        }
        catch (Exception e) {
            ret = this.ob.toString();
        }
        return ret;
    }

    public void setObject(Object object) {
        this.ob = object;
    }

    public ObjectTreeNode getParentNode() {
        return this.parentNode;
    }

    public ReflectField getField() {
        return this.field;
    }

    public int getIndex() {
        return this.index;
    }
}

