/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.tree;

import com.db4o.objectManager.v2.UISession;
import com.db4o.objectManager.v2.tree.MapEntry;
import com.db4o.objectManager.v2.tree.ObjectTreeNode;
import com.db4o.objectManager.v2.util.Converter;
import com.db4o.objectManager.v2.util.Log;
import com.db4o.objectmanager.api.helpers.ReflectHelper2;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericObject;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.ta.Activatable;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ObjectTreeModel
implements TreeModel {
    private ObjectTreeNode root;
    private UISession session;
    protected EventListenerList listenerList = new EventListenerList();

    public ObjectTreeModel(ObjectTreeNode top, UISession session) {
        this.root = top;
        this.session = session;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        ObjectTreeNode parentNode = (ObjectTreeNode)parent;
        Object parentObject = parentNode.getObject();
        GenericReflector reflector = this.session.getObjectContainer().ext().reflector();
        ReflectClass reflectClass = reflector.forObject(parentObject);
        if (Activatable.class.isAssignableFrom(parentObject.getClass())) {
            ((Activatable)parentObject).activate();
        }
        if (reflectClass.isArray()) {
            return this.makeArrayNode(parentObject, parentNode, index, (Reflector)reflector);
        }
        if (reflector.isCollection(reflectClass)) {
            if (parentObject instanceof Map) {
                return this.makeMapNode(parentObject, parentNode, index);
            }
            return this.makeCollectionNode(parentObject, parentNode, index);
        }
        if (parentObject instanceof MapEntry) {
            MapEntry entry = (MapEntry)parentObject;
            if (index == 0) {
                return new ObjectTreeNode(parentNode, index, entry.getEntry().getKey());
            }
            return new ObjectTreeNode(parentNode, index, entry.getEntry().getValue());
        }
        ReflectField[] fields = ReflectHelper.getDeclaredFieldsInHeirarchy(reflectClass);
        fields[index].setAccessible();
        Object value = fields[index].get(parentObject);
        return new ObjectTreeNode(parentNode, fields[index], value);
    }

    private Object makeArrayNode(Object parentObject, ObjectTreeNode parentNode, int index, Reflector reflector) {
        return new ObjectTreeNode(parentNode, index, reflector.array().get(parentObject, index));
    }

    private Object makeCollectionNode(Object parentObject, ObjectTreeNode parentNode, int index) {
        Collection collection = (Collection)parentObject;
        int i = 0;
        Object toUse = null;
        for (Object o : collection) {
            if (i == index) {
                toUse = o;
                break;
            }
            ++i;
        }
        return new ObjectTreeNode(parentNode, index, toUse);
    }

    private Object makeMapNode(Object parentObject, ObjectTreeNode parentNode, int index) {
        Map map = (Map)parentObject;
        Object[] arr = map.entrySet().toArray();
        return new ObjectTreeNode(parentNode, index, (Object)new MapEntry((Map.Entry)arr[index]));
    }

    public int getChildCount(Object parent) {
        ObjectTreeNode parentNode = (ObjectTreeNode)parent;
        GenericReflector reflector = this.session.getObjectContainer().ext().reflector();
        ReflectClass reflectClass = reflector.forObject(parentNode.getObject());
        if (reflectClass.isArray()) {
            return Array.getLength(parentNode.getObject());
        }
        if (parentNode.getObject() instanceof Collection) {
            Collection collection = (Collection)parentNode.getObject();
            return collection.size();
        }
        if (parentNode.getObject() instanceof Map) {
            Map map = (Map)parentNode.getObject();
            return map.size();
        }
        if (parentNode.getObject() instanceof MapEntry) {
            return 2;
        }
        ReflectField[] fields = ReflectHelper.getDeclaredFieldsInHeirarchy(reflectClass);
        return fields.length;
    }

    public boolean isLeaf(Object node) {
        GenericReflector reflector = this.session.getObjectContainer().ext().reflector();
        if (node == null || ((ObjectTreeNode)node).getObject() == null) {
            return true;
        }
        Object nodeObject = ((ObjectTreeNode)node).getObject();
        if (nodeObject instanceof GenericObject) {
            GenericObject go = (GenericObject)nodeObject;
            ReflectClass gclass = reflector.forObject(nodeObject);
            if (gclass.getName().contains("System.DateTime")) {
                return true;
            }
        }
        return ReflectHelper2.isEditable(nodeObject.getClass());
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        ObjectTreeNode aNode = (ObjectTreeNode)path.getLastPathComponent();
        try {
            Object oldOb = aNode.getObject();
            Class<?> c = aNode.getObject().getClass();
            Object newOb = this.convertToObject(c, (String)newValue);
            ObjectTreeNode parentNode = aNode.getParentNode();
            int index = aNode.getIndex();
            Object parentObject = parentNode.getObject();
            ObjectTreeNode superParentNode = parentNode.getParentNode();
            GenericReflector reflector = this.session.getObjectContainer().ext().reflector();
            ReflectClass reflectClass = reflector.forObject(parentObject);
            boolean storeSuper = false;
            if (reflectClass.isArray()) {
                Array.set(parentObject, index, newOb);
                storeSuper = true;
            } else if (reflector.isCollection(reflectClass)) {
                if (parentObject instanceof Map) {
                    Map map = (Map)parentObject;
                    MapEntry mapEntry = (MapEntry)aNode.getObject();
                    map.put(mapEntry.getEntry().getKey(), newOb);
                } else if (parentObject instanceof List) {
                    List collection = (List)parentObject;
                    collection.set(index, newOb);
                } else if (parentObject instanceof Set) {
                    Set collection = (Set)parentObject;
                    collection.add(newOb);
                } else if (parentObject instanceof Queue) {
                    Queue q = (Queue)parentObject;
                    System.out.println("removed from queue? " + q.remove(oldOb));
                    q.add(newOb);
                }
                storeSuper = true;
            } else if (parentObject instanceof MapEntry) {
                MapEntry entry = (MapEntry)parentObject;
                if (index == 0) {
                    Map superMap = (Map)superParentNode.getObject();
                    superMap.remove(entry.getEntry().getKey());
                    superMap.put(newOb, entry.getEntry().getValue());
                } else {
                    Map superMap = (Map)superParentNode.getObject();
                    superMap.remove(entry.getEntry().getKey());
                    superMap.put(entry.getEntry().getKey(), newOb);
                }
                superParentNode = superParentNode.getParentNode();
                storeSuper = true;
            } else {
                ReflectField rf = aNode.getField();
                rf.setAccessible();
                rf.set(parentObject, newOb);
            }
            if (storeSuper) {
                this.addToBatch(superParentNode.getObject());
            } else {
                this.addToBatch(parentObject);
            }
            aNode.setObject(newOb);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.addException(e);
        }
    }

    private Object convertToObject(Class c, String newValue) throws Exception {
        return Converter.convertFromString(c, newValue);
    }

    private void addToBatch(Object o) {
        this.session.getObjectContainer().set(o);
        this.session.getObjectContainer().commit();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public boolean isPathEditable(TreePath path) {
        ObjectTreeNode aNode = (ObjectTreeNode)path.getLastPathComponent();
        if (aNode.getObject() == null) {
            return false;
        }
        Class<?> c = aNode.getObject().getClass();
        return ReflectHelper2.isEditable(c);
    }
}

