/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.query;

import com.db4o.ObjectContainer;
import com.db4o.objectManager.v2.query.QueryResultsPanel;
import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectManager.v2.results.CollectionValue;
import com.db4o.objectManager.v2.results.MapValue;
import com.db4o.objectManager.v2.util.Log;
import com.db4o.objectmanager.api.helpers.ReflectHelper2;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.ta.Activatable;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Result;
import com.spaceprogram.db4o.sql.Sql4o;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class QueryResultsTableModel
extends AbstractTableModel
implements TableModel {
    private ObjectSetWrapper results;
    private String query;
    private QueryResultsPanel queryResultsPanel;
    private static final int NUM_IN_TOP = 100;
    private static final int NUM_IN_WINDOW = 100;
    public static final int COL_TREE = 0;
    private static final int COL_ROW_NUMBER = 1;
    private Icon treeIcon = ResourceManager.createImageIcon("icons/16x16/text_tree.png", "View Object Graph");
    private int extraColumns = 2;
    List topResults = new ArrayList();
    List resultWindow = new ArrayList();
    private int windowStartIndex = -1;
    private int windowEndIndex = -1;

    public QueryResultsTableModel(String query, QueryResultsPanel queryResultsPanel) throws Exception {
        this.query = query;
        this.queryResultsPanel = queryResultsPanel;
        try {
            long startTime = System.currentTimeMillis();
            this.results = (ObjectSetWrapper)((Object)Sql4o.execute(queryResultsPanel.getObjectContainer(), query));
            long duration = System.currentTimeMillis() - startTime;
            queryResultsPanel.setStatusMessage("Returned " + this.results.size() + " results in " + duration + "ms");
            this.initTop(this.results);
        }
        catch (Exception e) {
            queryResultsPanel.setErrorMessage("Error executing query!  " + e.getMessage());
            Log.addException(e);
            throw e;
        }
    }

    private void initTop(ObjectSetWrapper results) {
        for (int i = 0; i < 100 && i < results.size(); ++i) {
            Result result = results.get(i);
            this.topResults.add(result);
        }
    }

    public int getRowCount() {
        return this.results.size();
    }

    public int getColumnCount() {
        return this.results.getMetaData().getColumnCount() + this.extraColumns;
    }

    public Object getValueAt(int row, int column) {
        Result result;
        if (column == 0) {
            return this.treeIcon;
        }
        if (column == 1) {
            return row;
        }
        if (row < 100) {
            result = (Result)this.topResults.get(row);
        } else {
            int index = this.rowInCurrentWindow(row);
            if (index == -1) {
                index = this.loadWindow(row);
            }
            result = (Result)this.resultWindow.get(index);
        }
        this.activateRowObject(row, result);
        Object ret = null;
        try {
            ReflectClass rc;
            ret = result.getObject(column - this.extraColumns);
            if (ret == null) {
                return ret;
            }
            GenericReflector reflector = this.queryResultsPanel.getObjectContainer().ext().reflector();
            if (reflector.isCollection(rc = reflector.forObject(ret))) {
                if (ret instanceof Map) {
                    Map m = (Map)ret;
                    return new MapValue("Map: " + m.size());
                }
                Collection c = (Collection)ret;
                return new CollectionValue("Collection: " + c.size() + " items");
            }
            if (rc.isArray()) {
                return new CollectionValue("Array: " + reflector.array().getLength(ret) + " items");
            }
        }
        catch (Exception e) {
            this.queryResultsPanel.setErrorMessage("Error occurred: " + e.getMessage());
            Log.addException(e);
        }
        return ret;
    }

    private void activateRowObject(int row, Result result) {
        Object rowObject = result.getBaseObject(row);
        if (Activatable.class.isAssignableFrom(rowObject.getClass())) {
            ((Activatable)rowObject).activate();
        }
    }

    private int loadWindow(int row) {
        int endIndex;
        int ret = 100;
        this.resultWindow.clear();
        int startIndex = row - 100;
        if (startIndex < 100) {
            ret = startIndex;
            startIndex = 100;
        }
        if ((endIndex = row + 100) >= this.results.size()) {
            endIndex = this.results.size();
        }
        for (int i = startIndex; i < endIndex; ++i) {
            Result result = this.results.get(i);
            this.resultWindow.add(result);
        }
        this.windowStartIndex = startIndex;
        this.windowEndIndex = endIndex;
        return ret;
    }

    private int rowInCurrentWindow(int row) {
        if (row >= this.windowStartIndex && row < this.windowEndIndex) {
            return row - this.windowStartIndex;
        }
        return -1;
    }

    public boolean isCellEditable(int row, int col) {
        if (col < this.extraColumns) {
            return false;
        }
        Class c = this.getColumnClass(col);
        return ReflectHelper2.isEditable((Class)c);
    }

    public void setValueAt(Object value, int row, int col) {
        Result result = this.results.get(row);
        Object o = result.getBaseObject(0);
        ReflectClass rc = this.results.getReflector().forObject(o);
        ReflectField[] rfs = ReflectHelper.getDeclaredFieldsInHeirarchy(rc);
        if (rfs.length > col - this.extraColumns) {
            ReflectField rf = rfs[col - this.extraColumns];
            rf.setAccessible();
            rf.set(o, value);
            this.queryResultsPanel.addObjectToBatch(o);
        }
        super.setValueAt(value, row, col - this.extraColumns);
        this.fireTableCellUpdated(row, col);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return " ";
        }
        if (column == 1) {
            return "Row";
        }
        return this.results.getMetaData().getColumnName(column - this.extraColumns);
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return Icon.class;
        }
        if (column == 1) {
            return Number.class;
        }
        ReflectField reflectField = this.results.getMetaData().getColumnReflectField(column - this.extraColumns);
        Class clazz = ReflectHelper2.reflectClassToClass((ReflectClass)reflectField.getFieldType());
        if (clazz == null) {
            return super.getColumnClass(column);
        }
        return clazz;
    }

    public ObjectContainer getObjectContainer() {
        return this.queryResultsPanel.getObjectContainer();
    }

    public Object getRowObject(int row) {
        Result wrapper = this.results.get(row);
        return wrapper.getBaseObject(0);
    }
}

