/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.custom;

import com.db4o.objectManager.v2.Dashboard;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel {
    private Image bgImage;

    public BackgroundPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.bgImage = BackgroundPanel.getImage(Dashboard.class.getResource("resources/images/gradient.png"));
    }

    public boolean isOpaque() {
        return true;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
    }

    private void paintBackground(Graphics g) {
        if (this.bgImage != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            int imageW = this.bgImage.getWidth(null);
            int imageH = this.bgImage.getHeight(null);
            for (int x = 0; x < width; x += imageW) {
                for (int y = 0; y < height; y += imageH) {
                    g.drawImage(this.bgImage, x, y, this);
                }
            }
        }
    }

    protected static Image getImage(URL imageURL) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageURL);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return image;
    }
}

