/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.connections;

import com.db4o.objectManager.v2.connections.ConnectionListCellRenderer;
import com.db4o.objectmanager.api.prefs.Preferences;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.db4o.objectmanager.model.Db4oFileConnectionSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentConnectionList
extends JPanel {
    private JList list;
    private DefaultListModel listModel;
    private static final String RECENT_CONNECTIONS = "recentConnections";

    public RecentConnectionList() {
        super(new BorderLayout());
        List<Db4oConnectionSpec> connections = this.getRecentConnectionSpecsFromDb();
        this.listModel = new DefaultListModel();
        for (int i = 0; i < connections.size(); ++i) {
            Db4oConnectionSpec db4oConnectionSpec = connections.get(i);
            this.listModel.addElement(db4oConnectionSpec);
        }
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new ConnectionListCellRenderer());
        this.list.setVisibleRowCount(5);
        JScrollPane listScroller = new JScrollPane(this.list);
        this.add(listScroller);
    }

    private List<Db4oConnectionSpec> getRecentConnectionSpecsFromDb() {
        ArrayList<Db4oConnectionSpec> connections = (ArrayList<Db4oConnectionSpec>)Preferences.getDefault().getPreference(RECENT_CONNECTIONS);
        if (connections == null) {
            connections = new ArrayList<Db4oConnectionSpec>();
        }
        int removed = 0;
        for (int i = 0; i < connections.size(); ++i) {
            File f;
            Db4oConnectionSpec connectionSpec = (Db4oConnectionSpec)connections.get(i);
            if (!(connectionSpec instanceof Db4oFileConnectionSpec) || (f = new File(connectionSpec.getFullPath())).exists()) continue;
            connections.remove(connectionSpec);
            --i;
            ++removed;
        }
        if (removed > 0) {
            this.saveConnections(connections);
        }
        return connections;
    }

    public void addNewConnectionSpec(Db4oConnectionSpec connectionSpec) {
        List<Db4oConnectionSpec> connections = this.getRecentConnectionSpecsFromDb();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            Db4oConnectionSpec spec = (Db4oConnectionSpec)this.listModel.get(i);
            if (!spec.getPath().equals(connectionSpec.getPath())) continue;
            this.listModel.remove(i);
            this.listModel.add(0, spec);
            this.list.setSelectedIndex(0);
            connections.remove(spec);
            connections.add(0, spec);
            this.saveConnections(connections);
            return;
        }
        connections.add(0, connectionSpec);
        this.saveConnections(connections);
        this.listModel.addElement(connectionSpec);
    }

    private void saveConnections(List<Db4oConnectionSpec> connections) {
        Preferences.getDefault().setPreference(RECENT_CONNECTIONS, connections);
    }

    public Db4oConnectionSpec getSelected() {
        if (this.list.getSelectedIndex() != -1) {
            return (Db4oConnectionSpec)this.listModel.get(this.list.getSelectedIndex());
        }
        return null;
    }

    public Component getList() {
        return this.list;
    }
}

