/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.connections;

import com.db4o.objectManager.v2.BaseMenuBar;
import com.db4o.objectManager.v2.Dashboard;
import com.db4o.objectManager.v2.Settings;
import com.db4o.objectManager.v2.custom.ProgressDialog;
import com.db4o.objectManager.v2.demo.DemoDbTask;
import com.db4o.objectManager.v2.uiHelper.OptionPaneHelper;
import com.db4o.objectManager.v2.uiHelper.SwingWorker;
import com.db4o.objectManager.v2.util.Log;
import demo.objectmanager.model.DemoPopulator;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DashboardMenuBar
extends BaseMenuBar {
    private Dashboard dashboard;

    public DashboardMenuBar(Dashboard dashboard2, Settings settings, ActionListener helpActionListener, ActionListener aboutActionListener) {
        super(settings, helpActionListener, aboutActionListener);
        this.dashboard = dashboard2;
        this.putClientProperty("jgoodies.headerStyle", Boolean.TRUE);
        JMenu menu = new JMenu("File");
        JMenuItem item = this.createMenuItem("Create Demo Db");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DashboardMenuBar.this.makeDemoDb();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = this.createMenuItem("Exit", 'E');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(item);
        this.add(menu);
        menu = this.buildHelpMenu(helpActionListener, aboutActionListener);
        menu.addSeparator();
        item = new JMenuItem("Exception Log");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame logFrame = new JFrame("Exception Log");
                JTextArea ta = new JTextArea(20, 80);
                JScrollPane scrollPane = new JScrollPane(ta);
                logFrame.add(scrollPane);
                logFrame.pack();
                logFrame.setVisible(true);
                ta.setText(Log.dump());
            }
        });
        menu.add(item);
        this.add(menu);
    }

    private void makeDemoDb() {
        final ProgressDialog pd = new ProgressDialog(this.dashboard.getFrame(), "Creating Demo Db", true);
        pd.setIndeterminate(true);
        pd.setStringPainted(true);
        pd.setString("Creating demo database...");
        SwingWorker worker = new SwingWorker(){
            boolean successful = false;
            String filename;

            public Object construct() {
                DashboardMenuBar.this.dashboard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    DemoDbTask task = new DemoDbTask();
                    task.run();
                    System.out.println("done making demo db.");
                    DemoPopulator populator = task.getPopulator();
                    this.filename = populator.getFileName();
                    this.successful = true;
                }
                catch (Exception e1) {
                    OptionPaneHelper.showErrorMessage(DashboardMenuBar.this.dashboard.getFrame(), "Error creating model database!\n\n" + e1.getMessage(), "Error During Defragment");
                    Log.addException(e1);
                    e1.printStackTrace();
                }
                return null;
            }

            public void finished() {
                super.finished();
                pd.dispose();
                DashboardMenuBar.this.dashboard.getFrame().setCursor(null);
                if (this.successful) {
                    DashboardMenuBar.this.dashboard.connectToFile(this.filename);
                }
            }
        };
        worker.start();
        pd.setVisible(true);
    }
}

