/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.connections;

import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.db4o.objectmanager.model.Db4oSocketConnectionSpec;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ConnectionListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel pathLabel;
    private JLabel imageLabel;
    private static final String IMG_LOCAL = "harddisk.png";
    private static final String IMG_NETWORKED = "client_network.png";

    public ConnectionListCellRenderer() {
        this.setLayout(new BoxLayout(this, 2));
        this.pathLabel = new JLabel(" ");
        this.imageLabel = new JLabel();
        this.imageLabel.setOpaque(true);
        this.add(this.imageLabel);
        this.add(this.pathLabel);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String imgIcon;
        Db4oConnectionSpec entry = (Db4oConnectionSpec)value;
        String user = null;
        if (entry instanceof Db4oSocketConnectionSpec) {
            Db4oSocketConnectionSpec spec = (Db4oSocketConnectionSpec)entry;
            user = spec.getUser();
            imgIcon = IMG_NETWORKED;
        } else {
            imgIcon = IMG_LOCAL;
        }
        this.pathLabel.setText(entry.getFullPath());
        String host = entry.getFullPath();
        if (host == null) {
            host = " ";
        }
        if (user == null) {
            user = " ";
        }
        this.pathLabel.setText(host);
        this.imageLabel.setIcon(ResourceManager.createImageIcon("icons/16x16/" + imgIcon));
        if (isSelected) {
            this.adjustColors(list.getSelectionBackground(), list.getSelectionForeground(), this, this.imageLabel, this.pathLabel);
        } else {
            this.adjustColors(list.getBackground(), list.getForeground(), this, this.imageLabel, this.pathLabel);
        }
        return this;
    }

    private void adjustColors(Color bg, Color fg, Component ... components) {
        for (Component c : components) {
            c.setForeground(fg);
            c.setBackground(bg);
        }
    }
}

