/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.connections;

import com.db4o.ObjectContainer;
import com.db4o.objectManager.v2.Dashboard;
import com.db4o.objectManager.v2.MainFrame;
import com.db4o.objectManager.v2.WindowPrefsListener;
import com.db4o.objectManager.v2.configuration.ConfigurationDialog;
import com.db4o.objectManager.v2.connections.ConnectionHelper;
import com.db4o.objectManager.v2.connections.RecentConnectionList;
import com.db4o.objectManager.v2.uiHelper.UIHelper;
import com.db4o.objectmanager.api.helpers.SerializerHelper;
import com.db4o.objectmanager.api.prefs.Preferences;
import com.db4o.objectmanager.configuration.ConfigurationFacade;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.db4o.objectmanager.model.Db4oFileConnectionSpec;
import com.db4o.objectmanager.model.Db4oSocketConnectionSpec;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.Fonts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConnectionForm {
    private JTextField hostTextField;
    private JTextField portTextField;
    private JTextField usernameTextField;
    private JTextField passwordTextField;
    private JTextField fileTextField;
    private ConfigurationFacade configuration;
    private JPanel panel;
    private Dashboard dashboard;
    private RecentConnectionList recentConnectionList;

    public ConnectionForm(Dashboard dashboard2) {
        this.dashboard = dashboard2;
        JLabel welcome = new JLabel("Recent Connections");
        welcome.setFont(Fonts.WINDOWS_VISTA_96DPI_LARGE);
        welcome.setForeground(Color.white);
        welcome.setVerticalAlignment(1);
        this.recentConnectionList = new RecentConnectionList();
        this.recentConnectionList.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Db4oConnectionSpec connectionSpec = ConnectionForm.this.recentConnectionList.getSelected();
                if (connectionSpec != null) {
                    ConnectionForm.this.showInForm(connectionSpec);
                    if (e.getClickCount() == 2) {
                        ConnectionForm.this.connectAndOpenFrame(connectionSpec);
                    }
                }
            }
        });
        this.recentConnectionList.getList().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Db4oConnectionSpec connectionSpec;
                if (e.getKeyChar() == '\n' && (connectionSpec = ConnectionForm.this.recentConnectionList.getSelected()) != null) {
                    ConnectionForm.this.showInForm(connectionSpec);
                    ConnectionForm.this.connectAndOpenFrame(connectionSpec);
                }
            }
        });
        JLabel welcome2 = new JLabel("New Connection");
        welcome2.setFont(Fonts.WINDOWS_VISTA_96DPI_LARGE);
        welcome2.setForeground(Color.white);
        FormLayout layout = new FormLayout("right:max(40dlu;pref), 3dlu, 120dlu, 7dlu,right:max(40dlu;pref), 3dlu, 80dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)welcome);
        builder.nextLine();
        builder.append("", (Component)this.recentConnectionList, 3);
        builder.nextLine();
        builder.append((Component)welcome2);
        builder.nextLine();
        builder.appendSeparator("Configuration");
        JButton configurationButton = new JButton("Configure");
        configurationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationDialog configurationForm = new ConfigurationDialog(ConnectionForm.this.configuration);
                configurationForm.setAlwaysOnTop(true);
                UIHelper.CenterFormInScreen(configurationForm, configurationForm.getToolkit());
                configurationForm.setVisible(true);
                ConnectionForm.this.configuration = configurationForm.getConfiguration();
            }
        });
        JButton clearConfigurationButton = new JButton("Clear");
        clearConfigurationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionForm.this.configuration = null;
            }
        });
        builder.append("", (Component)configurationButton, (Component)clearConfigurationButton);
        builder.nextLine();
        builder.appendSeparator("Local");
        this.fileTextField = new JTextField();
        builder.append("File:", (Component)this.fileTextField);
        final JFileChooser fc = new JFileChooser();
        final JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                if (e.getSource() == browse && (returnVal = fc.showOpenDialog(ConnectionForm.this.dashboard.getFrame())) == 0) {
                    File file = fc.getSelectedFile();
                    ConnectionForm.this.fileTextField.setText(file.getAbsolutePath());
                }
            }
        });
        builder.append((Component)browse);
        builder.nextLine();
        JButton openButton = new JButton("Open");
        openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionForm.this.connectToFile();
            }
        });
        builder.append("", (Component)openButton);
        builder.nextLine();
        builder.appendSeparator("Remote");
        this.hostTextField = new JTextField();
        builder.append("Host:", (Component)this.hostTextField);
        this.portTextField = new JTextField();
        this.portTextField.setColumns(5);
        builder.append("Port:", (Component)this.portTextField);
        builder.nextLine();
        this.usernameTextField = new JTextField();
        builder.append("Username:", (Component)this.usernameTextField);
        builder.nextLine();
        this.passwordTextField = new JTextField();
        builder.append("Password:", (Component)this.passwordTextField);
        builder.nextLine();
        JButton connectButton = new JButton("Connect");
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConnectionForm.this.hostTextField.getText().length() > 0) {
                    Db4oSocketConnectionSpec connectionSpec = new Db4oSocketConnectionSpec(ConnectionForm.this.hostTextField.getText(), Integer.parseInt(ConnectionForm.this.portTextField.getText()), ConnectionForm.this.usernameTextField.getText(), ConnectionForm.this.passwordTextField.getText(), false);
                    ConnectionForm.this.connectAndOpenFrame((Db4oConnectionSpec)connectionSpec);
                }
            }
        });
        builder.append("", (Component)connectButton);
        this.LoadConfiguration();
        this.panel = builder.getPanel();
        this.panel.setOpaque(false);
    }

    private void LoadConfiguration() {
        try {
            Object result = SerializerHelper.Deserialize((String)ConfigurationFacade.CONFIGURATION_FILE_PATH);
            if (result != null) {
                this.configuration = (ConfigurationFacade)result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void connectToFile(String dataFile) {
        this.fileTextField.setText(dataFile);
        this.connectToFile();
    }

    private void connectToFile() {
        if (this.fileTextField.getText().length() > 0) {
            Db4oFileConnectionSpec connectionSpec = new Db4oFileConnectionSpec(this.fileTextField.getText(), false);
            connectionSpec.setConfiguration(this.configuration);
            this.connectAndOpenFrame((Db4oConnectionSpec)connectionSpec);
        }
    }

    public void connectAndOpenFrame(Db4oConnectionSpec connectionSpec) {
        ObjectContainer oc;
        this.working();
        try {
            oc = ConnectionHelper.connect(this.dashboard.getFrame(), connectionSpec);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            this.stopWorking();
            return;
        }
        this.recentConnectionList.addNewConnectionSpec(connectionSpec);
        this.clearForm();
        Dimension frameSize = (Dimension)Preferences.getDefault().getPreference("frameSize");
        Point frameLocation = (Point)Preferences.getDefault().getPreference("frameLocation");
        MainFrame instance = MainFrame.createDefaultFrame(frameSize, frameLocation, connectionSpec, oc);
        instance.addComponentListener(new WindowPrefsListener(instance));
        this.dashboard.addOpenConnection(connectionSpec, oc);
        this.stopWorking();
    }

    private void stopWorking() {
        this.dashboard.getFrame().setCursor(null);
    }

    private void working() {
        this.dashboard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
    }

    private void clearForm() {
        this.fileTextField.setText("");
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        this.portTextField.setText("");
        this.hostTextField.setText("");
    }

    private void showInForm(Db4oConnectionSpec connectionSpec) {
        this.clearForm();
        if (connectionSpec instanceof Db4oFileConnectionSpec) {
            this.fileTextField.setText(connectionSpec.getPath());
        } else if (connectionSpec instanceof Db4oSocketConnectionSpec) {
            Db4oSocketConnectionSpec spec = (Db4oSocketConnectionSpec)connectionSpec;
            this.hostTextField.setText(spec.getHost());
            this.portTextField.setText(spec.getPort() + "");
            this.usernameTextField.setText(spec.getUser());
            this.passwordTextField.setText(spec.getPassword());
        }
    }

    public JTextField getHostTextField() {
        return this.hostTextField;
    }

    public void setHostTextField(JTextField hostTextField) {
        this.hostTextField = hostTextField;
    }

    public JTextField getPortTextField() {
        return this.portTextField;
    }

    public void setPortTextField(JTextField portTextField) {
        this.portTextField = portTextField;
    }

    public JTextField getUsernameTextField() {
        return this.usernameTextField;
    }

    public void setUsernameTextField(JTextField usernameTextField) {
        this.usernameTextField = usernameTextField;
    }

    public JTextField getPasswordTextField() {
        return this.passwordTextField;
    }

    public void setPasswordTextField(JTextField passwordTextField) {
        this.passwordTextField = passwordTextField;
    }

    public Component getPanel() {
        return this.panel;
    }
}

