/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.objectManager.v2.ClassStatsTableModel;
import com.db4o.objectManager.v2.MainPanel;
import com.db4o.objectManager.v2.custom.BorderedFormPanel;
import com.db4o.objectManager.v2.custom.BorderedPanel;
import com.db4o.objectmanager.api.DatabaseInspector;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.db4o.objectmanager.model.Db4oFileConnectionSpec;
import com.db4o.objectmanager.model.Db4oSocketConnectionSpec;
import com.db4o.reflect.ReflectClass;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DatabaseSummaryPanel
extends JPanel {
    private MainPanel mainPanel;
    private Db4oConnectionSpec connectionSpec;
    private DatabaseInspector databaseInspector;
    private ClassStatsTableModel classStatsTableModel;

    public DatabaseSummaryPanel(MainPanel mainPanel, Db4oConnectionSpec connectionSpec, DatabaseInspector databaseInspector) {
        super(new BorderLayout());
        this.mainPanel = mainPanel;
        this.connectionSpec = connectionSpec;
        this.databaseInspector = databaseInspector;
        this.setOpaque(false);
        this.setBorder(Borders.DIALOG_BORDER);
        this.add(this.buildMain());
    }

    private Component buildMain() {
        Box box = new Box(3);
        box.add(this.buildConnectionInfo());
        box.add(this.buildMainDatabaseStats());
        box.add(this.buildClassStats());
        return box;
    }

    private Component buildConnectionInfo() {
        BorderedFormPanel builder = new BorderedFormPanel("Connected to db4o Database");
        if (this.connectionSpec instanceof Db4oFileConnectionSpec) {
            Db4oFileConnectionSpec spec = (Db4oFileConnectionSpec)this.connectionSpec;
            builder.append("File:", new JLabel(spec.getFullPath()));
        } else if (this.connectionSpec instanceof Db4oSocketConnectionSpec) {
            Db4oSocketConnectionSpec spec = (Db4oSocketConnectionSpec)this.connectionSpec;
            builder.append("Hostname: ", new JLabel(spec.getHost()));
            builder.append("Port: ", new JLabel(Integer.toString(spec.getPort())));
            builder.append("Username: ", new JLabel(spec.getUser()));
        }
        return builder.getPanel();
    }

    private Component buildMainDatabaseStats() {
        BorderedFormPanel builder = new BorderedFormPanel("Database Statistics");
        builder.append("Size:", new JLabel(this.databaseInspector.getSize() + " bytes"));
        return builder.getPanel();
    }

    private Component buildClassStats() {
        BorderedPanel builder = new BorderedPanel("Stored Classes");
        TableModel classModel = this.createClassTableModel();
        final JTable table = new JTable(classModel);
        table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    int row = table.rowAtPoint(p);
                    if (DatabaseSummaryPanel.this.classStatsTableModel.getStoredClasses() != null && DatabaseSummaryPanel.this.classStatsTableModel.getStoredClasses().size() > row) {
                        ReflectClass clazz = DatabaseSummaryPanel.this.classStatsTableModel.getStoredClasses().get(row);
                        DatabaseSummaryPanel.this.mainPanel.showClassSummary(clazz.getName());
                    }
                }
            }
        });
        TableColumn col = table.getColumnModel().getColumn(0);
        int width = 200;
        col.setPreferredWidth(width);
        JScrollPane scrollPane = new JScrollPane(table);
        builder.add(scrollPane);
        return builder.getPanel();
    }

    private TableModel createClassTableModel() {
        this.classStatsTableModel = new ClassStatsTableModel(this.databaseInspector);
        return this.classStatsTableModel;
    }
}

