/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.objectManager.v2.BaseMenuBar;
import com.db4o.objectManager.v2.Dashboard;
import com.db4o.objectManager.v2.MainFrame;
import com.db4o.objectManager.v2.Settings;
import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectManager.v2.uiHelper.OptionPaneHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ConnectedMenuBar
extends BaseMenuBar {
    private MainFrame frame;

    public ConnectedMenuBar(MainFrame mainFrame, Settings settings, ActionListener helpActionListener, ActionListener aboutActionListener) {
        super(settings, helpActionListener, aboutActionListener);
        this.frame = mainFrame;
        this.add(this.buildFileMenu());
        if (!this.frame.getConnectionSpec().isRemote()) {
            this.add(this.buildManageMenu());
        }
        this.add(this.buildHelpMenu(helpActionListener, aboutActionListener));
    }

    private JMenu buildManageMenu() {
        JMenu menu = this.createMenu("Manage", 'M');
        JMenuItem item = this.makeBackupItem();
        menu.add(item);
        menu.addSeparator();
        item = this.makeDefragItem();
        menu.add(item);
        return menu;
    }

    private JMenuItem makeExportItem() {
        JMenuItem item = this.createMenuItem("Export\u2026", ResourceManager.createImageIcon("saveas_edit.gif"), 'b');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                int response = fileChooser.showSaveDialog(ConnectedMenuBar.this.frame);
                if (response == 0) {
                    File f = fileChooser.getSelectedFile();
                    try {
                        OptionPaneHelper.showSuccessDialog(ConnectedMenuBar.this.frame, "Export completed successfully.", "Export Successful");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        OptionPaneHelper.showErrorMessage(ConnectedMenuBar.this.frame, "Error during export! " + e1.getMessage(), "Error during export");
                    }
                }
            }
        });
        return item;
    }

    private JMenuItem makeDefragItem() {
        JMenuItem item = this.createMenuItem("Defragment", 'd', KeyStroke.getKeyStroke("ctrl shift D"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(ConnectedMenuBar.this.frame, "Are you sure you want to defragment this database?\nThis operation will shutdown the currently running database and reopen after the operation completes.\nPlease be aware of the side effects of running defragment. See db4o manual.");
                if (result == 0) {
                    ConnectedMenuBar.this.frame.close();
                    Dashboard.defragment(ConnectedMenuBar.this.frame.getConnectionSpec());
                }
            }
        });
        item.setEnabled(true);
        return item;
    }

    private JMenuItem makeBackupItem() {
        JMenuItem item = this.createMenuItem("Backup\u2026", ResourceManager.createImageIcon("saveas_edit.gif"), 'b');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                int response = fileChooser.showSaveDialog(ConnectedMenuBar.this.frame);
                if (response == 0) {
                    File f = fileChooser.getSelectedFile();
                    try {
                        ConnectedMenuBar.this.frame.getObjectContainer().ext().backup(f.getAbsolutePath());
                        OptionPaneHelper.showSuccessDialog(ConnectedMenuBar.this.frame, "Backup completed successfully.", "Backup Successful");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        OptionPaneHelper.showErrorMessage(ConnectedMenuBar.this.frame, "Error during backup! " + e1.getMessage(), "Error during backup");
                    }
                }
            }
        });
        return item;
    }

    private JMenu buildFileMenu() {
        JMenu menu = this.createMenu("File", 'F');
        JMenuItem item = this.createMenuItem("Close", 'C', KeyStroke.getKeyStroke("ctrl F4"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectedMenuBar.this.frame.close();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = this.createMenuItem("Exit", 'E');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectedMenuBar.this.frame.exit();
            }
        });
        menu.add(item);
        return menu;
    }
}

