/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.annotations;

import com.thoughtworks.xstream.annotations.AnnotationProvider;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationReflectionConverter
extends ReflectionConverter {
    private final AnnotationProvider annotationProvider;

    public AnnotationReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider, AnnotationProvider annotationProvider) {
        super(mapper, reflectionProvider);
        this.annotationProvider = annotationProvider;
    }

    @Override
    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        XStreamConverter annotation = this.annotationProvider.getAnnotation(field, XStreamConverter.class);
        if (annotation != null) {
            Class<? extends Converter> type = annotation.value();
            context.convertAnother(newObj, this.newInstance(type));
        } else {
            context.convertAnother(newObj);
        }
    }

    @Override
    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        XStreamConverter annotation = this.annotationProvider.getAnnotation(field, XStreamConverter.class);
        if (annotation != null) {
            Class<? extends Converter> converterType = annotation.value();
            Converter converter = this.newInstance(converterType);
            return context.convertAnother(result, type, converter);
        }
        return context.convertAnother(result, type);
    }

    private Converter newInstance(Class<? extends Converter> converterType) {
        Converter converter;
        try {
            converter = converterType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new StreamException(e.getCause());
        }
        catch (Exception e) {
            throw new StreamException(e);
        }
        return converter;
    }
}

