/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.util;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.ObjectTranslator;
import com.db4o.config.TSerializable;
import java.io.File;

public class DbUtil {
    private static final String DB_FILE_SUFFIX = ".db4o.yap";
    private static final int PORT = 0;
    private static ObjectServer objectServer;
    private static final ThreadLocal dbThreadLocal;

    public static ObjectContainer getObjectContainer() {
        ObjectContainer oc = (ObjectContainer)dbThreadLocal.get();
        if (oc == null || oc.ext().isClosed()) {
            oc = DbUtil.getObjectServer().openClient();
            dbThreadLocal.set(oc);
        }
        return oc;
    }

    public static void closeDb() {
        ObjectContainer oc = (ObjectContainer)dbThreadLocal.get();
        dbThreadLocal.set(null);
        if (oc != null) {
            oc.close();
        }
    }

    public static ObjectServer getObjectServer() {
        return DbUtil.getObjectServer(null);
    }

    public static synchronized ObjectServer getObjectServer(String name) {
        return DbUtil.getObjectServer(name, 0);
    }

    public static ObjectServer getObjectServer(String name, int port) {
        if (name == null) {
            name = "default";
        }
        if (objectServer == null) {
            objectServer = DbUtil.getObjectServerForFilename(name + DB_FILE_SUFFIX, port);
        }
        return objectServer;
    }

    public static void shutdown() {
        if (objectServer != null) {
            objectServer.close();
        }
    }

    public static ObjectServer getObjectServerForFilename(String yapfilename, int port) {
        File parentDir = DbUtil.getDbDirectory();
        File dbfile = new File(parentDir, yapfilename);
        Db4o.configure().generateUUIDs(Integer.MAX_VALUE);
        Db4o.configure().generateVersionNumbers(Integer.MAX_VALUE);
        Db4o.configure().exceptionsOnNotStorable(true);
        Db4o.configure().objectClass((Object)"java.math.BigDecimal").translate((ObjectTranslator)new TSerializable());
        Db4o.configure().allowVersionUpdates(true);
        ObjectServer objectServer = Db4o.openServer((String)dbfile.getPath(), (int)port);
        return objectServer;
    }

    private static File getDbDirectory() {
        String dbfile = System.getProperty("user.home") + "/db4o/data";
        File f = new File(dbfile);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    static {
        dbThreadLocal = new ThreadLocal();
    }
}

