/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.util;

import com.db4o.ObjectContainer;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericVirtualField;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectHelper {
    public static List getUserStoredClasses(ObjectContainer container) {
        String[] ignore = new String[]{"java.lang.", "java.util.", "java.math.", "com.db4o.", "j4o.lang.AssemblyNameHint"};
        ReflectClass[] knownClasses = container.ext().knownClasses();
        ArrayList<ReflectClass> filteredList = new ArrayList<ReflectClass>();
        for (int i = 0; i < knownClasses.length; ++i) {
            StoredClass sc;
            ReflectClass knownClass = knownClasses[i];
            if (knownClass.isArray() || knownClass.isPrimitive()) continue;
            boolean take = true;
            for (int j = 0; j < ignore.length; ++j) {
                if (!knownClass.getName().startsWith(ignore[j])) continue;
                take = false;
                break;
            }
            if (!take || (sc = container.ext().storedClass((Object)knownClass.getName())) == null) continue;
            filteredList.add(knownClass);
        }
        Collections.sort(filteredList, new Comparator(){
            private Collator comparator = Collator.getInstance();

            public int compare(Object arg0, Object arg1) {
                ReflectClass class0 = (ReflectClass)arg0;
                ReflectClass class1 = (ReflectClass)arg1;
                return this.comparator.compare(class0.getName(), class1.getName());
            }
        });
        return filteredList;
    }

    public static ReflectField[] getDeclaredFieldsInHeirarchy(ReflectClass aClass) {
        List<ReflectField> ret = ReflectHelper.getDeclaredFieldsListInHeirarchy(aClass);
        return ret.toArray(new ReflectField[ret.size()]);
    }

    private static List<ReflectField> getDeclaredFieldsListInHeirarchy(ReflectClass aClass) {
        if (aClass == null) {
            return null;
        }
        List<ReflectField> ret = ReflectHelper.getDeclaredFieldsList(aClass);
        ReflectClass parent = aClass.getSuperclass();
        if (parent != null) {
            ret.addAll(ReflectHelper.getDeclaredFieldsListInHeirarchy(parent));
        }
        return ret;
    }

    public static List<ReflectField> getDeclaredFieldsList(ReflectClass aClass) {
        ArrayList<ReflectField> ret = new ArrayList<ReflectField>();
        ReflectField[] fields = aClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            ReflectField field = fields[i];
            if (field instanceof GenericVirtualField) continue;
            ret.add(field);
        }
        return ret;
    }

    public static StoredField[] getDeclaredFieldsInHeirarchy(StoredClass aClass) {
        List ret = ReflectHelper.getDeclaredFieldsListInHeirarchy(aClass);
        return ret.toArray(new StoredField[ret.size()]);
    }

    private static List getDeclaredFieldsListInHeirarchy(StoredClass aClass) {
        if (aClass == null) {
            return null;
        }
        List<StoredField> ret = ReflectHelper.getDeclaredFieldsList(aClass);
        StoredClass parent = aClass.getParentStoredClass();
        if (parent != null) {
            ret.addAll(ReflectHelper.getDeclaredFieldsListInHeirarchy(parent));
        }
        return ret;
    }

    public static List<StoredField> getDeclaredFieldsList(StoredClass aClass) {
        ArrayList<StoredField> ret = new ArrayList<StoredField>();
        StoredField[] fields = aClass.getStoredFields();
        for (int i = 0; i < fields.length; ++i) {
            StoredField field = fields[i];
            if (field instanceof GenericVirtualField) continue;
            ret.add(field);
        }
        return ret;
    }

    public static ReflectField[] getDeclaredFields(ReflectClass aClass) {
        List<ReflectField> ret = ReflectHelper.getDeclaredFieldsList(aClass);
        return ret.toArray(new ReflectField[ret.size()]);
    }

    public static ReflectField getDeclaredFieldInHeirarchy(ReflectClass reflectClass, String field) {
        ReflectClass parent;
        ReflectField rf = reflectClass.getDeclaredField(field);
        if (rf == null && (parent = reflectClass.getSuperclass()) != null) {
            return ReflectHelper.getDeclaredFieldInHeirarchy(parent, field);
        }
        return rf;
    }
}

