/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import com.spaceprogram.db4o.sql.parser.Builder;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.parser.SqlParser;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.query.Where;
import com.spaceprogram.db4o.sql.query.WhereExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereBuilder
implements Builder {
    public static final String REGEX_OPERATORS = "<=|>=|<>|=|<|>";
    final String keyword = "WHERE";

    @Override
    public String getKeyword() {
        return "WHERE";
    }

    @Override
    public void build(SqlQuery sq, List<String> expressionSplit, List<String> quotedStrings) throws SqlParseException {
        Where where = new Where();
        this.buildExpr(where.getRoot(), expressionSplit, 0, quotedStrings);
        sq.setWhere(where);
    }

    private int buildExpr(WhereExpression root, List<String> expressionSplit, int index, List<String> quotedStrings) throws SqlParseException {
        int i;
        Pattern pattern = Pattern.compile(REGEX_OPERATORS);
        WhereExpression current = new WhereExpression();
        for (i = index; i < expressionSplit.size(); ++i) {
            String s = expressionSplit.get(i);
            if (s.startsWith("(")) {
                String token;
                if (s.equals("(")) {
                    token = s;
                } else {
                    token = s.substring(1);
                    expressionSplit.add(i + 1, token);
                }
                ++i;
                WhereExpression sub = new WhereExpression();
                root.add(sub);
                i = this.buildExpr(sub, expressionSplit, i, quotedStrings);
                continue;
            }
            if (s.equals(")")) {
                return i;
            }
            if (s.equalsIgnoreCase("AND")) {
                current = new WhereExpression("AND");
                continue;
            }
            if (s.equalsIgnoreCase("OR")) {
                current = new WhereExpression("OR");
                continue;
            }
            Matcher matcher = pattern.matcher(s);
            List<MatchResult> matches = this.findMatches(matcher);
            int found = matches.size();
            String operator = null;
            String field = null;
            String value = null;
            int extraPiecesUsed = 0;
            if (found > 1) {
                throw new SqlParseException("Too many operators in where expression: " + s);
            }
            if (found == 1) {
                MatchResult matchResult = matches.get(0);
                operator = matchResult.group();
                field = s.substring(0, matchResult.start());
                value = this.checkForNextPieceAttached(s, matchResult, operator);
            } else {
                field = s;
                if (expressionSplit.size() <= i + 1) {
                    throw new SqlParseException("Invalid where expression.");
                }
                String s2 = expressionSplit.get(i + 1);
                Matcher matcher2 = pattern.matcher(s2);
                List<MatchResult> matches2 = this.findMatches(matcher2);
                int found2 = matches2.size();
                if (found2 > 1) {
                    throw new SqlParseException("Too many operators in where expression: " + s);
                }
                if (found2 == 1) {
                    MatchResult matchResult = matches2.get(0);
                    operator = matchResult.group();
                    if (s2.length() > matchResult.end()) {
                        value = s2.substring(matchResult.end(), s2.length());
                    }
                } else {
                    throw new SqlParseException("Operator not found in where expression.");
                }
                ++extraPiecesUsed;
            }
            if (value == null) {
                value = expressionSplit.get(i + extraPiecesUsed + 1);
                ++extraPiecesUsed;
            }
            if (value.endsWith(")")) {
                value = value.substring(0, value.length() - 1);
                expressionSplit.add(i + extraPiecesUsed + 1, ")");
            }
            value = SqlParser.replaceQuotedValue(quotedStrings, value);
            i += extraPiecesUsed;
            if (field == null || field.length() < 1 || operator == null || operator.length() < 1 || value == null || value.length() < 1) {
                throw new SqlParseException("Incomplete where expression.");
            }
            current.setField(field);
            current.setOperator(operator);
            current.setValue(value);
            root.add(current);
        }
        return i;
    }

    private String checkForNextPieceAttached(String s, MatchResult matcher, String operator) {
        String value = null;
        if (s.length() > matcher.end() + operator.length()) {
            value = s.substring(matcher.end(), s.length());
        }
        return value;
    }

    private List<MatchResult> findMatches(Matcher matcher) {
        ArrayList<MatchResult> ret = new ArrayList<MatchResult>();
        while (matcher.find()) {
            ret.add(matcher.toMatchResult());
        }
        return ret;
    }
}

