/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import com.spaceprogram.db4o.sql.SqlStatement;
import com.spaceprogram.db4o.sql.parser.Builder;
import com.spaceprogram.db4o.sql.parser.FromBuilder;
import com.spaceprogram.db4o.sql.parser.OrderByBuilder;
import com.spaceprogram.db4o.sql.parser.SelectBuilder;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.parser.WhereBuilder;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlParser {
    private static String REGEX_QUOTED_STRING = "'[^']*'";
    private Builder[] builders = new Builder[]{new SelectBuilder(), new FromBuilder(), new WhereBuilder(), new OrderByBuilder()};
    private String query;
    private List<String> quotedStrings = new ArrayList<String>();

    public static SqlStatement parse(String query) throws SqlParseException {
        SqlParser parser = new SqlParser();
        parser.setQuery(query);
        return parser.doParse();
    }

    private SqlStatement doParse() throws SqlParseException {
        this.query = this.replaceQuotedStrings(this.query);
        String[] split = this.query.trim().split("\\s+");
        if (split.length < 2) {
            throw new SqlParseException("Invalid query.");
        }
        SqlQuery sq = new SqlQuery();
        this.buildQuery(split, sq);
        if (sq.getFrom() == null) {
            throw new SqlParseException("No FROM part!");
        }
        return sq;
    }

    private String replaceQuotedStrings(String query) {
        StringBuffer buff = new StringBuffer(query);
        Pattern pattern = Pattern.compile(REGEX_QUOTED_STRING);
        Matcher matcher = pattern.matcher(buff);
        boolean found = false;
        int i = 0;
        while (matcher.find()) {
            this.quotedStrings.add(matcher.group());
            buff.replace(matcher.start(), matcher.end(), "{" + i + "}");
            matcher.reset();
            found = true;
            ++i;
        }
        if (!found) {
            // empty if block
        }
        String ret = buff.toString();
        return ret;
    }

    private void buildQuery(String[] split, SqlQuery sq) throws SqlParseException {
        Builder curBuilder = null;
        ArrayList<String> expr = new ArrayList<String>();
        for (String s : split) {
            Builder builder = this.getBuilder(s);
            if (builder != null) {
                if (curBuilder != null) {
                    curBuilder.build(sq, expr, this.quotedStrings);
                }
                curBuilder = builder;
                expr.clear();
                continue;
            }
            expr.add(s);
        }
        if (expr.size() > 0) {
            if (curBuilder != null) {
                curBuilder.build(sq, expr, this.quotedStrings);
            } else {
                throw new SqlParseException("Invalid Query. No FROM part.");
            }
        }
    }

    private Builder getBuilder(String s) {
        for (Builder builder : this.builders) {
            if (!s.equalsIgnoreCase(builder.getKeyword())) continue;
            return builder;
        }
        return null;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static String replaceQuotedValue(List<String> quotedStrings, String value) {
        if (value.startsWith("{") && value.endsWith("}")) {
            int replacementIndex = Integer.parseInt(value.substring(1, value.length() - 1));
            return quotedStrings.get(replacementIndex);
        }
        return value;
    }

    public static String stripQuotes(String s) {
        return s;
    }

    public static List<String> separateCommas(List<String> expr, boolean includeCommas) {
        ArrayList<String> values = new ArrayList<String>();
        for (String s : expr) {
            if (s.equals(",")) {
                if (!includeCommas) continue;
                values.add(",");
            }
            String[] s2 = s.split(",");
            int i = 0;
            for (String s1 : s2) {
                if (i > 0 && includeCommas) {
                    values.add(",");
                }
                values.add(s1);
                ++i;
            }
        }
        return values;
    }
}

