/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Test;

public class RegexTest {
    @Test
    public void testQuotedString() {
        String REGEX = "'[\\w\\s]*'";
        String INPUT = "where contact='someNAme LAstname'";
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(INPUT);
        System.out.println("Current REGEX is: " + REGEX);
        System.out.println("Current INPUT is: " + INPUT);
        this.processMatches(matcher);
    }

    @Test
    public void testOperators() {
        String REGEX = "<=|>=|<>|=|<|>";
        Pattern pattern = Pattern.compile(REGEX);
        System.out.println("Current REGEX is: " + REGEX);
        String[] inputs = new String[]{"where contact='someNAme LAstname'", "where contact = 'somename'", "where contact <= 'somename'", "where contact<='somename'", "where contact <'test'", " where contact>= 123", "where contact => 123"};
        for (int i = 0; i < inputs.length; ++i) {
            String input = inputs[i];
            Matcher matcher = pattern.matcher(input);
            System.out.println("Current INPUT is: " + input);
            this.processMatches(matcher);
        }
    }

    private void processMatches(Matcher matcher) {
        boolean found = false;
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String g = matcher.group(i);
            System.out.println("group: " + g);
        }
        while (matcher.find()) {
            System.out.println("I found the text \"" + matcher.group() + "\" starting at index " + matcher.start() + " and ending at index " + matcher.end() + ".");
            found = true;
        }
        if (!found) {
            System.out.println("No match found.");
        }
    }
}

