/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import com.spaceprogram.db4o.sql.parser.Builder;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.parser.SqlParser;
import com.spaceprogram.db4o.sql.query.OrderBy;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByBuilder
implements Builder {
    static final String keyword = "ORDER";

    @Override
    public String getKeyword() {
        return keyword;
    }

    @Override
    public void build(SqlQuery sq, List<String> expr, List<String> quotedStrings) throws SqlParseException {
        OrderBy orderBy = new OrderBy();
        List<String> values = SqlParser.separateCommas(expr.subList(1, expr.size()), false);
        int j = 0;
        OrderBy.Field field = new OrderBy.Field();
        for (int i = 0; i < values.size(); ++i) {
            String s = values.get(i);
            if (s.equals(",")) {
                j = 0;
                orderBy.addField(field);
                field = new OrderBy.Field();
            }
            if (j > 1) {
                throw new SqlParseException("Order by clause invalid, too many parts: " + s);
            }
            if (j == 0) {
                field.setName(s);
            } else if (j == 1) {
                if (s.equalsIgnoreCase("ASC")) {
                    field.orderAscending();
                } else if (s.equalsIgnoreCase("DESC")) {
                    field.orderDescending();
                }
            }
            ++j;
        }
        if (j == 0) {
            throw new SqlParseException("Invalid ORDER BY clause.");
        }
        orderBy.addField(field);
        sq.setOrderBy(orderBy);
    }
}

