/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.metadata;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericReflector;
import com.spaceprogram.db4o.sql.ClassRef;
import com.spaceprogram.db4o.sql.ObjectSetMetaData;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Sql4oRuntimeException;
import com.spaceprogram.db4o.sql.query.From;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.util.ArrayList;
import java.util.List;

public class ObjectSetMetaDataImpl
implements ObjectSetMetaData {
    private List<String> fields = new ArrayList<String>();
    private List<ReflectField> reflectFields = new ArrayList<ReflectField>();

    public ObjectSetMetaDataImpl(ObjectSet results, ObjectSetWrapper objectSetWrapper, ObjectContainer oc, SqlQuery sqlQuery) {
        this.init(results, objectSetWrapper, oc, sqlQuery);
    }

    private void init(ObjectSet results, ObjectSetWrapper objectSetWrapper, ObjectContainer oc, SqlQuery sqlQuery) {
        From from = sqlQuery.getFrom();
        List<ClassRef> classRefs = from.getClassRefs();
        for (int i = 0; i < classRefs.size(); ++i) {
            ClassRef classRef = classRefs.get(i);
            String cname = classRef.getClassName();
            GenericReflector reflector = oc.ext().reflector();
            ReflectClass reflectClass = reflector.forName(cname);
            ReflectField[] reflectFields = this.getDeclaredFields(reflectClass);
            for (int j = 0; j < reflectFields.length; ++j) {
                ReflectField reflectField = reflectFields[j];
                if (objectSetWrapper.hasSelectFields()) {
                    if (!objectSetWrapper.getSelectFields().contains(reflectField.getName())) continue;
                    this.reflectFields.add(reflectField);
                    this.fields.add(reflectField.getName());
                    continue;
                }
                this.reflectFields.add(reflectField);
                this.fields.add(reflectField.getName());
            }
        }
    }

    private ReflectField[] getDeclaredFields(ReflectClass reflectClass) {
        return ReflectHelper.getDeclaredFieldsInHeirarchy(reflectClass);
    }

    public int getColumnCount() {
        return this.fields.size();
    }

    public String getColumnName(int column) {
        if (column >= 0 && column < this.fields.size()) {
            return this.fields.get(column);
        }
        return null;
    }

    public ReflectField getColumnReflectField(int fieldIndex) {
        if (this.reflectFields.size() <= fieldIndex || fieldIndex < 0) {
            throw new Sql4oRuntimeException("Field index out of bounds. received: " + fieldIndex + " max: " + this.reflectFields.size());
        }
        ReflectField ret = this.reflectFields.get(fieldIndex);
        ret.setAccessible();
        return ret;
    }

    public ReflectField getColumnReflectField(String fieldName) {
        for (int i = 0; i < this.reflectFields.size(); ++i) {
            ReflectField reflectField = this.reflectFields.get(i);
            if (!reflectField.getName().equals(fieldName)) continue;
            reflectField.setAccessible();
            return reflectField;
        }
        return null;
    }
}

