/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.jdbc;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import com.spaceprogram.db4o.Contact;
import com.spaceprogram.db4o.sql.ContactTest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;

public class JdbcTest
extends ContactTest {
    private Connection getConnection() throws ClassNotFoundException, SQLException {
        Connection con = null;
        Class.forName("com.spaceprogram.db4o.sql.jdbc.Db4oDriver");
        con = DriverManager.getConnection("jdbc:db4o://localhost:" + port, username, password);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerformanceVsSoda() throws SQLException, ClassNotFoundException {
        int sodaSize = 0;
        int sqlSize = 0;
        System.out.println("Soda query...");
        ObjectContainer oc = server.openClient();
        Query q = oc.query();
        q.constrain(Contact.class);
        q.descend("name").constrain((Object)"contact 2");
        q.descend("category").constrain((Object)"friends");
        long startTime = System.currentTimeMillis();
        ObjectSet results = q.execute();
        sodaSize = results.size();
        for (Object o : results) {
            Contact c = (Contact)o;
            System.out.println("got: " + c);
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        System.out.println("soda duration: " + duration);
        oc.close();
        System.out.println("SQL query");
        Connection conn = this.getConnection();
        try {
            Statement stmt = conn.createStatement();
            startTime = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery("select * from com.spaceprogram.db4o.Contact c where name = 'contact 2' and  category = 'friends'");
            while (rs.next()) {
                String name = rs.getString("name");
                System.out.println("Got: " + name);
                ++sqlSize;
            }
            endTime = System.currentTimeMillis();
            duration = endTime - startTime;
            System.out.println("SQL duration: " + duration);
            rs.close();
            stmt.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertEquals((Object)sodaSize, (Object)sqlSize);
    }
}

