/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.jdbc;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.spaceprogram.db4o.sql.jdbc.Db4oConnection;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class Db4oDriver
implements Driver {
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;
    private static final String DRIVER_NAME = "db4o JDBC Driver";

    public Db4oDriver() {
        System.out.println("LOADING DB4O DRIVER");
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String user = info.getProperty("user");
        String password = info.getProperty("password");
        String[] urlSplit = url.split("//");
        if (urlSplit.length < 2) {
            this.throwBadUrlException(url);
        }
        for (String s : urlSplit) {
            System.out.println(s);
        }
        String[] split2 = urlSplit[1].split(":");
        if (split2.length < 2) {
            this.throwBadUrlException(url);
        }
        String hostname = null;
        int port = 0;
        try {
            hostname = split2[0];
            port = Integer.parseInt(split2[1]);
        }
        catch (Exception e) {
            this.throwBadUrlException(url);
        }
        ObjectContainer oc = null;
        try {
            oc = Db4o.openClient((String)hostname, (int)port, (String)user, (String)password);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return new Db4oConnection(this, oc);
    }

    private void throwBadUrlException(String url) throws SQLException {
        throw new SQLException("JDBC url is not valid [" + url + "].  Must be of the form: jdbc:db4o://HOSTNAME:PORT");
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.contains("db4o");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static String getVersion() {
        return "1.0";
    }

    public static String getDriverName() {
        return DRIVER_NAME;
    }

    static {
        try {
            Db4oDriver driver = new Db4oDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

