/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.jdk.JdkReflector;
import com.spaceprogram.db4o.sql.ClassRef;
import com.spaceprogram.db4o.sql.Converter;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Result;
import com.spaceprogram.db4o.sql.Sql4oException;
import com.spaceprogram.db4o.sql.query.OrderBy;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.query.WhereExpression;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlToSoda {
    public static boolean allowClassNotFound = true;

    public static List<Result> execute(ObjectContainer oc, SqlQuery q) throws Sql4oException {
        Query query = oc.query();
        for (int i = 0; i < q.getFrom().getClassRefs().size(); ++i) {
            ClassRef classRef = q.getFrom().getClassRefs().get(i);
            String className = classRef.getClassName();
            ReflectClass reflectClass = oc.ext().reflector().forName(className);
            if (reflectClass == null) {
                throw new Sql4oException("Class not stored: " + className);
            }
            query.constrain((Object)reflectClass);
            SqlToSoda.verifySelectFields(reflectClass, q);
            SqlToSoda.applyWhere(reflectClass, query, q);
            SqlToSoda.applyOrderBy(reflectClass, query, q);
        }
        ObjectSet results = query.execute();
        ObjectSetWrapper resultWrapper = new ObjectSetWrapper(oc, q, results);
        return resultWrapper;
    }

    private static void verifySelectFields(ReflectClass reflectClass, SqlQuery q) throws Sql4oException {
        List<String> selFields;
        if (q.getSelect() != null && (selFields = q.getSelect().getFields()) != null) {
            if (selFields.size() == 1 && selFields.get(0).equals("*")) {
                return;
            }
            ReflectField[] fields = ReflectHelper.getDeclaredFieldsInHeirarchy(reflectClass);
            for (int i = 0; i < selFields.size(); ++i) {
                String field = selFields.get(i);
                boolean fieldOk = false;
                for (int j = 0; j < fields.length; ++j) {
                    ReflectField reflectField = fields[j];
                    if (!reflectField.getName().equals(field)) continue;
                    fieldOk = true;
                    break;
                }
                if (fieldOk) continue;
                throw new Sql4oException("Field not found: " + field);
            }
        }
    }

    private static void applyWhere(ReflectClass reflectClass, Query dq, SqlQuery q) throws Sql4oException {
        if (q.getWhere() != null) {
            WhereExpression where = q.getWhere().getRoot();
            SqlToSoda.applyWhereRecursive(reflectClass, dq, q, where);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void applyWhereRecursive(ReflectClass reflectClass, Query dq, SqlQuery q, WhereExpression where) throws Sql4oException {
        try {
            List<WhereExpression> expressions = where.getExpressions();
            Constraint previousConstraint = null;
            if (!where.isRoot()) {
                // empty if block
            }
            for (int i = 0; i < expressions.size(); ++i) {
                WhereExpression whereExpression = expressions.get(i);
                if (whereExpression.getExpressions() != null && whereExpression.getExpressions().size() > 0) {
                    SqlToSoda.applyWhereRecursive(reflectClass, dq, q, whereExpression);
                    continue;
                }
                Constraint constraint = SqlToSoda.makeConstraint(reflectClass, dq, whereExpression, q);
                if (previousConstraint != null && whereExpression.getType().equalsIgnoreCase("OR")) {
                    previousConstraint.or(constraint);
                }
                previousConstraint = constraint;
            }
            if (where.isRoot()) return;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new Sql4oException("Could not apply where conditions.  Exception: " + e.getMessage());
        }
    }

    private static Constraint makeConstraint(ReflectClass reflectClass, Query dq, WhereExpression where, SqlQuery q) throws CloneNotSupportedException, Sql4oException {
        String[] fieldSplit = where.getField().split("\\.");
        Query sub = dq;
        ReflectField field = null;
        ReflectClass fieldClass = reflectClass;
        block2: for (int i = 0; i < fieldSplit.length; ++i) {
            String f = fieldSplit[i];
            if (i == 0) {
                List<ClassRef> froms = q.getFrom().getClassRefs();
                for (int j = 0; j < froms.size(); ++j) {
                    ClassRef classRef = froms.get(j);
                    String alias = classRef.getAlias();
                    if (alias != null && alias.equals(fieldSplit[0])) continue block2;
                }
            }
            if ((field = ReflectHelper.getDeclaredFieldInHeirarchy(fieldClass, f)) == null) {
                throw new Sql4oException("Field not found: " + where.getField());
            }
            fieldClass = field.getFieldType();
            sub = sub.descend(f);
        }
        if (field == null) {
            throw new Sql4oException("Field not found: " + where.getField());
        }
        Class c = JdkReflector.toNative((ReflectClass)fieldClass);
        Object val = null;
        try {
            val = SqlToSoda.convertStringToObjectValue(c, where);
        }
        catch (Exception e) {
            val = null;
        }
        if (val == null) {
            throw new Sql4oException("Could not create where condition value object! " + where.getValue() + " for field type " + fieldClass);
        }
        Constraint constraint = sub.constrain(val);
        SqlToSoda.applyOperator(reflectClass, constraint, where.getOperator(), dq, where, q);
        return constraint;
    }

    private static Object convertStringToObjectValue(Class to, WhereExpression where) throws Exception {
        String from = where.getValue();
        if (to == String.class) {
            from = SqlToSoda.cleanValue(from);
        } else if (to == Date.class) {
            from = SqlToSoda.cleanValue(from);
        }
        return Converter.convertFromString(to, from);
    }

    private static String cleanValue(String value) {
        value = value.replace("'", "");
        return value;
    }

    private static void applyOperator(ReflectClass reflectClass, Constraint constraint, String operator, Query dq, WhereExpression where, SqlQuery q) throws CloneNotSupportedException, Sql4oException {
        if (operator.equals(">")) {
            constraint.greater();
        } else if (operator.equals("<")) {
            constraint.smaller();
        } else if (operator.equals(">=")) {
            constraint.greater();
            WhereExpression where2 = (WhereExpression)where.clone();
            where2.setOperator("=");
            constraint.or(SqlToSoda.makeConstraint(reflectClass, dq, where2, q));
        } else if (operator.equals("<=")) {
            constraint.smaller();
            WhereExpression where2 = (WhereExpression)where.clone();
            where2.setOperator("=");
            constraint.or(SqlToSoda.makeConstraint(reflectClass, dq, where2, q));
        } else if (operator.equals("<>") || operator.equals("!=")) {
            constraint.not();
        } else {
            constraint.equal();
        }
    }

    private static void applyOrderBy(ReflectClass reflectClass, Query query, SqlQuery q) {
        OrderBy orderBy = q.getOrderBy();
        if (orderBy != null) {
            List<OrderBy.Field> fields = orderBy.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                OrderBy.Field field = fields.get(i);
                System.out.println("ordering by: " + field);
                if (field.isAscending()) {
                    query.descend(field.getName()).orderAscending();
                    continue;
                }
                query.descend(field.getName()).orderDescending();
            }
        }
    }
}

