/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericClass;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.reflect.jdk.JdkReflector;
import com.spaceprogram.db4o.Contact;
import com.spaceprogram.db4o.TestUtils;
import com.spaceprogram.db4o.sql.ContactTest;
import com.spaceprogram.db4o.sql.Converter;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Result;
import com.spaceprogram.db4o.sql.Sql4o;
import com.spaceprogram.db4o.sql.Sql4oException;
import com.spaceprogram.db4o.sql.Sql4oRuntimeException;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SqlTest
extends ContactTest {
    @Test
    public void testNoClass() throws Sql4oException, SqlParseException {
        this.initGenericObjects();
    }

    private void initGenericObjects() {
        GenericClass personClass = this.initGenericClass();
        ReflectField surname = personClass.getDeclaredField("surname");
        ReflectField birthdate = personClass.getDeclaredField("birthdate");
        Object person = personClass.newInstance();
        surname.set(person, (Object)"John");
        birthdate.set(person, (Object)new Date());
    }

    private GenericClass initGenericClass() {
        GenericReflector reflector = new GenericReflector(null, (Reflector)new JdkReflector(Thread.currentThread().getContextClassLoader()));
        GenericClass _objectIClass = (GenericClass)reflector.forClass(Object.class);
        GenericClass result = new GenericClass(reflector, null, "com.acme.Person", _objectIClass);
        result.initFields(this.fields(result, reflector));
        return result;
    }

    private GenericField[] fields(GenericClass personClass, GenericReflector reflector) {
        return new GenericField[]{new GenericField("surname", reflector.forClass(String.class), false, false, false), new GenericField("birthdate", reflector.forClass(Date.class), false, false, false), new GenericField("bestFriend", (ReflectClass)personClass, false, false, false)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryResults() throws SQLException, SqlParseException, ClassNotFoundException, Sql4oException {
        int sodaCount = 0;
        System.out.println("Soda query...");
        ObjectContainer oc = server.openClient();
        Query q = oc.query();
        q.constrain(Contact.class);
        q.descend("name").constrain((Object)"contact 2");
        q.descend("category").constrain((Object)"friends");
        long startTime = System.currentTimeMillis();
        ObjectSet results = q.execute();
        for (Object o : results) {
            Contact c = (Contact)o;
            System.out.println("got: " + c);
            ++sodaCount;
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        System.out.println("soda duration: " + duration);
        oc.close();
        int sqlCount = 0;
        System.out.println("SQL query");
        ObjectContainer oc2 = server.openClient();
        try {
            startTime = System.currentTimeMillis();
            String query = "select * from com.spaceprogram.db4o.Contact c where  name = 'contact 2' and  category = 'friends'";
            List<Result> results2 = Sql4o.execute(oc2, query);
            sqlCount = results2.size();
            TestUtils.displaySqlResults(results2);
            long endTime2 = System.currentTimeMillis();
            long duration2 = endTime2 - startTime;
            System.out.println("SQL duration: " + duration2);
        }
        finally {
            oc2.close();
        }
        Assert.assertEquals((Object)sodaCount, (Object)sqlCount);
    }

    @Test
    public void testSelectFieldsQuery() throws SqlParseException, Sql4oException {
        String query = "select name, age from com.spaceprogram.db4o.Contact c where name = 'contact 2' and  category = 'friends'";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)"contact 2", (Object)result.getObject(0));
        Assert.assertEquals((Object)20, (Object)result.getObject("age"));
    }

    @Test(expected=Sql4oRuntimeException.class)
    public void testFieldExceptions() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "select name, age from com.spaceprogram.db4o.Contact c where name = 'contact 2' and  category = 'friends'";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Result result = results.get(0);
        Object somefield = result.getObject("somefield");
    }

    @Test
    public void testAsteriskQuery() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "select * from com.spaceprogram.db4o.Contact c where name = 'contact 2' and  category = 'friends'";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)"contact 2", (Object)result.getObject("name"));
        Assert.assertEquals((Object)20, (Object)result.getObject("age"));
    }

    @Test
    public void testNoSelectQuery() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where name = 'contact 2' and  category = 'friends'";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)"contact 2", (Object)result.getObject("name"));
        Assert.assertEquals((Object)20, (Object)result.getObject("age"));
    }

    @Test
    public void testIntCondition() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where  age = 10 or age = 20 ";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)2, (Object)results.size());
        Result result = results.get(0);
        Assert.assertTrue((result.getObject("age").equals(10) || result.getObject("age").equals(20) ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerCondition() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where  id = 1 ";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)"contact 1", (Object)result.getObject("name"));
        Assert.assertEquals((Object)new Integer(1), (Object)result.getObject("id"));
    }

    @Test
    public void testLongCondition() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where  longField = 1 ";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)new Long(1L), (Object)result.getObject("longField"));
    }

    @Test
    public void testDoubleCondition() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where age = 20 and income = 50000.02";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)"contact 2", (Object)result.getObject("name"));
        Assert.assertEquals((Object)50000.02, (Object)result.getObject("income"));
    }

    @Test
    public void testDateCondition() throws SqlParseException, ClassNotFoundException, Sql4oException {
        int numDays = 6;
        Calendar cal = Calendar.getInstance();
        cal.add(6, -numDays);
        String query = "from com.spaceprogram.db4o.Contact c where birthDate > '" + Converter.df.format(cal.getTime()) + "' ";
        System.out.println("query: " + query);
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)(numDays + 1), (Object)results.size());
    }

    @Test
    public void testDoubleCondition2() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where age = 20 and doubleField = 50000.02";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)"contact 2", (Object)result.getObject("name"));
        Assert.assertEquals((Object)50000.02, (Object)result.getObject("income"));
    }

    @Test
    public void testComplexWhere1() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where (age = 10 or age = 20) and income = 50000.02";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)2, (Object)results.size());
        Result result = results.get(0);
        Assert.assertEquals((Object)50000.02, (Object)result.getObject("income"));
    }

    @Test
    public void testLessThan() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where income < 50000.03";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)5, (Object)results.size());
    }

    @Test
    public void testLessThanOrEqual() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where income <= 50000.02";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)5, (Object)results.size());
    }

    @Test
    public void testLessThanOrEqual2() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where income <= 50000.01";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)0, (Object)results.size());
    }

    @Test
    public void testGreaterThan() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where income > 50000.03";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)5, (Object)results.size());
    }

    @Test
    public void testGreaterThanOrEqual() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where income >= 50000.02";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)10, (Object)results.size());
    }

    @Test
    public void testGreaterThanOrEqual2() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where income >= 50000.03";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)5, (Object)results.size());
    }

    @Test(expected=Sql4oException.class)
    public void testInvalidField() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "select age, age2 from com.spaceprogram.db4o.Contact c where income >= 50000.03";
        List<Result> results = Sql4o.execute(this.oc, query);
        TestUtils.displaySqlResults(results);
        Assert.assertEquals((Object)5, (Object)results.size());
    }

    @Test
    public void testGetColumnNames() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "select id, age, income from com.spaceprogram.db4o.Contact c where income >= 50000.03";
        ObjectSetWrapper results = (ObjectSetWrapper)((Object)Sql4o.execute(this.oc, query));
        Assert.assertEquals((Object)3, (Object)results.getMetaData().getColumnCount());
        Assert.assertEquals((Object)"id", (Object)results.getMetaData().getColumnName(0));
        Assert.assertEquals((Object)"age", (Object)results.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"income", (Object)results.getMetaData().getColumnName(2));
    }

    @Test
    public void testOneDeep() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where c.address.id = 3";
        ObjectSetWrapper results = (ObjectSetWrapper)((Object)Sql4o.execute(this.oc, query));
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Contact c = (Contact)result.getBaseObject(0);
        Assert.assertEquals((Object)3, (Object)c.getAddress().getId());
    }

    @Test
    public void testTwoDeep() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c where c.address.city.id = 2";
        ObjectSetWrapper results = (ObjectSetWrapper)((Object)Sql4o.execute(this.oc, query));
        Assert.assertEquals((Object)1, (Object)results.size());
        Result result = results.get(0);
        Contact c = (Contact)result.getBaseObject(0);
        Assert.assertEquals((Object)2, (Object)c.getAddress().getCity().getId());
    }

    @Test
    public void testOrderingDescending() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c order by name desc";
        ObjectSetWrapper results = (ObjectSetWrapper)((Object)Sql4o.execute(this.oc, query));
        int i = results.size();
        Iterator i$ = results.iterator();
        while (i$.hasNext()) {
            Object resultOb = i$.next();
            Result result = (Result)resultOb;
            Contact c = (Contact)result.getBaseObject(0);
            Assert.assertEquals((Object)("contact " + (i - 1)), (Object)c.getName());
            --i;
        }
    }

    @Test
    public void testOrderingAscending() throws SqlParseException, ClassNotFoundException, Sql4oException {
        String query = "from com.spaceprogram.db4o.Contact c order by name asc";
        ObjectSetWrapper results = (ObjectSetWrapper)((Object)Sql4o.execute(this.oc, query));
        int i = 0;
        Iterator i$ = results.iterator();
        while (i$.hasNext()) {
            Object resultOb = i$.next();
            Result result = (Result)resultOb;
            Contact c = (Contact)result.getBaseObject(0);
            Assert.assertEquals((Object)("contact " + i), (Object)c.getName());
            ++i;
        }
    }
}

