/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql;

import com.spaceprogram.db4o.sql.SqlStatement;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.query.From;
import com.spaceprogram.db4o.sql.query.Select;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.query.Where;
import com.spaceprogram.db4o.sql.query.WhereExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlParser {
    private static String REGEX_QUOTED_STRING = "'[^']*'";
    public static final String REGEX_OPERATORS = "<=|>=|<>|=|<|>";
    private Builder[] builders = new Builder[]{new SelectBuilder(), new FromBuilder(), new WhereBuilder()};
    private String query;
    private List<String> quotedStrings = new ArrayList<String>();

    public static SqlStatement parse(String query) throws SqlParseException {
        SqlParser parser = new SqlParser();
        parser.setQuery(query);
        return parser.doParse();
    }

    private SqlStatement doParse() throws SqlParseException {
        this.query = this.replaceQuotedStrings(this.query);
        String[] split = this.query.trim().split("\\s+");
        if (split.length < 2) {
            throw new SqlParseException("Invalid query.");
        }
        SqlQuery sq = new SqlQuery();
        this.buildQuery(split, sq);
        if (sq.getFrom() == null) {
            throw new SqlParseException("No FROM part!");
        }
        return sq;
    }

    private String replaceQuotedStrings(String query) {
        StringBuffer buff = new StringBuffer(query);
        Pattern pattern = Pattern.compile(REGEX_QUOTED_STRING);
        Matcher matcher = pattern.matcher(buff);
        boolean found = false;
        int i = 0;
        while (matcher.find()) {
            this.quotedStrings.add(matcher.group());
            buff.replace(matcher.start(), matcher.end(), "{" + i + "}");
            matcher.reset();
            found = true;
            ++i;
        }
        if (!found) {
            // empty if block
        }
        String ret = buff.toString();
        return ret;
    }

    private void buildQuery(String[] split, SqlQuery sq) throws SqlParseException {
        Builder curBuilder = null;
        ArrayList<String> expr = new ArrayList<String>();
        for (String s : split) {
            Builder builder = this.getBuilder(s);
            if (builder != null) {
                if (curBuilder != null) {
                    curBuilder.build(sq, expr);
                }
                curBuilder = builder;
                expr.clear();
                continue;
            }
            expr.add(s);
        }
        if (expr.size() > 0) {
            if (curBuilder != null) {
                curBuilder.build(sq, expr);
            } else {
                throw new SqlParseException("Invalid Query. No FROM part.");
            }
        }
    }

    private Builder getBuilder(String s) {
        for (Builder builder : this.builders) {
            if (!s.equalsIgnoreCase(builder.getKeyword())) continue;
            return builder;
        }
        return null;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private String replaceQuotedValue(String value) {
        if (value.startsWith("{") && value.endsWith("}")) {
            int replacementIndex = Integer.parseInt(value.substring(1, value.length() - 1));
            return this.quotedStrings.get(replacementIndex);
        }
        return value;
    }

    private String stripQuotes(String s) {
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WhereBuilder
    implements Builder {
        final String keyword = "WHERE";

        WhereBuilder() {
        }

        @Override
        public String getKeyword() {
            return "WHERE";
        }

        @Override
        public void build(SqlQuery sq, List<String> expressionSplit) throws SqlParseException {
            Where where = new Where();
            this.buildExpr(where.getRoot(), expressionSplit, 0);
            sq.setWhere(where);
        }

        private int buildExpr(WhereExpression root, List<String> expressionSplit, int index) throws SqlParseException {
            int i;
            Pattern pattern = Pattern.compile(SqlParser.REGEX_OPERATORS);
            WhereExpression current = new WhereExpression();
            for (i = index; i < expressionSplit.size(); ++i) {
                String s = expressionSplit.get(i);
                if (s.startsWith("(")) {
                    String token;
                    if (s.equals("(")) {
                        token = s;
                    } else {
                        token = s.substring(1);
                        expressionSplit.add(i + 1, token);
                    }
                    ++i;
                    WhereExpression sub = new WhereExpression();
                    root.add(sub);
                    i = this.buildExpr(sub, expressionSplit, i);
                    continue;
                }
                if (s.equals(")")) {
                    return i;
                }
                if (s.equalsIgnoreCase("AND")) {
                    current = new WhereExpression("AND");
                    continue;
                }
                if (s.equalsIgnoreCase("OR")) {
                    current = new WhereExpression("OR");
                    continue;
                }
                Matcher matcher = pattern.matcher(s);
                List<MatchResult> matches = this.findMatches(matcher);
                int found = matches.size();
                String operator = null;
                String field = null;
                String value = null;
                int extraPiecesUsed = 0;
                if (found > 1) {
                    throw new SqlParseException("Too many operators in where expression: " + s);
                }
                if (found == 1) {
                    MatchResult matchResult = matches.get(0);
                    operator = matchResult.group();
                    field = s.substring(0, matchResult.start());
                    value = this.checkForNextPieceAttached(s, matchResult, operator);
                } else {
                    field = s;
                    if (expressionSplit.size() <= i + 1) {
                        throw new SqlParseException("Invalid where expression.");
                    }
                    String s2 = expressionSplit.get(i + 1);
                    Matcher matcher2 = pattern.matcher(s2);
                    List<MatchResult> matches2 = this.findMatches(matcher2);
                    int found2 = matches2.size();
                    if (found2 > 1) {
                        throw new SqlParseException("Too many operators in where expression: " + s);
                    }
                    if (found2 == 1) {
                        MatchResult matchResult = matches2.get(0);
                        operator = matchResult.group();
                        if (s2.length() > matchResult.end()) {
                            value = s2.substring(matchResult.end(), s2.length());
                        }
                    } else {
                        throw new SqlParseException("Operator not found in where expression.");
                    }
                    ++extraPiecesUsed;
                }
                if (value == null) {
                    value = expressionSplit.get(i + extraPiecesUsed + 1);
                    ++extraPiecesUsed;
                }
                if (value.endsWith(")")) {
                    value = value.substring(0, value.length() - 1);
                    expressionSplit.add(i + extraPiecesUsed + 1, ")");
                }
                value = SqlParser.this.replaceQuotedValue(value);
                i += extraPiecesUsed;
                if (field == null || field.length() < 1 || operator == null || operator.length() < 1 || value == null || value.length() < 1) {
                    throw new SqlParseException("Incomplete where expression.");
                }
                current.setField(field);
                current.setOperator(operator);
                current.setValue(value);
                root.add(current);
            }
            return i;
        }

        private String checkForNextPieceAttached(String s, MatchResult matcher, String operator) {
            String value = null;
            if (s.length() > matcher.end() + operator.length()) {
                value = s.substring(matcher.end(), s.length());
            }
            return value;
        }

        private List<MatchResult> findMatches(Matcher matcher) {
            ArrayList<MatchResult> ret = new ArrayList<MatchResult>();
            while (matcher.find()) {
                ret.add(matcher.toMatchResult());
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FromBuilder
    implements Builder {
        final String keyword = "FROM";

        FromBuilder() {
        }

        @Override
        public String getKeyword() {
            return "FROM";
        }

        @Override
        public void build(SqlQuery sq, List<String> expr) {
            From from = new From();
            for (int i = 0; i < expr.size(); ++i) {
                String s = expr.get(i);
                if (s.equals(",")) continue;
                if (s.endsWith(",")) {
                    from.addClass(SqlParser.this.stripQuotes(SqlParser.this.replaceQuotedValue(s.substring(0, s.length() - 1))));
                    continue;
                }
                if (i == expr.size() - 1) {
                    from.addClass(SqlParser.this.stripQuotes(SqlParser.this.replaceQuotedValue(s)));
                    continue;
                }
                if (expr.size() <= i + 1) continue;
                String s2 = expr.get(i + 1);
                if (s2.equals(",")) {
                    from.addClass(SqlParser.this.stripQuotes(SqlParser.this.replaceQuotedValue(s)));
                } else {
                    if (s2.endsWith(",")) {
                        s2 = s2.substring(0, s2.length());
                    }
                    from.addClass(SqlParser.this.stripQuotes(SqlParser.this.replaceQuotedValue(s)), s2);
                }
                ++i;
            }
            sq.setFrom(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SelectBuilder
    implements Builder {
        final String keyword = "SELECT";

        SelectBuilder() {
        }

        @Override
        public String getKeyword() {
            return "SELECT";
        }

        @Override
        public void build(SqlQuery sq, List<String> expr) {
            Select select = new Select();
            for (String s : expr) {
                String[] s2;
                if (s.equals(",")) continue;
                for (String s1 : s2 = s.split(",")) {
                    select.addField(s1);
                }
            }
            sq.setSelect(select);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Builder {
        public String getKeyword();

        public void build(SqlQuery var1, List<String> var2) throws SqlParseException;
    }
}

