/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.ObjectTranslator;
import com.db4o.config.TSerializable;
import com.db4o.reflect.ReflectClass;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Sql4o;
import com.spaceprogram.db4o.sql.Sql4oException;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class NetTest {
    public static String username = "myUser";
    public static String password = "myPass";
    public static int port = 11987;
    protected static ObjectServer server;
    protected ObjectContainer oc;

    @BeforeClass
    public static void setupDb() {
        System.out.println("Setup");
        Db4o.configure().exceptionsOnNotStorable(true);
        Db4o.configure().objectClass((Object)"java.math.BigDecimal").translate((ObjectTranslator)new TSerializable());
        Db4o.configure().allowVersionUpdates(true);
        server = Db4o.openServer((String)"resources/jap.net.yap", (int)port);
        server.grantAccess(username, password);
    }

    @AfterClass
    public static void tearDownAfter() {
        System.out.println("tearDownAfter");
        server.close();
    }

    @Before
    public void beforeEach() {
        System.out.println("beforeEach");
        this.oc = server.openClient();
    }

    @After
    public void afterEach() {
        System.out.println("afterEach");
        this.oc.close();
    }

    @Test
    public void checkStoredClasses() {
        List storedClasses = ReflectHelper.getUserStoredClasses(this.oc);
        for (int i = 0; i < storedClasses.size(); ++i) {
            ReflectClass storedClass = (ReflectClass)storedClasses.get(i);
            System.out.println("storedClass: " + storedClass.getName());
        }
    }

    @Test
    public void testClassLookup() {
        ReflectClass reflectClass = this.oc.ext().reflector().forName("Quizlet.Question, Quizlet.Framework");
        System.out.println("class: " + reflectClass);
        Assert.assertNotNull((Object)reflectClass);
    }

    @Test
    public void testDotNetQuery() throws Sql4oException, SqlParseException {
        String query = "FROM 'Quizlet.Question, Quizlet.Framework'";
        ObjectSetWrapper results = (ObjectSetWrapper)((Object)Sql4o.execute(this.oc, query));
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
    }
}

