/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.aggregate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedField {
    private String groupBy;
    private int counter = 0;
    private Number sum;
    private Number max;
    private Number min;

    public void add(Number n) {
        this.checkInit(n.getClass());
        if (n instanceof Double) {
            double in = n.doubleValue();
            double sum = this.sum.doubleValue();
            double max = this.max.doubleValue();
            double min = this.min.doubleValue();
            this.sum = sum += in;
            if (in > max) {
                max = in;
                this.max = max;
            }
            if (in < min) {
                min = in;
                this.min = min;
            }
        }
        ++this.counter;
    }

    private void checkInit(Class<? extends Number> aClass) {
        if (this.sum == null && aClass == Double.class) {
            this.sum = new Double(0.0);
            this.max = new Double(0.0);
            this.min = new Double(Double.MAX_VALUE);
        }
    }

    public Double getAverage() {
        if (this.sum != null && this.counter > 0) {
            return this.sum.doubleValue() / (double)this.counter;
        }
        return new Double(0.0);
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String toString() {
        return "count: " + this.counter + " sum: " + this.sum + " avg: " + this.getAverage() + " min: " + this.min + " max: " + this.max;
    }
}

